/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 82\u00020\u0001:\u00018B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\u0012\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u0007H&J\u0012\u0010\u001b\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u0007H&J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0019H\u0007J\u0012\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010!\u001a\u00020\u001dH'J%\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0019H\u0010\u00a2\u0006\u0002\b'J%\u0010(\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0019H\u0010\u00a2\u0006\u0002\b)J7\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u0000H\u0010\u00a2\u0006\u0004\b1\u00102J \u00103\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u0019H\u0007J\u0012\u00103\u001a\u00020\u001d2\b\b\u0001\u0010!\u001a\u00020\u001dH'J\b\u00104\u001a\u00020\u0003H\u0016J\u0013\u00105\u001a\u00020\u00152\b\u00106\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00107\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016\u00a8\u00069"}, d2={"Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "", "name", "", "model", "Landroidx/compose/ui/graphics/colorspace/ColorModel;", "id", "", "<init>", "(Ljava/lang/String;JILkotlin/jvm/internal/DefaultConstructorMarker;)V", "(Ljava/lang/String;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getName", "()Ljava/lang/String;", "getModel-xdoWZVw", "()J", "J", "getId$ui_graphics", "()I", "componentCount", "getComponentCount", "isWideGamut", "", "()Z", "isSrgb", "getMinValue", "", "component", "getMaxValue", "toXyz", "", "r", "g", "b", "v", "toXy", "", "v0", "v1", "v2", "toXy$ui_graphics", "toZ", "toZ$ui_graphics", "xyzaToColor", "Landroidx/compose/ui/graphics/Color;", "x", "y", "z", "a", "colorSpace", "xyzaToColor-JlNiLsg$ui_graphics", "(FFFFLandroidx/compose/ui/graphics/colorspace/ColorSpace;)J", "fromXyz", "toString", "equals", "other", "hashCode", "Companion", "ui-graphics"})
public abstract class ColorSpace {
    public static final Companion Companion = new Companion(null);
    private final String name;
    private final long model;
    private final int id;
    public static final int MinId = -1;
    public static final int MaxId = 63;

    private ColorSpace(String string, long l, int n) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.name = string;
        this.model = l;
        this.id = n;
        if (((CharSequence)this.name).length() == 0) {
            throw new IllegalArgumentException("The name of a color space cannot be null and must contain at least 1 character");
        }
        if (this.id < -1 || this.id > 63) {
            throw new IllegalArgumentException("The id must be between -1 and 63");
        }
    }

    public final String getName() {
        return this.name;
    }

    public final long getModel-xdoWZVw() {
        return this.model;
    }

    public final int getId$ui_graphics() {
        return this.id;
    }

    private ColorSpace(String string, long l) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this(string, l, -1, null);
    }

    public final int getComponentCount() {
        return ColorModel.getComponentCount-impl(this.model);
    }

    public abstract boolean isWideGamut();

    public boolean isSrgb() {
        return false;
    }

    public abstract float getMinValue(int var1);

    public abstract float getMaxValue(int var1);

    public final float[] toXyz(float f, float f2, float f3) {
        float[] fArray = new float[]{f, f2, f3};
        return this.toXyz(fArray);
    }

    public abstract float[] toXyz(float[] var1);

    public long toXy$ui_graphics(float f, float f2, float f3) {
        float[] fArray = this.toXyz(f, f2, f3);
        float f4 = fArray[0];
        float f5 = fArray[1];
        boolean bl = false;
        long l = Float.floatToRawIntBits(f4);
        long l2 = Float.floatToRawIntBits(f5);
        return l << 32 | l2 & 0xFFFFFFFFL;
    }

    public float toZ$ui_graphics(float f, float f2, float f3) {
        float[] fArray = this.toXyz(f, f2, f3);
        return fArray[2];
    }

    public long xyzaToColor-JlNiLsg$ui_graphics(float f, float f2, float f3, float f4, ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"");
        float[] fArray = this.fromXyz(f, f2, f3);
        return ColorKt.Color(fArray[0], fArray[1], fArray[2], f4, colorSpace);
    }

    public final float[] fromXyz(float f, float f2, float f3) {
        float[] fArray = new float[ColorModel.getComponentCount-impl(this.model)];
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        return this.fromXyz(fArray);
    }

    public abstract float[] fromXyz(float[] var1);

    public String toString() {
        return this.name + " (id=" + this.id + ", model=" + ColorModel.toString-impl(this.model) + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ColorSpace colorSpace = (ColorSpace)object;
        if (this.id != colorSpace.id) {
            return false;
        }
        return !Intrinsics.areEqual((Object)this.name, (Object)colorSpace.name) ? false : ColorModel.equals-impl0(this.model, colorSpace.model);
    }

    public int hashCode() {
        int n = this.name.hashCode();
        n = 31 * n + ColorModel.hashCode-impl(this.model);
        n = 31 * n + this.id;
        return n;
    }

    public /* synthetic */ ColorSpace(String string, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        this(string, l, n);
    }

    public /* synthetic */ ColorSpace(String string, long l, DefaultConstructorMarker defaultConstructorMarker) {
        this(string, l);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/graphics/colorspace/ColorSpace$Companion;", "", "<init>", "()V", "MinId", "", "MaxId", "ui-graphics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

