/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultAttributeMap
implements AttributeMap {
    private static final AtomicReferenceFieldUpdater<DefaultAttributeMap, DefaultAttribute[]> ATTRIBUTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultAttributeMap.class, DefaultAttribute[].class, "attributes");
    private static final DefaultAttribute[] EMPTY_ATTRIBUTES = new DefaultAttribute[0];
    private volatile DefaultAttribute[] attributes = EMPTY_ATTRIBUTES;

    private static int searchAttributeByKey(DefaultAttribute[] defaultAttributeArray, AttributeKey<?> attributeKey) {
        int n = 0;
        int n2 = defaultAttributeArray.length - 1;
        while (n <= n2) {
            boolean bl;
            int n3 = n + n2 >>> 1;
            DefaultAttribute defaultAttribute = defaultAttributeArray[n3];
            AttributeKey attributeKey2 = defaultAttribute.key;
            if (attributeKey2 == attributeKey) {
                return n3;
            }
            int n4 = attributeKey2.id();
            int n5 = attributeKey.id();
            assert (n4 != n5);
            boolean bl2 = bl = n4 < n5;
            if (bl) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return -(n + 1);
    }

    private static void orderedCopyOnInsert(DefaultAttribute[] defaultAttributeArray, int n, DefaultAttribute[] defaultAttributeArray2, DefaultAttribute defaultAttribute) {
        int n2;
        int n3 = defaultAttribute.key.id();
        for (n2 = n - 1; n2 >= 0; --n2) {
            DefaultAttribute defaultAttribute2 = defaultAttributeArray[n2];
            assert (defaultAttribute2.key.id() != n3);
            if (defaultAttribute2.key.id() < n3) break;
            defaultAttributeArray2[n2 + 1] = defaultAttributeArray[n2];
        }
        defaultAttributeArray2[n2 + 1] = defaultAttribute;
        int n4 = n2 + 1;
        if (n4 > 0) {
            System.arraycopy(defaultAttributeArray, 0, defaultAttributeArray2, 0, n4);
        }
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
        DefaultAttribute[] defaultAttributeArray;
        DefaultAttribute[] defaultAttributeArray2;
        ObjectUtil.checkNotNull(attributeKey, "key");
        DefaultAttribute<T> defaultAttribute = null;
        do {
            int n;
            if ((n = DefaultAttributeMap.searchAttributeByKey(defaultAttributeArray2 = this.attributes, attributeKey)) >= 0) {
                DefaultAttribute defaultAttribute2 = defaultAttributeArray2[n];
                assert (defaultAttribute2.key() == attributeKey);
                if (!defaultAttribute2.isRemoved()) {
                    return defaultAttribute2;
                }
                if (defaultAttribute == null) {
                    defaultAttribute = new DefaultAttribute<T>(this, attributeKey);
                }
                int n2 = defaultAttributeArray2.length;
                defaultAttributeArray = Arrays.copyOf(defaultAttributeArray2, n2);
                defaultAttributeArray[n] = defaultAttribute;
                continue;
            }
            if (defaultAttribute == null) {
                defaultAttribute = new DefaultAttribute<T>(this, attributeKey);
            }
            int n3 = defaultAttributeArray2.length;
            defaultAttributeArray = new DefaultAttribute[n3 + 1];
            DefaultAttributeMap.orderedCopyOnInsert(defaultAttributeArray2, n3, defaultAttributeArray, defaultAttribute);
        } while (!ATTRIBUTES_UPDATER.compareAndSet(this, defaultAttributeArray2, defaultAttributeArray));
        return defaultAttribute;
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> attributeKey) {
        ObjectUtil.checkNotNull(attributeKey, "key");
        return DefaultAttributeMap.searchAttributeByKey(this.attributes, attributeKey) >= 0;
    }

    private <T> void removeAttributeIfMatch(AttributeKey<T> attributeKey, DefaultAttribute<T> defaultAttribute) {
        DefaultAttribute[] defaultAttributeArray;
        DefaultAttribute[] defaultAttributeArray2;
        do {
            int n;
            if ((n = DefaultAttributeMap.searchAttributeByKey(defaultAttributeArray2 = this.attributes, attributeKey)) < 0) {
                return;
            }
            DefaultAttribute defaultAttribute2 = defaultAttributeArray2[n];
            assert (defaultAttribute2.key() == attributeKey);
            if (defaultAttribute2 != defaultAttribute) {
                return;
            }
            int n2 = defaultAttributeArray2.length;
            int n3 = n2 - 1;
            defaultAttributeArray = n3 == 0 ? EMPTY_ATTRIBUTES : new DefaultAttribute[n3];
            System.arraycopy(defaultAttributeArray2, 0, defaultAttributeArray, 0, n);
            int n4 = n2 - n - 1;
            if (n4 <= 0) continue;
            System.arraycopy(defaultAttributeArray2, n + 1, defaultAttributeArray, n, n4);
        } while (!ATTRIBUTES_UPDATER.compareAndSet(this, defaultAttributeArray2, defaultAttributeArray));
    }

    private static final class DefaultAttribute<T>
    extends AtomicReference<T>
    implements Attribute<T> {
        private static final AtomicReferenceFieldUpdater<DefaultAttribute, DefaultAttributeMap> MAP_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultAttribute.class, DefaultAttributeMap.class, "attributeMap");
        private static final long serialVersionUID = -2661411462200283011L;
        private volatile DefaultAttributeMap attributeMap;
        private final AttributeKey<T> key;

        DefaultAttribute(DefaultAttributeMap defaultAttributeMap, AttributeKey<T> attributeKey) {
            this.attributeMap = defaultAttributeMap;
            this.key = attributeKey;
        }

        @Override
        public AttributeKey<T> key() {
            return this.key;
        }

        private boolean isRemoved() {
            return this.attributeMap == null;
        }

        @Override
        public T setIfAbsent(T t) {
            while (!this.compareAndSet(null, t)) {
                Object v = this.get();
                if (v == null) continue;
                return (T)v;
            }
            return null;
        }

        @Override
        public T getAndRemove() {
            DefaultAttributeMap defaultAttributeMap = this.attributeMap;
            boolean bl = defaultAttributeMap != null && MAP_UPDATER.compareAndSet(this, defaultAttributeMap, null);
            T t = this.getAndSet(null);
            if (bl) {
                defaultAttributeMap.removeAttributeIfMatch(this.key, this);
            }
            return t;
        }

        @Override
        public void remove() {
            DefaultAttributeMap defaultAttributeMap = this.attributeMap;
            boolean bl = defaultAttributeMap != null && MAP_UPDATER.compareAndSet(this, defaultAttributeMap, null);
            this.set(null);
            if (bl) {
                defaultAttributeMap.removeAttributeIfMatch(this.key, this);
            }
        }
    }
}

