/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;

public final class SocketUtils {
    private static final Enumeration<Object> EMPTY = Collections.enumeration(Collections.emptyList());

    private SocketUtils() {
    }

    private static <T> Enumeration<T> empty() {
        return EMPTY;
    }

    public static void connect(final Socket socket, final SocketAddress socketAddress, final int n) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() {
                    socket.connect(socketAddress, n);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static void bind(final Socket socket, final SocketAddress socketAddress) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() {
                    socket.bind(socketAddress);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static boolean connect(final SocketChannel socketChannel, final SocketAddress socketAddress) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    return socketChannel.connect(socketAddress);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static void bind(final SocketChannel socketChannel, final SocketAddress socketAddress) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() {
                    socketChannel.bind(socketAddress);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static SocketChannel accept(final ServerSocketChannel serverSocketChannel) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<SocketChannel>(){

                @Override
                public SocketChannel run() {
                    return serverSocketChannel.accept();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static void bind(final DatagramChannel datagramChannel, final SocketAddress socketAddress) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() {
                    datagramChannel.bind(socketAddress);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static SocketAddress localSocketAddress(final ServerSocket serverSocket) {
        return AccessController.doPrivileged(new PrivilegedAction<SocketAddress>(){

            @Override
            public SocketAddress run() {
                return serverSocket.getLocalSocketAddress();
            }
        });
    }

    public static InetAddress addressByName(final String string) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress>(){

                @Override
                public InetAddress run() {
                    return InetAddress.getByName(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (UnknownHostException)privilegedActionException.getCause();
        }
    }

    public static InetAddress[] allAddressesByName(final String string) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress[]>(){

                @Override
                public InetAddress[] run() {
                    return InetAddress.getAllByName(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (UnknownHostException)privilegedActionException.getCause();
        }
    }

    public static InetSocketAddress socketAddress(final String string, final int n) {
        return AccessController.doPrivileged(new PrivilegedAction<InetSocketAddress>(){

            @Override
            public InetSocketAddress run() {
                return new InetSocketAddress(string, n);
            }
        });
    }

    public static Enumeration<InetAddress> addressesFromNetworkInterface(final NetworkInterface networkInterface) {
        Enumeration<InetAddress> enumeration = AccessController.doPrivileged(new PrivilegedAction<Enumeration<InetAddress>>(){

            @Override
            public Enumeration<InetAddress> run() {
                return networkInterface.getInetAddresses();
            }
        });
        if (enumeration == null) {
            return SocketUtils.empty();
        }
        return enumeration;
    }

    public static InetAddress loopbackAddress() {
        return AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){

            @Override
            public InetAddress run() {
                if (PlatformDependent.javaVersion() >= 7) {
                    return InetAddress.getLoopbackAddress();
                }
                try {
                    return InetAddress.getByName(null);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IllegalStateException(unknownHostException);
                }
            }
        });
    }

    public static byte[] hardwareAddressFromNetworkInterface(final NetworkInterface networkInterface) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() {
                    return networkInterface.getHardwareAddress();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (SocketException)privilegedActionException.getCause();
        }
    }
}

