/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.AbstractInternalLogger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

final class LocationAwareSlf4JLogger
extends AbstractInternalLogger {
    static final String FQCN = LocationAwareSlf4JLogger.class.getName();
    private static final long serialVersionUID = -8292030083201538180L;
    private final transient LocationAwareLogger logger;

    LocationAwareSlf4JLogger(LocationAwareLogger locationAwareLogger) {
        super(locationAwareLogger.getName());
        this.logger = locationAwareLogger;
    }

    private void log(int n, String string) {
        this.logger.log(null, FQCN, n, string, null, null);
    }

    private void log(int n, String string, Throwable throwable) {
        this.logger.log(null, FQCN, n, string, null, throwable);
    }

    private void log(int n, FormattingTuple formattingTuple) {
        this.logger.log(null, FQCN, n, formattingTuple.getMessage(), null, formattingTuple.getThrowable());
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String string) {
        if (this.isTraceEnabled()) {
            this.log(0, string);
        }
    }

    @Override
    public void trace(String string, Object object) {
        if (this.isTraceEnabled()) {
            this.log(0, MessageFormatter.format((String)string, (Object)object));
        }
    }

    @Override
    public void trace(String string, Object object, Object object2) {
        if (this.isTraceEnabled()) {
            this.log(0, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    @Override
    public void trace(String string, Object ... objectArray) {
        if (this.isTraceEnabled()) {
            this.log(0, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    @Override
    public void trace(String string, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.log(0, string, throwable);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String string) {
        if (this.isDebugEnabled()) {
            this.log(10, string);
        }
    }

    @Override
    public void debug(String string, Object object) {
        if (this.isDebugEnabled()) {
            this.log(10, MessageFormatter.format((String)string, (Object)object));
        }
    }

    @Override
    public void debug(String string, Object object, Object object2) {
        if (this.isDebugEnabled()) {
            this.log(10, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        if (this.isDebugEnabled()) {
            this.log(10, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    @Override
    public void debug(String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.log(10, string, throwable);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String string) {
        if (this.isInfoEnabled()) {
            this.log(20, string);
        }
    }

    @Override
    public void info(String string, Object object) {
        if (this.isInfoEnabled()) {
            this.log(20, MessageFormatter.format((String)string, (Object)object));
        }
    }

    @Override
    public void info(String string, Object object, Object object2) {
        if (this.isInfoEnabled()) {
            this.log(20, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    @Override
    public void info(String string, Object ... objectArray) {
        if (this.isInfoEnabled()) {
            this.log(20, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    @Override
    public void info(String string, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log(20, string, throwable);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String string) {
        if (this.isWarnEnabled()) {
            this.log(30, string);
        }
    }

    @Override
    public void warn(String string, Object object) {
        if (this.isWarnEnabled()) {
            this.log(30, MessageFormatter.format((String)string, (Object)object));
        }
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        if (this.isWarnEnabled()) {
            this.log(30, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    @Override
    public void warn(String string, Object object, Object object2) {
        if (this.isWarnEnabled()) {
            this.log(30, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    @Override
    public void warn(String string, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.log(30, string, throwable);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String string) {
        if (this.isErrorEnabled()) {
            this.log(40, string);
        }
    }

    @Override
    public void error(String string, Object object) {
        if (this.isErrorEnabled()) {
            this.log(40, MessageFormatter.format((String)string, (Object)object));
        }
    }

    @Override
    public void error(String string, Object object, Object object2) {
        if (this.isErrorEnabled()) {
            this.log(40, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    @Override
    public void error(String string, Object ... objectArray) {
        if (this.isErrorEnabled()) {
            this.log(40, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    @Override
    public void error(String string, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.log(40, string, throwable);
        }
    }
}

