/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.http.content;

import io.ktor.http.CodecsKt;
import io.ktor.http.ContentType;
import io.ktor.http.FileContentTypeKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.URIFileContent;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.http.content.JarFileContent;
import io.ktor.server.http.content.LocalFileContent;
import io.ktor.server.plugins.BadRequestException;
import io.ktor.server.util.PathsKt;
import io.ktor.utils.io.InternalAPI;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u001aG\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000b\u001aS\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t\u0018\u00010\u000e*\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0004\b\n\u0010\u000f\u001a5\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0013\u0010\u0016\u001a\u00020\u0001*\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a!\u0010\u0018\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\"'\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lio/ktor/server/application/ApplicationCall;", "", "path", "resourcePackage", "Ljava/lang/ClassLoader;", "classLoader", "Lkotlin/Function1;", "Lio/ktor/http/ContentType;", "mimeResolve", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "resolveResource", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/String;Ljava/lang/String;Ljava/lang/ClassLoader;Lkotlin/jvm/functions/Function1;)Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "Lio/ktor/server/application/Application;", "Ljava/net/URL;", "Lkotlin/Pair;", "(Lio/ktor/server/application/Application;Ljava/lang/String;Ljava/lang/String;Ljava/lang/ClassLoader;Lkotlin/jvm/functions/Function1;)Lkotlin/Pair;", "url", "resourceClasspathResource", "(Ljava/net/URL;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "Ljava/io/File;", "findContainingJarFile", "(Ljava/lang/String;)Ljava/io/File;", "extension", "(Ljava/lang/String;)Ljava/lang/String;", "normalisedPath", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "Ljava/util/concurrent/ConcurrentHashMap;", "resourceCache$delegate", "Lkotlin/Lazy;", "getResourceCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "resourceCache", "ktor-server-core"})
public final class StaticContentResolutionKt {
    private static final Lazy resourceCache$delegate = LazyKt.lazy(StaticContentResolutionKt::resourceCache_delegate$lambda$3);

    public static final OutgoingContent.ReadChannelContent resolveResource(ApplicationCall applicationCall, String string, String string2, ClassLoader classLoader, Function1<? super String, ContentType> function1) {
        Intrinsics.checkNotNullParameter((Object)applicationCall, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        if (StringsKt.endsWith$default((String)string, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)string, (String)"\\", (boolean)false, (int)2, null)) {
            return null;
        }
        String string3 = StaticContentResolutionKt.normalisedPath(string2, string);
        Enumeration<URL> enumeration = classLoader.getResources(string3);
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"");
        for (URL uRL : SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration))) {
            Intrinsics.checkNotNull((Object)uRL);
            OutgoingContent.ReadChannelContent readChannelContent = StaticContentResolutionKt.resourceClasspathResource(uRL, string3, (Function1<? super URL, ContentType>)((Function1)arg_0 -> StaticContentResolutionKt.resolveResource$lambda$1(function1, arg_0)));
            if (readChannelContent == null) continue;
            OutgoingContent.ReadChannelContent readChannelContent2 = readChannelContent;
            boolean bl = false;
            return readChannelContent2;
        }
        return null;
    }

    public static /* synthetic */ OutgoingContent.ReadChannelContent resolveResource$default(ApplicationCall applicationCall, String string, String string2, ClassLoader classLoader, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            classLoader = applicationCall.getApplication().getEnvironment().getClassLoader();
        }
        if ((n & 8) != 0) {
            function1 = StaticContentResolutionKt::resolveResource$lambda$0;
        }
        return StaticContentResolutionKt.resolveResource(applicationCall, string, string2, classLoader, (Function1<? super String, ContentType>)function1);
    }

    private static final ConcurrentHashMap<String, URL> getResourceCache() {
        Lazy lazy = resourceCache$delegate;
        return (ConcurrentHashMap)lazy.getValue();
    }

    public static final Pair<URL, OutgoingContent.ReadChannelContent> resolveResource(Application application, String string, String string2, ClassLoader classLoader, Function1<? super URL, ContentType> function1) {
        Intrinsics.checkNotNullParameter((Object)((Object)application), (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        if (StringsKt.endsWith$default((String)string, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)string, (String)"\\", (boolean)false, (int)2, null)) {
            return null;
        }
        String string3 = StaticContentResolutionKt.normalisedPath(string2, string);
        String string4 = "" + classLoader.hashCode() + '/' + string3;
        Function1 function12 = arg_0 -> StaticContentResolutionKt.resolveResource$lambda$5(string3, function1, arg_0);
        URL uRL = StaticContentResolutionKt.getResourceCache().get(string4);
        if (uRL == null || (uRL = (Pair)function12.invoke((Object)uRL)) == null) {
            Object object;
            Iterator iterator;
            block5: {
                Enumeration<URL> enumeration = classLoader.getResources(string3);
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"");
                iterator = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)).iterator();
                while (iterator.hasNext()) {
                    Object object2 = function12.invoke(iterator.next());
                    if (object2 == null) continue;
                    object = object2;
                    break block5;
                }
                object = null;
            }
            Pair pair = (Pair)object;
            if (pair != null) {
                Pair pair2 = pair;
                iterator = pair2;
                boolean bl = false;
                URL uRL2 = (URL)iterator.component1();
                ((Map)StaticContentResolutionKt.getResourceCache()).put(string4, uRL2);
                uRL = pair2;
            } else {
                uRL = null;
            }
        }
        return uRL;
    }

    public static /* synthetic */ Pair resolveResource$default(Application application, String string, String string2, ClassLoader classLoader, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            classLoader = application.getEnvironment().getClassLoader();
        }
        return StaticContentResolutionKt.resolveResource(application, string, string2, classLoader, (Function1<? super URL, ContentType>)function1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalAPI
    public static final OutgoingContent.ReadChannelContent resourceClasspathResource(URL uRL, String string, Function1<? super URL, ContentType> function1) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        String string2 = uRL.getProtocol();
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case 3143036: {
                if (string2.equals("file")) {
                    n = 1;
                }
                break;
            }
            case -341064690: {
                if (string2.equals("resource")) {
                    n = 2;
                }
                break;
            }
            case 104987: {
                if (string2.equals("jar")) {
                    n = 3;
                }
                break;
            }
            case 105516: {
                if (string2.equals("jrt")) {
                    n = 2;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                String string3 = uRL.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                File file2 = new File(CodecsKt.decodeURLPart$default((String)string3, (int)0, (int)0, null, (int)7, null));
                OutgoingContent.ReadChannelContent readChannelContent = file2.isFile() ? new LocalFileContent(file2, (ContentType)function1.invoke((Object)uRL)) : null;
                return readChannelContent;
            }
            case 3: {
                JarFileContent jarFileContent;
                if (StringsKt.endsWith$default((String)string, (String)"/", (boolean)false, (int)2, null)) {
                    jarFileContent = null;
                } else {
                    String string4 = uRL.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
                    File file3 = StaticContentResolutionKt.findContainingJarFile(string4);
                    JarFileContent jarFileContent2 = new JarFileContent(file3, string, (ContentType)function1.invoke((Object)uRL));
                    jarFileContent = jarFileContent2.isFile() ? jarFileContent2 : null;
                }
                OutgoingContent.ReadChannelContent readChannelContent = jarFileContent;
                return readChannelContent;
            }
            case 2: {
                OutgoingContent.ReadChannelContent readChannelContent = (OutgoingContent.ReadChannelContent)new URIFileContent(uRL, (ContentType)function1.invoke((Object)uRL));
                return readChannelContent;
            }
            default: {
                return null;
            }
        }
    }

    public static final File findContainingJarFile(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (StringsKt.startsWith$default((String)string, (String)"jar:file:", (boolean)false, (int)2, null)) {
            int n = StringsKt.indexOf$default((CharSequence)string, (String)"!", (int)9, (boolean)false, (int)4, null);
            if (!(n != -1)) {
                boolean bl = false;
                String string2 = "Jar path requires !/ separator but it is: " + string;
                throw new IllegalArgumentException(string2.toString());
            }
            String string3 = string.substring(9, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            return new File(CodecsKt.decodeURLPart$default((String)string3, (int)0, (int)0, null, (int)7, null));
        }
        throw new IllegalArgumentException("Only local jars are supported (jar:file:)");
    }

    public static final String extension(String string) {
        String string2;
        int n;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Integer n2 = StringsKt.lastIndexOf$default((CharSequence)string, (char)'/', (int)0, (boolean)false, (int)6, null);
        int n3 = ((Number)n2).intValue();
        int n4 = 0;
        Integer n5 = n3 != -1 ? n2 : null;
        if (n5 != null) {
            n = n5;
        } else {
            Integer n6 = StringsKt.lastIndexOf$default((CharSequence)string, (char)'\\', (int)0, (boolean)false, (int)6, null);
            n4 = ((Number)n6).intValue();
            boolean bl = false;
            Integer n7 = n4 != -1 ? n6 : null;
            n = n7 != null ? n7 : 0;
        }
        int n8 = n;
        int n9 = StringsKt.indexOf$default((CharSequence)string, (char)'.', (int)n8, (boolean)false, (int)4, null);
        if (n9 >= 0) {
            String string3 = string.substring(n9);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
        } else {
            string2 = "";
        }
        return string2;
    }

    private static final String normalisedPath(String string, String string2) {
        char[] cArray = new char[]{'/', '\\'};
        List list = StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (list.contains("..")) {
            throw new BadRequestException("Relative path should not contain path traversing characters: " + string2, null, 2, null);
        }
        String string3 = string;
        if (string3 == null) {
            string3 = "";
        }
        cArray = new char[]{'.', '/', '\\'};
        return CollectionsKt.joinToString$default((Iterable)PathsKt.normalizePathComponents(CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)string3, (char[])cArray, (boolean)false, (int)0, (int)6, null), (Iterable)list)), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    private static final ContentType resolveResource$lambda$0(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return FileContentTypeKt.defaultForFileExtension((ContentType.Companion)ContentType.Companion, (String)string);
    }

    private static final ContentType resolveResource$lambda$1(Function1 function1, URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"");
        String string = uRL.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return (ContentType)function1.invoke((Object)StaticContentResolutionKt.extension(string));
    }

    private static final ConcurrentHashMap resourceCache_delegate$lambda$3() {
        return new ConcurrentHashMap();
    }

    private static final Pair resolveResource$lambda$5(String string, Function1 function1, URL uRL) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"");
        OutgoingContent.ReadChannelContent readChannelContent = StaticContentResolutionKt.resourceClasspathResource(uRL, string, (Function1<? super URL, ContentType>)function1);
        if (readChannelContent != null) {
            OutgoingContent.ReadChannelContent readChannelContent2 = readChannelContent;
            boolean bl = false;
            pair = TuplesKt.to((Object)uRL, (Object)readChannelContent2);
        } else {
            pair = null;
        }
        return pair;
    }
}

