/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.util;

import io.ktor.util.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\u001a\u001d\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000*\b\u0012\u0004\u0012\u00020\u00010\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a'\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000*\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a!\u0010\u000b\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0013\u0010\u000e\u001a\u00020\r*\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001c\u0010\u0016\u001a\u00020\r*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0082\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\"\u0014\u0010\u0018\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\"\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\"\u0014\u0010\u001d\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0019\u00a8\u0006\u001e"}, d2={"", "", "normalizePathComponents", "(Ljava/util/List;)Ljava/util/List;", "", "startIndex", "filterComponentsImpl", "(Ljava/util/List;I)Ljava/util/List;", "", "component", "", "processAndReplaceComponent", "(Ljava/util/List;Ljava/lang/String;)V", "", "shouldBeReplaced", "(Ljava/lang/String;)Z", "", "", "toASCIITable", "([C)[Z", "", "char", "contains", "([ZC)Z", "FirstReservedLetters", "[Z", "", "ReservedWords", "Ljava/util/Set;", "ReservedCharacters", "ktor-server-core"})
public final class PathsKt {
    private static final boolean[] FirstReservedLetters;
    private static final Set<String> ReservedWords;
    private static final boolean[] ReservedCharacters;

    public static final List<String> normalizePathComponents(List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        int n = ((Collection)list).size();
        for (int j = 0; j < n; ++j) {
            String string = list.get(j);
            if (!PathsKt.shouldBeReplaced(string)) continue;
            return PathsKt.filterComponentsImpl(list, j);
        }
        return list;
    }

    private static final List<String> filterComponentsImpl(List<String> list, int n) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        if (n > 0) {
            arrayList.addAll((Collection)list.subList(0, n));
        }
        PathsKt.processAndReplaceComponent((List<String>)arrayList, list.get(n));
        int n2 = list.size();
        for (int j = n + 1; j < n2; ++j) {
            String string = list.get(j);
            if (PathsKt.shouldBeReplaced(string)) {
                PathsKt.processAndReplaceComponent((List<String>)arrayList, string);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private static final void processAndReplaceComponent(List<String> list, String string) {
        block7: {
            String string2;
            CharSequence charSequence;
            String string3;
            block6: {
                char c2;
                int n;
                if (((CharSequence)string).length() == 0 || Intrinsics.areEqual((Object)string, (Object)".") || Intrinsics.areEqual((Object)string, (Object)"~") || ReservedWords.contains(TextKt.toUpperCasePreservingASCIIRules((String)string))) {
                    return;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"..")) {
                    if (!((Collection)list).isEmpty()) {
                        list.remove(CollectionsKt.getLastIndex(list));
                    }
                    return;
                }
                string3 = string;
                boolean bl = false;
                CharSequence charSequence2 = string3;
                Appendable appendable = new StringBuilder();
                int n2 = 0;
                int n3 = charSequence2.length();
                for (n = 0; n < n3; ++n) {
                    char c3 = c2 = charSequence2.charAt(n);
                    boolean bl2 = false;
                    if (!(Intrinsics.compare((int)c3, (int)32) >= 0 && !PathsKt.contains(ReservedCharacters, c3))) continue;
                    appendable.append(c2);
                }
                string3 = ((StringBuilder)appendable).toString();
                bl = false;
                charSequence2 = string3;
                boolean bl3 = false;
                n2 = charSequence2.length() + -1;
                if (0 <= n2) {
                    do {
                        n = n2--;
                        n3 = charSequence2.charAt(n);
                        c2 = '\u0000';
                        if (n3 == 32 || n3 == 46) continue;
                        charSequence = charSequence2.subSequence(0, n + 1);
                        break block6;
                    } while (0 <= n2);
                }
                charSequence = "";
            }
            String string4 = string3 = ((Object)charSequence).toString();
            boolean bl = false;
            String string5 = string2 = ((CharSequence)string4).length() > 0 ? string3 : null;
            if (string2 == null) break block7;
            string4 = string2;
            bl = false;
            list.add(string4);
        }
    }

    private static final boolean shouldBeReplaced(String string) {
        boolean bl;
        block8: {
            int n = string.length();
            if (n == 0) {
                return true;
            }
            char c2 = string.charAt(0);
            if (c2 == '.' && (n == 1 || n == 2 && string.charAt(1) == '.')) {
                return true;
            }
            if (c2 == '~' && n == 1) {
                return true;
            }
            if (PathsKt.contains(FirstReservedLetters, c2) && (ReservedWords.contains(string) || ReservedWords.contains(TextKt.toUpperCasePreservingASCIIRules((String)string)))) {
                return true;
            }
            char c3 = string.charAt(n - 1);
            switch (c3) {
                case ' ': 
                case '.': {
                    return true;
                }
            }
            boolean[] blArray = ReservedCharacters;
            CharSequence charSequence = string;
            boolean bl2 = false;
            for (int j = 0; j < charSequence.length(); ++j) {
                char c4;
                char c5 = c4 = charSequence.charAt(j);
                boolean bl3 = false;
                if (!(Intrinsics.compare((int)c5, (int)32) < 0 || PathsKt.contains(blArray, c5))) continue;
                bl = true;
                break block8;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean[] toASCIITable(char[] cArray) {
        int n = 0;
        boolean[] blArray = new boolean[256];
        while (n < 256) {
            int n2 = n++;
            blArray[n2] = ArraysKt.contains((char[])cArray, (char)((char)n2));
        }
        return blArray;
    }

    private static final boolean contains(boolean[] blArray, char c2) {
        Intrinsics.checkNotNullParameter((Object)blArray, (String)"");
        char c3 = c2;
        return c3 < blArray.length && blArray[c3];
    }

    static {
        Object[] objectArray = new char[]{'A', 'a', 'C', 'c', 'l', 'L', 'P', 'p', 'n', 'N'};
        FirstReservedLetters = PathsKt.toASCIITable(objectArray);
        objectArray = new String[22];
        objectArray[0] = (char)"CON";
        objectArray[1] = (char)"PRN";
        objectArray[2] = (char)"AUX";
        objectArray[3] = (char)"NUL";
        objectArray[4] = (char)"COM1";
        objectArray[5] = (char)"COM2";
        objectArray[6] = (char)"COM3";
        objectArray[7] = (char)"COM4";
        objectArray[8] = (char)"COM5";
        objectArray[9] = (char)"COM6";
        objectArray[10] = (char)"COM7";
        objectArray[11] = (char)"COM8";
        objectArray[12] = (char)"COM9";
        objectArray[13] = (char)"LPT1";
        objectArray[14] = (char)"LPT2";
        objectArray[15] = (char)"LPT3";
        objectArray[16] = (char)"LPT4";
        objectArray[17] = (char)"LPT5";
        objectArray[18] = (char)"LPT6";
        objectArray[19] = (char)"LPT7";
        objectArray[20] = (char)"LPT8";
        objectArray[21] = (char)"LPT9";
        ReservedWords = SetsKt.setOf((Object[])objectArray);
        objectArray = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
        ReservedCharacters = PathsKt.toASCIITable(objectArray);
    }
}

