/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.ServerChannel;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class AbstractKQueueServerChannel
extends AbstractKQueueChannel
implements ServerChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);

    AbstractKQueueServerChannel(BsdSocket bsdSocket) {
        this(bsdSocket, AbstractKQueueServerChannel.isSoErrorZero(bsdSocket));
    }

    AbstractKQueueServerChannel(BsdSocket bsdSocket, boolean bl) {
        super(null, bsdSocket, bl);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof KQueueEventLoop;
    }

    @Override
    protected InetSocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueServerSocketUnsafe();
    }

    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        throw new UnsupportedOperationException();
    }

    protected Object filterOutboundMessage(Object object) {
        throw new UnsupportedOperationException();
    }

    abstract Channel newChildChannel(int var1, byte[] var2, int var3, int var4);

    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        throw new UnsupportedOperationException();
    }

    final class KQueueServerSocketUnsafe
    extends AbstractKQueueChannel.AbstractKQueueUnsafe {
        private final byte[] acceptedAddress = new byte[26];

        KQueueServerSocketUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void readReady(KQueueRecvByteAllocatorHandle kQueueRecvByteAllocatorHandle) {
            assert (AbstractKQueueServerChannel.this.eventLoop().inEventLoop());
            KQueueChannelConfig kQueueChannelConfig = AbstractKQueueServerChannel.this.config();
            if (AbstractKQueueServerChannel.this.shouldBreakReadReady((ChannelConfig)kQueueChannelConfig)) {
                this.clearReadFilter0();
                return;
            }
            ChannelPipeline channelPipeline = AbstractKQueueServerChannel.this.pipeline();
            kQueueRecvByteAllocatorHandle.reset((ChannelConfig)kQueueChannelConfig);
            kQueueRecvByteAllocatorHandle.attemptedBytesRead(1);
            this.readReadyBefore();
            Throwable throwable = null;
            try {
                try {
                    do {
                        int n;
                        if ((n = AbstractKQueueServerChannel.this.socket.accept(this.acceptedAddress)) == -1) {
                            kQueueRecvByteAllocatorHandle.lastBytesRead(-1);
                            break;
                        }
                        kQueueRecvByteAllocatorHandle.lastBytesRead(1);
                        kQueueRecvByteAllocatorHandle.incMessagesRead(1);
                        this.readPending = false;
                        channelPipeline.fireChannelRead((Object)AbstractKQueueServerChannel.this.newChildChannel(n, this.acceptedAddress, 1, this.acceptedAddress[0]));
                    } while (kQueueRecvByteAllocatorHandle.continueReading());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                kQueueRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (throwable != null) {
                    channelPipeline.fireExceptionCaught(throwable);
                }
            }
            finally {
                this.readReadyFinally((ChannelConfig)kQueueChannelConfig);
            }
        }
    }
}

