/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.FileRegion;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.SocketWritableByteChannel;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Executor;

public abstract class AbstractKQueueStreamChannel
extends AbstractKQueueChannel
implements DuplexChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractKQueueStreamChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DefaultFileRegion.class) + ')';
    private WritableByteChannel byteChannel;
    private final Runnable flushTask = new Runnable(){

        @Override
        public void run() {
            ((AbstractKQueueChannel.AbstractKQueueUnsafe)AbstractKQueueStreamChannel.this.unsafe()).flush0();
        }
    };

    AbstractKQueueStreamChannel(Channel channel, BsdSocket bsdSocket, boolean bl) {
        super(channel, bsdSocket, bl);
    }

    AbstractKQueueStreamChannel(Channel channel, BsdSocket bsdSocket, SocketAddress socketAddress) {
        super(channel, bsdSocket, socketAddress);
    }

    AbstractKQueueStreamChannel(BsdSocket bsdSocket) {
        this(null, bsdSocket, AbstractKQueueStreamChannel.isSoErrorZero(bsdSocket));
    }

    @Override
    protected AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueStreamUnsafe();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    private int writeBytes(ChannelOutboundBuffer channelOutboundBuffer, ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (n == 0) {
            channelOutboundBuffer.remove();
            return 0;
        }
        if (byteBuf.hasMemoryAddress() || byteBuf.nioBufferCount() == 1) {
            return this.doWriteBytes(channelOutboundBuffer, byteBuf);
        }
        ByteBuffer[] byteBufferArray = byteBuf.nioBuffers();
        return this.writeBytesMultiple(channelOutboundBuffer, byteBufferArray, byteBufferArray.length, n, this.config().getMaxBytesPerGatheringWrite());
    }

    private void adjustMaxBytesPerGatheringWrite(long l, long l2, long l3) {
        if (l == l2) {
            if (l << 1 > l3) {
                this.config().setMaxBytesPerGatheringWrite(l << 1);
            }
        } else if (l > 4096L && l2 < l >>> 1) {
            this.config().setMaxBytesPerGatheringWrite(l >>> 1);
        }
    }

    private int writeBytesMultiple(ChannelOutboundBuffer channelOutboundBuffer, IovArray iovArray) {
        long l = iovArray.size();
        assert (l != 0L);
        int n = iovArray.count();
        assert (n != 0);
        long l2 = this.socket.writevAddresses(iovArray.memoryAddress(0), n);
        if (l2 > 0L) {
            this.adjustMaxBytesPerGatheringWrite(l, l2, iovArray.maxBytes());
            channelOutboundBuffer.removeBytes(l2);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private int writeBytesMultiple(ChannelOutboundBuffer channelOutboundBuffer, ByteBuffer[] byteBufferArray, int n, long l, long l2) {
        long l3;
        assert (l != 0L);
        if (l > l2) {
            l = l2;
        }
        if ((l3 = this.socket.writev(byteBufferArray, 0, n, l)) > 0L) {
            this.adjustMaxBytesPerGatheringWrite(l, l3, l2);
            channelOutboundBuffer.removeBytes(l3);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private int writeDefaultFileRegion(ChannelOutboundBuffer channelOutboundBuffer, DefaultFileRegion defaultFileRegion) {
        long l = defaultFileRegion.count();
        long l2 = defaultFileRegion.transferred();
        if (l2 >= l) {
            channelOutboundBuffer.remove();
            return 0;
        }
        long l3 = this.socket.sendFile(defaultFileRegion, defaultFileRegion.position(), l2, l - l2);
        if (l3 > 0L) {
            channelOutboundBuffer.progress(l3);
            if (defaultFileRegion.transferred() >= l) {
                channelOutboundBuffer.remove();
            }
            return 1;
        }
        if (l3 == 0L) {
            this.validateFileRegion(defaultFileRegion, l2);
        }
        return Integer.MAX_VALUE;
    }

    private int writeFileRegion(ChannelOutboundBuffer channelOutboundBuffer, FileRegion fileRegion) {
        long l;
        if (fileRegion.transferred() >= fileRegion.count()) {
            channelOutboundBuffer.remove();
            return 0;
        }
        if (this.byteChannel == null) {
            this.byteChannel = new KQueueSocketWritableByteChannel();
        }
        if ((l = fileRegion.transferTo(this.byteChannel, fileRegion.transferred())) > 0L) {
            channelOutboundBuffer.progress(l);
            if (fileRegion.transferred() >= fileRegion.count()) {
                channelOutboundBuffer.remove();
            }
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        int n = this.config().getWriteSpinCount();
        do {
            int n2;
            if ((n2 = channelOutboundBuffer.size()) > 1 && channelOutboundBuffer.current() instanceof ByteBuf) {
                n -= this.doWriteMultiple(channelOutboundBuffer);
                continue;
            }
            if (n2 == 0) {
                this.writeFilter(false);
                return;
            }
            n -= this.doWriteSingle(channelOutboundBuffer);
        } while (n > 0);
        if (n == 0) {
            this.writeFilter(false);
            this.eventLoop().execute(this.flushTask);
        } else {
            this.writeFilter(true);
        }
    }

    protected int doWriteSingle(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object = channelOutboundBuffer.current();
        if (object instanceof ByteBuf) {
            return this.writeBytes(channelOutboundBuffer, (ByteBuf)object);
        }
        if (object instanceof DefaultFileRegion) {
            return this.writeDefaultFileRegion(channelOutboundBuffer, (DefaultFileRegion)object);
        }
        if (object instanceof FileRegion) {
            return this.writeFileRegion(channelOutboundBuffer, (FileRegion)object);
        }
        throw new Error();
    }

    private int doWriteMultiple(ChannelOutboundBuffer channelOutboundBuffer) {
        long l = this.config().getMaxBytesPerGatheringWrite();
        IovArray iovArray = ((KQueueEventLoop)this.eventLoop()).cleanArray();
        iovArray.maxBytes(l);
        channelOutboundBuffer.forEachFlushedMessage((ChannelOutboundBuffer.MessageProcessor)iovArray);
        if (iovArray.count() >= 1) {
            return this.writeBytesMultiple(channelOutboundBuffer, iovArray);
        }
        channelOutboundBuffer.removeBytes(0L);
        return 0;
    }

    protected Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            return UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf) ? this.newDirectBuffer(byteBuf) : byteBuf;
        }
        if (object instanceof FileRegion) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)object) + EXPECTED_TYPES);
    }

    protected final void doShutdownOutput() {
        this.socket.shutdown(false, true);
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isShutdown() {
        return this.socket.isShutdown();
    }

    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    public ChannelFuture shutdownOutput(final ChannelPromise channelPromise) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            ((AbstractChannel.AbstractUnsafe)this.unsafe()).shutdownOutput(channelPromise);
        } else {
            eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    ((AbstractChannel.AbstractUnsafe)AbstractKQueueStreamChannel.this.unsafe()).shutdownOutput(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    public ChannelFuture shutdownInput(final ChannelPromise channelPromise) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.shutdownInput0(channelPromise);
        } else {
            eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractKQueueStreamChannel.this.shutdownInput0(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.socket.shutdown(true, false);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return;
        }
        channelPromise.setSuccess();
    }

    public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    public ChannelFuture shutdown(final ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.shutdownOutput();
        if (channelFuture.isDone()) {
            this.shutdownOutputDone(channelFuture, channelPromise);
        } else {
            channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    AbstractKQueueStreamChannel.this.shutdownOutputDone(channelFuture, channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void shutdownOutputDone(final ChannelFuture channelFuture, final ChannelPromise channelPromise) {
        ChannelFuture channelFuture2 = this.shutdownInput();
        if (channelFuture2.isDone()) {
            AbstractKQueueStreamChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
        } else {
            channelFuture2.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture2) {
                    AbstractKQueueStreamChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
                }
            });
        }
    }

    private static void shutdownDone(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        Throwable throwable2 = channelFuture2.cause();
        if (throwable != null) {
            if (throwable2 != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", throwable2);
            }
            channelPromise.setFailure(throwable);
        } else if (throwable2 != null) {
            channelPromise.setFailure(throwable2);
        } else {
            channelPromise.setSuccess();
        }
    }

    private final class KQueueSocketWritableByteChannel
    extends SocketWritableByteChannel {
        KQueueSocketWritableByteChannel() {
            super((FileDescriptor)AbstractKQueueStreamChannel.this.socket);
        }

        protected ByteBufAllocator alloc() {
            return AbstractKQueueStreamChannel.this.alloc();
        }
    }

    class KQueueStreamUnsafe
    extends AbstractKQueueChannel.AbstractKQueueUnsafe {
        KQueueStreamUnsafe() {
        }

        protected Executor prepareToClose() {
            return super.prepareToClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void readReady(KQueueRecvByteAllocatorHandle kQueueRecvByteAllocatorHandle) {
            KQueueChannelConfig kQueueChannelConfig = AbstractKQueueStreamChannel.this.config();
            if (AbstractKQueueStreamChannel.this.shouldBreakReadReady((ChannelConfig)kQueueChannelConfig)) {
                this.clearReadFilter0();
                return;
            }
            ChannelPipeline channelPipeline = AbstractKQueueStreamChannel.this.pipeline();
            ByteBufAllocator byteBufAllocator = kQueueChannelConfig.getAllocator();
            kQueueRecvByteAllocatorHandle.reset((ChannelConfig)kQueueChannelConfig);
            this.readReadyBefore();
            ByteBuf byteBuf = null;
            boolean bl = false;
            try {
                do {
                    byteBuf = kQueueRecvByteAllocatorHandle.allocate(byteBufAllocator);
                    kQueueRecvByteAllocatorHandle.lastBytesRead(AbstractKQueueStreamChannel.this.doReadBytes(byteBuf));
                    if (kQueueRecvByteAllocatorHandle.lastBytesRead() <= 0) {
                        byteBuf.release();
                        byteBuf = null;
                        boolean bl2 = bl = kQueueRecvByteAllocatorHandle.lastBytesRead() < 0;
                        if (!bl) break;
                        this.readPending = false;
                        break;
                    }
                    kQueueRecvByteAllocatorHandle.incMessagesRead(1);
                    this.readPending = false;
                    channelPipeline.fireChannelRead((Object)byteBuf);
                    byteBuf = null;
                } while (!AbstractKQueueStreamChannel.this.shouldBreakReadReady((ChannelConfig)kQueueChannelConfig) && kQueueRecvByteAllocatorHandle.continueReading());
                kQueueRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (bl) {
                    this.shutdownInput(false);
                }
            }
            catch (Throwable throwable) {
                this.handleReadException(channelPipeline, byteBuf, throwable, bl, kQueueRecvByteAllocatorHandle);
            }
            finally {
                this.readReadyFinally((ChannelConfig)kQueueChannelConfig);
            }
        }

        private void handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl, KQueueRecvByteAllocatorHandle kQueueRecvByteAllocatorHandle) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    this.readPending = false;
                    channelPipeline.fireChannelRead((Object)byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            if (!this.failConnectPromise(throwable)) {
                kQueueRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                channelPipeline.fireExceptionCaught(throwable);
                if (bl || throwable instanceof OutOfMemoryError || throwable instanceof IOException) {
                    this.shutdownInput(false);
                }
            }
        }
    }
}

