/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.AbstractKQueueStreamChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueDomainSocketChannelConfig;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.PeerCredentials;
import java.net.SocketAddress;

public final class KQueueDomainSocketChannel
extends AbstractKQueueStreamChannel
implements DomainSocketChannel {
    private final KQueueDomainSocketChannelConfig config = new KQueueDomainSocketChannelConfig(this);
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;

    public KQueueDomainSocketChannel() {
        super(null, BsdSocket.newSocketDomain(), false);
    }

    public KQueueDomainSocketChannel(int n) {
        this(null, new BsdSocket(n));
    }

    KQueueDomainSocketChannel(Channel channel, BsdSocket bsdSocket) {
        super(channel, bsdSocket, true);
        this.local = bsdSocket.localDomainSocketAddress();
        this.remote = bsdSocket.remoteDomainSocketAddress();
    }

    @Override
    protected AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueDomainUnsafe();
    }

    protected DomainSocketAddress localAddress0() {
        return this.local;
    }

    protected DomainSocketAddress remoteAddress0() {
        return this.remote;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        this.socket.bind(socketAddress);
        this.local = (DomainSocketAddress)socketAddress;
    }

    @Override
    public KQueueDomainSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (super.doConnect(socketAddress, socketAddress2)) {
            this.local = socketAddress2 != null ? (DomainSocketAddress)socketAddress2 : this.socket.localDomainSocketAddress();
            this.remote = (DomainSocketAddress)socketAddress;
            return true;
        }
        return false;
    }

    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    public DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }

    @Override
    protected int doWriteSingle(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object = channelOutboundBuffer.current();
        if (object instanceof FileDescriptor && this.socket.sendFd(((FileDescriptor)object).intValue()) > 0) {
            channelOutboundBuffer.remove();
            return 1;
        }
        return super.doWriteSingle(channelOutboundBuffer);
    }

    @Override
    protected Object filterOutboundMessage(Object object) {
        if (object instanceof FileDescriptor) {
            return object;
        }
        return super.filterOutboundMessage(object);
    }

    public PeerCredentials peerCredentials() {
        return this.socket.getPeerCredentials();
    }

    private final class KQueueDomainUnsafe
    extends AbstractKQueueStreamChannel.KQueueStreamUnsafe {
        private KQueueDomainUnsafe() {
        }

        @Override
        void readReady(KQueueRecvByteAllocatorHandle kQueueRecvByteAllocatorHandle) {
            switch (KQueueDomainSocketChannel.this.config().getReadMode()) {
                case BYTES: {
                    super.readReady(kQueueRecvByteAllocatorHandle);
                    break;
                }
                case FILE_DESCRIPTORS: {
                    this.readReadyFd();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readReadyFd() {
            if (KQueueDomainSocketChannel.this.socket.isInputShutdown()) {
                super.clearReadFilter0();
                return;
            }
            KQueueDomainSocketChannelConfig kQueueDomainSocketChannelConfig = KQueueDomainSocketChannel.this.config();
            KQueueRecvByteAllocatorHandle kQueueRecvByteAllocatorHandle = this.recvBufAllocHandle();
            ChannelPipeline channelPipeline = KQueueDomainSocketChannel.this.pipeline();
            kQueueRecvByteAllocatorHandle.reset((ChannelConfig)kQueueDomainSocketChannelConfig);
            this.readReadyBefore();
            try {
                block10: while (true) {
                    int n = KQueueDomainSocketChannel.this.socket.recvFd();
                    switch (n) {
                        case 0: {
                            kQueueRecvByteAllocatorHandle.lastBytesRead(0);
                            break block10;
                        }
                        case -1: {
                            kQueueRecvByteAllocatorHandle.lastBytesRead(-1);
                            this.close(this.voidPromise());
                            return;
                        }
                        default: {
                            kQueueRecvByteAllocatorHandle.lastBytesRead(1);
                            kQueueRecvByteAllocatorHandle.incMessagesRead(1);
                            this.readPending = false;
                            channelPipeline.fireChannelRead((Object)new FileDescriptor(n));
                            if (kQueueRecvByteAllocatorHandle.continueReading()) continue block10;
                        }
                    }
                    break;
                }
                kQueueRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
            }
            catch (Throwable throwable) {
                kQueueRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                channelPipeline.fireExceptionCaught(throwable);
            }
            finally {
                this.readReadyFinally((ChannelConfig)kQueueDomainSocketChannelConfig);
            }
        }
    }
}

