/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.Native;
import io.netty.channel.unix.Buffer;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class KQueueEventArray {
    private static final int KQUEUE_EVENT_SIZE = Native.sizeofKEvent();
    private static final int KQUEUE_IDENT_OFFSET = Native.offsetofKEventIdent();
    private static final int KQUEUE_FILTER_OFFSET = Native.offsetofKEventFilter();
    private static final int KQUEUE_FFLAGS_OFFSET = Native.offsetofKEventFFlags();
    private static final int KQUEUE_FLAGS_OFFSET = Native.offsetofKEventFlags();
    private static final int KQUEUE_DATA_OFFSET = Native.offsetofKeventData();
    private ByteBuffer memory;
    private long memoryAddress;
    private int size;
    private int capacity;

    KQueueEventArray(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("capacity must be >= 1 but was " + n);
        }
        this.memory = Buffer.allocateDirectWithNativeOrder((int)KQueueEventArray.calculateBufferCapacity(n));
        this.memoryAddress = Buffer.memoryAddress((ByteBuffer)this.memory);
        this.capacity = n;
    }

    long memoryAddress() {
        return this.memoryAddress;
    }

    int capacity() {
        return this.capacity;
    }

    int size() {
        return this.size;
    }

    void clear() {
        this.size = 0;
    }

    void evSet(AbstractKQueueChannel abstractKQueueChannel, short s, short s2, int n) {
        this.reallocIfNeeded();
        KQueueEventArray.evSet((long)KQueueEventArray.getKEventOffset(this.size++) + this.memoryAddress, abstractKQueueChannel.socket.intValue(), s, s2, n);
    }

    private void reallocIfNeeded() {
        if (this.size == this.capacity) {
            this.realloc(true);
        }
    }

    void realloc(boolean bl) {
        block2: {
            int n = this.capacity <= 65536 ? this.capacity << 1 : this.capacity + this.capacity >> 1;
            try {
                ByteBuffer byteBuffer = Buffer.allocateDirectWithNativeOrder((int)KQueueEventArray.calculateBufferCapacity(n));
                this.memory.position(0).limit(this.size);
                byteBuffer.put(this.memory);
                byteBuffer.position(0);
                Buffer.free((ByteBuffer)this.memory);
                this.memory = byteBuffer;
                this.memoryAddress = Buffer.memoryAddress((ByteBuffer)byteBuffer);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (!bl) break block2;
                OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("unable to allocate " + n + " new bytes! Existing capacity is: " + this.capacity);
                outOfMemoryError2.initCause(outOfMemoryError);
                throw outOfMemoryError2;
            }
        }
    }

    void free() {
        Buffer.free((ByteBuffer)this.memory);
        this.capacity = 0;
        this.size = 0;
        this.memoryAddress = 0;
    }

    private static int getKEventOffset(int n) {
        return n * KQUEUE_EVENT_SIZE;
    }

    private long getKEventOffsetAddress(int n) {
        return (long)KQueueEventArray.getKEventOffset(n) + this.memoryAddress;
    }

    private short getShort(int n, int n2) {
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getShort((long)(this.getKEventOffsetAddress(n) + (long)n2));
        }
        return this.memory.getShort(KQueueEventArray.getKEventOffset(n) + n2);
    }

    short flags(int n) {
        return this.getShort(n, KQUEUE_FLAGS_OFFSET);
    }

    short filter(int n) {
        return this.getShort(n, KQUEUE_FILTER_OFFSET);
    }

    short fflags(int n) {
        return this.getShort(n, KQUEUE_FFLAGS_OFFSET);
    }

    int fd(int n) {
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getInt((long)(this.getKEventOffsetAddress(n) + (long)KQUEUE_IDENT_OFFSET));
        }
        return this.memory.getInt(KQueueEventArray.getKEventOffset(n) + KQUEUE_IDENT_OFFSET);
    }

    long data(int n) {
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getLong((long)(this.getKEventOffsetAddress(n) + (long)KQUEUE_DATA_OFFSET));
        }
        return this.memory.getLong(KQueueEventArray.getKEventOffset(n) + KQUEUE_DATA_OFFSET);
    }

    private static int calculateBufferCapacity(int n) {
        return n * KQUEUE_EVENT_SIZE;
    }

    private static native void evSet(long var0, int var2, short var3, short var4, int var5);
}

