/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.CopyActionContext;
import kotlin.io.path.CopyActionResult;
import kotlin.io.path.DefaultCopyActionContext;
import kotlin.io.path.ExceptionsCollector;
import kotlin.io.path.FileVisitorBuilder;
import kotlin.io.path.IllegalFileNameException;
import kotlin.io.path.LinkFollowing;
import kotlin.io.path.OnErrorResult;
import kotlin.io.path.PathsKt;
import kotlin.io.path.PathsKt__PathReadWriteKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;

@Metadata(mv={2, 3, 0}, k=5, xi=49, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\u001aw\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012Q\b\u0002\u0010\u0003\u001aK\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0002\u0012\u0017\u0012\u00150\bj\u0002`\n\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u001a\u00b4\u0001\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012Q\b\u0002\u0010\u0003\u001aK\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0002\u0012\u0017\u0012\u00150\bj\u0002`\n\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\f\u001a\u00020\r2C\b\u0002\u0010\u000f\u001a=\u0012\u0004\u0012\u00020\u0010\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\u00110\u0004\u00a2\u0006\u0002\b\u0012H\u0007\u001a\u0011\u0010\u0013\u001a\u00020\u0014*\u00020\u0011H\u0003\u00a2\u0006\u0002\b\u0015\u001a\u0011\u0010\u0013\u001a\u00020\u0014*\u00020\u000bH\u0003\u00a2\u0006\u0002\b\u0015\u001a\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0001H\u0007\u001a\u001b\u0010\u0018\u001a\f\u0012\b\u0012\u00060\bj\u0002`\n0\u0019*\u00020\u0001H\u0002\u00a2\u0006\u0002\b\u001a\u001a$\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fH\u0082\b\u00a2\u0006\u0002\b \u001a&\u0010!\u001a\u0004\u0018\u0001H\"\"\u0004\b\u0000\u0010\"2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\"0\u001fH\u0082\b\u00a2\u0006\u0004\b#\u0010$\u001a1\u0010%\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u00010&2\u0006\u0010\u0006\u001a\u00020\u00012\b\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\b(\u001a'\u0010)\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u00010&2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\b*\u001a5\u0010+\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00010&2\u0006\u0010,\u001a\u00020\u00012\u0012\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020/0.\"\u00020/H\u0002\u00a2\u0006\u0004\b0\u00101\u001a'\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u00012\b\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\b4\u001a\u001d\u00105\u001a\u00020\u00172\u0006\u00106\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\b7\u001a\f\u00108\u001a\u00020\u0017*\u00020\u0001H\u0000\u001a\u0019\u00109\u001a\u00020\u0017*\u00020\u00012\u0006\u0010'\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\b:\u00a8\u0006;"}, d2={"copyToRecursively", "Ljava/nio/file/Path;", "target", "onError", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "source", "Ljava/lang/Exception;", "exception", "Lkotlin/Exception;", "Lkotlin/io/path/OnErrorResult;", "followLinks", "", "overwrite", "copyAction", "Lkotlin/io/path/CopyActionContext;", "Lkotlin/io/path/CopyActionResult;", "Lkotlin/ExtensionFunctionType;", "toFileVisitResult", "Ljava/nio/file/FileVisitResult;", "toFileVisitResult$PathsKt__PathRecursiveFunctionsKt", "deleteRecursively", "", "deleteRecursivelyImpl", "", "deleteRecursivelyImpl$PathsKt__PathRecursiveFunctionsKt", "collectIfThrows", "collector", "Lkotlin/io/path/ExceptionsCollector;", "function", "Lkotlin/Function0;", "collectIfThrows$PathsKt__PathRecursiveFunctionsKt", "tryIgnoreNoSuchFileException", "R", "tryIgnoreNoSuchFileException$PathsKt__PathRecursiveFunctionsKt", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "handleEntry", "Ljava/nio/file/SecureDirectoryStream;", "parent", "handleEntry$PathsKt__PathRecursiveFunctionsKt", "enterDirectory", "enterDirectory$PathsKt__PathRecursiveFunctionsKt", "isDirectory", "entryName", "options", "", "Ljava/nio/file/LinkOption;", "isDirectory$PathsKt__PathRecursiveFunctionsKt", "(Ljava/nio/file/SecureDirectoryStream;Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Z", "insecureHandleEntry", "entry", "insecureHandleEntry$PathsKt__PathRecursiveFunctionsKt", "insecureEnterDirectory", "path", "insecureEnterDirectory$PathsKt__PathRecursiveFunctionsKt", "checkFileName", "checkNotSameAs", "checkNotSameAs$PathsKt__PathRecursiveFunctionsKt", "kotlin-stdlib-jdk7"}, xs="kotlin/io/path/PathsKt")
class PathsKt__PathRecursiveFunctionsKt
extends PathsKt__PathReadWriteKt {
    public static final Path copyToRecursively(Path path, Path path2, Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult> function3, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(path2, "");
        Intrinsics.checkNotNullParameter(function3, "");
        return bl2 ? PathsKt.copyToRecursively(path, path2, function3, bl, (arg_0, arg_1, arg_2) -> PathsKt__PathRecursiveFunctionsKt.copyToRecursively$lambda$1$PathsKt__PathRecursiveFunctionsKt(bl, arg_0, arg_1, arg_2)) : PathsKt.copyToRecursively$default(path, path2, function3, bl, null, 8, null);
    }

    public static /* synthetic */ Path copyToRecursively$default(Path path, Path path2, Function3 function3, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            function3 = PathsKt__PathRecursiveFunctionsKt::copyToRecursively$lambda$0$PathsKt__PathRecursiveFunctionsKt;
        }
        return PathsKt.copyToRecursively(path, path2, function3, bl, bl2);
    }

    public static final Path copyToRecursively(Path path, Path path2, Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult> function3, boolean bl, Function3<? super CopyActionContext, ? super Path, ? super Path, ? extends CopyActionResult> function32) {
        Path path3;
        block11: {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            block12: {
                Intrinsics.checkNotNullParameter(path, "");
                Intrinsics.checkNotNullParameter(path2, "");
                Intrinsics.checkNotNullParameter(function3, "");
                Intrinsics.checkNotNullParameter(function32, "");
                path3 = path;
                LinkOption[] linkOptionArray = LinkFollowing.INSTANCE.toLinkOptions(bl);
                linkOptionArray = Arrays.copyOf(linkOptionArray, linkOptionArray.length);
                if (!Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    throw new NoSuchFileException(((Object)path).toString(), ((Object)path2).toString(), "The source file doesn't exist.");
                }
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.exists(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) || !bl && Files.isSymbolicLink(path)) break block11;
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                boolean bl5 = bl4 = Files.exists(path2, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) && !Files.isSymbolicLink(path2);
                if (!bl4) break block12;
                if (Files.isSameFile(path, path2)) break block11;
            }
            if (!Intrinsics.areEqual(path.getFileSystem(), path2.getFileSystem())) {
                bl3 = false;
            } else if (bl4) {
                bl3 = path2.toRealPath(new LinkOption[0]).startsWith(path.toRealPath(new LinkOption[0]));
            } else {
                Path path4 = path2.getParent();
                if (path4 != null) {
                    Path path5 = path4;
                    boolean bl6 = false;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    bl3 = Files.exists(path5, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && path5.toRealPath(new LinkOption[0]).startsWith(path.toRealPath(new LinkOption[0]));
                } else {
                    bl3 = bl2 = false;
                }
            }
            if (bl2) {
                throw new FileSystemException(((Object)path).toString(), ((Object)path2).toString(), "Recursively copying a directory into its subdirectory is prohibited.");
            }
        }
        path3 = path2.normalize();
        ArrayList arrayList = new ArrayList();
        PathsKt.visitFileTree$default(path, 0, bl, arg_0 -> PathsKt__PathRecursiveFunctionsKt.copyToRecursively$lambda$5$PathsKt__PathRecursiveFunctionsKt(arrayList, function32, path, path2, path3, function3, arg_0), 1, null);
        return path2;
    }

    public static /* synthetic */ Path copyToRecursively$default(Path path, Path path2, Function3 function3, boolean bl, Function3 function32, int n, Object object) {
        if ((n & 2) != 0) {
            function3 = PathsKt__PathRecursiveFunctionsKt::copyToRecursively$lambda$2$PathsKt__PathRecursiveFunctionsKt;
        }
        if ((n & 8) != 0) {
            function32 = (arg_0, arg_1, arg_2) -> PathsKt__PathRecursiveFunctionsKt.copyToRecursively$lambda$3$PathsKt__PathRecursiveFunctionsKt(bl, arg_0, arg_1, arg_2);
        }
        return PathsKt.copyToRecursively(path, path2, function3, bl, function32);
    }

    private static final FileVisitResult toFileVisitResult$PathsKt__PathRecursiveFunctionsKt(CopyActionResult copyActionResult) {
        FileVisitResult fileVisitResult;
        switch (WhenMappings.$EnumSwitchMapping$0[copyActionResult.ordinal()]) {
            case 1: {
                fileVisitResult = FileVisitResult.CONTINUE;
                break;
            }
            case 2: {
                fileVisitResult = FileVisitResult.TERMINATE;
                break;
            }
            case 3: {
                fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fileVisitResult;
    }

    private static final FileVisitResult toFileVisitResult$PathsKt__PathRecursiveFunctionsKt(OnErrorResult onErrorResult) {
        FileVisitResult fileVisitResult;
        switch (WhenMappings.$EnumSwitchMapping$1[onErrorResult.ordinal()]) {
            case 1: {
                fileVisitResult = FileVisitResult.TERMINATE;
                break;
            }
            case 2: {
                fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fileVisitResult;
    }

    public static final void deleteRecursively(Path path) {
        Intrinsics.checkNotNullParameter(path, "");
        List<Exception> list = PathsKt__PathRecursiveFunctionsKt.deleteRecursivelyImpl$PathsKt__PathRecursiveFunctionsKt(path);
        if (!((Collection)list).isEmpty()) {
            FileSystemException fileSystemException;
            FileSystemException fileSystemException2 = fileSystemException = new FileSystemException("Failed to delete one or more files. See suppressed exceptions for details.");
            boolean bl = false;
            Iterable iterable = list;
            boolean bl2 = false;
            for (Object t : iterable) {
                Exception exception = (Exception)t;
                boolean bl3 = false;
                ExceptionsKt.addSuppressed(fileSystemException2, exception);
            }
            throw (Throwable)fileSystemException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<Exception> deleteRecursivelyImpl$PathsKt__PathRecursiveFunctionsKt(Path path) {
        ExceptionsCollector exceptionsCollector = new ExceptionsCollector(0, 1, null);
        boolean bl = false;
        bl = true;
        Path path2 = path.getFileName();
        if (path2 != null) {
            DirectoryStream<Path> directoryStream;
            Closeable closeable;
            Path path3 = path2;
            boolean bl2 = false;
            Path path4 = path.getParent();
            if (path4 == null) {
                path4 = path.getFileSystem().getPath("", new String[0]);
            }
            Path path5 = path4;
            try {
                closeable = Files.newDirectoryStream(path5);
            }
            catch (Throwable throwable) {
                closeable = null;
            }
            DirectoryStream<Path> directoryStream2 = directoryStream = closeable;
            if (directoryStream2 != null) {
                closeable = directoryStream2;
                Throwable throwable = null;
                try {
                    Object object = closeable;
                    boolean bl3 = false;
                    if (object instanceof SecureDirectoryStream) {
                        bl = false;
                        exceptionsCollector.setPath(path5);
                        PathsKt__PathRecursiveFunctionsKt.handleEntry$PathsKt__PathRecursiveFunctionsKt((SecureDirectoryStream)object, path3, null, exceptionsCollector);
                    }
                    object = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
        }
        if (bl) {
            PathsKt__PathRecursiveFunctionsKt.insecureHandleEntry$PathsKt__PathRecursiveFunctionsKt(path, null, exceptionsCollector);
        }
        return exceptionsCollector.getCollectedExceptions();
    }

    private static final void collectIfThrows$PathsKt__PathRecursiveFunctionsKt(ExceptionsCollector exceptionsCollector, Function0<Unit> function0) {
        boolean bl = false;
        try {
            function0.invoke();
        }
        catch (Exception exception) {
            exceptionsCollector.collect(exception);
        }
    }

    private static final <R> R tryIgnoreNoSuchFileException$PathsKt__PathRecursiveFunctionsKt(Function0<? extends R> function0) {
        R r;
        boolean bl = false;
        try {
            r = function0.invoke();
        }
        catch (NoSuchFileException noSuchFileException) {
            r = null;
        }
        return r;
    }

    private static final void handleEntry$PathsKt__PathRecursiveFunctionsKt(SecureDirectoryStream<Path> secureDirectoryStream, Path path, Path path2, ExceptionsCollector exceptionsCollector) {
        exceptionsCollector.enterEntry(path);
        ExceptionsCollector exceptionsCollector2 = exceptionsCollector;
        boolean bl = false;
        try {
            LinkOption[] linkOptionArray;
            boolean bl2 = false;
            if (path2 != null) {
                LinkOption[] linkOptionArray2 = exceptionsCollector.getPath();
                Intrinsics.checkNotNull(linkOptionArray2);
                linkOptionArray = linkOptionArray2;
                PathsKt.checkFileName((Path)linkOptionArray);
                PathsKt__PathRecursiveFunctionsKt.checkNotSameAs$PathsKt__PathRecursiveFunctionsKt((Path)linkOptionArray, path2);
            }
            linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            if (PathsKt__PathRecursiveFunctionsKt.isDirectory$PathsKt__PathRecursiveFunctionsKt(secureDirectoryStream, path, linkOptionArray)) {
                int n = exceptionsCollector.getTotalExceptions();
                PathsKt__PathRecursiveFunctionsKt.enterDirectory$PathsKt__PathRecursiveFunctionsKt(secureDirectoryStream, path, exceptionsCollector);
                if (n == exceptionsCollector.getTotalExceptions()) {
                    boolean bl3 = false;
                    try {
                        boolean bl4 = false;
                        secureDirectoryStream.deleteDirectory(path);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        Object var10_16 = null;
                    }
                }
            } else {
                boolean bl5 = false;
                try {
                    boolean bl6 = false;
                    secureDirectoryStream.deleteFile(path);
                    Unit unit = Unit.INSTANCE;
                }
                catch (NoSuchFileException noSuchFileException) {
                    Object var9_14 = null;
                }
            }
        }
        catch (Exception exception) {
            exceptionsCollector2.collect(exception);
        }
        exceptionsCollector.exitEntry(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void enterDirectory$PathsKt__PathRecursiveFunctionsKt(SecureDirectoryStream<Path> secureDirectoryStream, Path path, ExceptionsCollector exceptionsCollector) {
        block10: {
            ExceptionsCollector exceptionsCollector2 = exceptionsCollector;
            boolean bl = false;
            try {
                SecureDirectoryStream<Path> secureDirectoryStream2;
                Object object;
                boolean bl2 = false;
                boolean bl3 = false;
                try {
                    boolean bl4 = false;
                    object = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                    secureDirectoryStream2 = secureDirectoryStream.newDirectoryStream(path, (LinkOption[])object);
                }
                catch (NoSuchFileException noSuchFileException) {
                    secureDirectoryStream2 = null;
                }
                SecureDirectoryStream<Path> secureDirectoryStream3 = secureDirectoryStream2;
                if (secureDirectoryStream3 == null) break block10;
                Closeable closeable = secureDirectoryStream3;
                Throwable throwable = null;
                try {
                    object = (SecureDirectoryStream)closeable;
                    boolean bl5 = false;
                    Iterator iterator2 = object.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, "");
                    Iterator iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        Path path2 = (Path)iterator3.next();
                        Path path3 = path2.getFileName();
                        Intrinsics.checkNotNullExpressionValue(path3, "");
                        PathsKt__PathRecursiveFunctionsKt.handleEntry$PathsKt__PathRecursiveFunctionsKt((SecureDirectoryStream<Path>)object, path3, exceptionsCollector.getPath(), exceptionsCollector);
                    }
                    object = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (Exception exception) {
                exceptionsCollector2.collect(exception);
            }
        }
    }

    private static final boolean isDirectory$PathsKt__PathRecursiveFunctionsKt(SecureDirectoryStream<Path> secureDirectoryStream, Path path, LinkOption ... linkOptionArray) {
        Boolean bl;
        boolean bl2 = false;
        try {
            boolean bl3 = false;
            bl = secureDirectoryStream.getFileAttributeView(path, BasicFileAttributeView.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length)).readAttributes().isDirectory();
        }
        catch (NoSuchFileException noSuchFileException) {
            bl = null;
        }
        Boolean bl4 = bl;
        return bl4 != null ? bl4 : false;
    }

    private static final void insecureHandleEntry$PathsKt__PathRecursiveFunctionsKt(Path path, Path path2, ExceptionsCollector exceptionsCollector) {
        ExceptionsCollector exceptionsCollector2 = exceptionsCollector;
        boolean bl = false;
        try {
            boolean bl2 = false;
            if (path2 != null) {
                PathsKt.checkFileName(path);
                PathsKt__PathRecursiveFunctionsKt.checkNotSameAs$PathsKt__PathRecursiveFunctionsKt(path, path2);
            }
            Path path3 = path;
            LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            if (Files.isDirectory(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                int n = exceptionsCollector.getTotalExceptions();
                PathsKt__PathRecursiveFunctionsKt.insecureEnterDirectory$PathsKt__PathRecursiveFunctionsKt(path, exceptionsCollector);
                if (n == exceptionsCollector.getTotalExceptions()) {
                    Files.deleteIfExists(path);
                }
            } else {
                Files.deleteIfExists(path);
            }
        }
        catch (Exception exception) {
            exceptionsCollector2.collect(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void insecureEnterDirectory$PathsKt__PathRecursiveFunctionsKt(Path path, ExceptionsCollector exceptionsCollector) {
        block10: {
            ExceptionsCollector exceptionsCollector2 = exceptionsCollector;
            boolean bl = false;
            try {
                Object object;
                boolean bl2 = false;
                boolean bl3 = false;
                try {
                    boolean bl4 = false;
                    object = Files.newDirectoryStream(path);
                }
                catch (NoSuchFileException noSuchFileException) {
                    object = null;
                }
                DirectoryStream directoryStream = object;
                if (directoryStream == null) break block10;
                Closeable closeable = directoryStream;
                Throwable throwable = null;
                try {
                    object = (DirectoryStream)closeable;
                    boolean bl5 = false;
                    Iterator iterator2 = object.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, "");
                    Iterator iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        Path path2 = (Path)iterator3.next();
                        Intrinsics.checkNotNull(path2);
                        PathsKt__PathRecursiveFunctionsKt.insecureHandleEntry$PathsKt__PathRecursiveFunctionsKt(path2, path, exceptionsCollector);
                    }
                    object = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (Exception exception) {
                exceptionsCollector2.collect(exception);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void checkFileName(Path path) {
        Intrinsics.checkNotNullParameter(path, "");
        String string = PathsKt.getName(path);
        switch (string.hashCode()) {
            case 1472: {
                if (string.equals("..")) throw new IllegalFileNameException(path);
                return;
            }
            case 1473: {
                if (string.equals("./")) throw new IllegalFileNameException(path);
                return;
            }
            case 45724: {
                if (string.equals("..\\")) throw new IllegalFileNameException(path);
                return;
            }
            case 46: {
                if (string.equals(".")) throw new IllegalFileNameException(path);
                return;
            }
            case 1518: {
                if (string.equals(".\\")) throw new IllegalFileNameException(path);
                return;
            }
            case 45679: {
                if (!string.equals("../")) return;
                throw new IllegalFileNameException(path);
            }
        }
    }

    private static final void checkNotSameAs$PathsKt__PathRecursiveFunctionsKt(Path path, Path path2) {
        if (!Files.isSymbolicLink(path) && Files.isSameFile(path, path2)) {
            throw new FileSystemLoopException(((Object)path).toString());
        }
    }

    private static final OnErrorResult copyToRecursively$lambda$0$PathsKt__PathRecursiveFunctionsKt(Path path, Path path2, Exception exception) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(path2, "");
        Intrinsics.checkNotNullParameter(exception, "");
        throw exception;
    }

    private static final CopyActionResult copyToRecursively$lambda$1$PathsKt__PathRecursiveFunctionsKt(boolean bl, CopyActionContext copyActionContext, Path path, Path path2) {
        Intrinsics.checkNotNullParameter(copyActionContext, "");
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(path2, "");
        LinkOption[] linkOptionArray = LinkFollowing.INSTANCE.toLinkOptions(bl);
        Path path3 = path2;
        Object object = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        boolean bl2 = Files.isDirectory(path3, Arrays.copyOf(object, ((LinkOption[])object).length));
        LinkOption[] linkOptionArray2 = Arrays.copyOf(linkOptionArray, linkOptionArray.length);
        boolean bl3 = Files.isDirectory(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
        if (!bl3 || !bl2) {
            if (bl2) {
                PathsKt.deleteRecursively(path2);
            }
            object = path;
            CopyOption[] copyOptionArray = new SpreadBuilder(2);
            copyOptionArray.addSpread(linkOptionArray);
            copyOptionArray.add(StandardCopyOption.REPLACE_EXISTING);
            copyOptionArray = (CopyOption[])copyOptionArray.toArray(new CopyOption[copyOptionArray.size()]);
            Intrinsics.checkNotNullExpressionValue(Files.copy((Path)object, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), "");
        }
        return CopyActionResult.CONTINUE;
    }

    private static final OnErrorResult copyToRecursively$lambda$2$PathsKt__PathRecursiveFunctionsKt(Path path, Path path2, Exception exception) {
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(path2, "");
        Intrinsics.checkNotNullParameter(exception, "");
        throw exception;
    }

    private static final CopyActionResult copyToRecursively$lambda$3$PathsKt__PathRecursiveFunctionsKt(boolean bl, CopyActionContext copyActionContext, Path path, Path path2) {
        Intrinsics.checkNotNullParameter(copyActionContext, "");
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(path2, "");
        return copyActionContext.copyToIgnoringExistingDirectory(path, path2, bl);
    }

    private static final FileVisitResult copyToRecursively$lambda$5$0$PathsKt__PathRecursiveFunctionsKt(ArrayList arrayList, Function3 function3, Path path, Path path2, Path path3, Function3 function32, Path path4, BasicFileAttributes basicFileAttributes) {
        FileVisitResult fileVisitResult;
        Intrinsics.checkNotNullParameter(path4, "");
        Intrinsics.checkNotNullParameter(basicFileAttributes, "");
        FileVisitResult fileVisitResult2 = fileVisitResult = PathsKt__PathRecursiveFunctionsKt.copyToRecursively$copy$PathsKt__PathRecursiveFunctionsKt(arrayList, function3, path, path2, path3, function32, path4, basicFileAttributes);
        boolean bl = false;
        if (fileVisitResult2 == FileVisitResult.CONTINUE) {
            arrayList.add(path4);
        }
        return fileVisitResult;
    }

    private static final FileVisitResult copyToRecursively$lambda$5$1$PathsKt__PathRecursiveFunctionsKt(ArrayList arrayList, Function3 function3, Path path, Path path2, Path path3, Path path4, IOException iOException) {
        Intrinsics.checkNotNullParameter(path4, "");
        CollectionsKt.removeLast(arrayList);
        return iOException == null ? FileVisitResult.CONTINUE : PathsKt__PathRecursiveFunctionsKt.copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt(function3, path, path2, path3, path4, iOException);
    }

    private static final Path copyToRecursively$destination$PathsKt__PathRecursiveFunctionsKt(Path path, Path path2, Path path3, Path path4) {
        Path path5 = PathsKt.relativeTo(path4, path);
        Path path6 = path2.resolve(((Object)path5).toString());
        if (!path6.normalize().startsWith(path3)) {
            throw new IllegalFileNameException(path4, path6, "Copying files to outside the specified target directory is prohibited. The directory being recursively copied might contain an entry with an illegal name.");
        }
        Intrinsics.checkNotNull(path6);
        return path6;
    }

    private static final FileVisitResult copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt(Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult> function3, Path path, Path path2, Path path3, Path path4, Exception exception) {
        return PathsKt__PathRecursiveFunctionsKt.toFileVisitResult$PathsKt__PathRecursiveFunctionsKt(function3.invoke(path4, PathsKt__PathRecursiveFunctionsKt.copyToRecursively$destination$PathsKt__PathRecursiveFunctionsKt(path, path2, path3, path4), exception));
    }

    private static final FileVisitResult copyToRecursively$copy$PathsKt__PathRecursiveFunctionsKt(ArrayList<Path> arrayList, Function3<? super CopyActionContext, ? super Path, ? super Path, ? extends CopyActionResult> function3, Path path, Path path2, Path path3, Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult> function32, Path path4, BasicFileAttributes basicFileAttributes) {
        FileVisitResult fileVisitResult;
        try {
            if (!((Collection)arrayList).isEmpty()) {
                PathsKt.checkFileName(path4);
                Object t = CollectionsKt.last((List)arrayList);
                Intrinsics.checkNotNullExpressionValue(t, "");
                PathsKt__PathRecursiveFunctionsKt.checkNotSameAs$PathsKt__PathRecursiveFunctionsKt(path4, (Path)t);
            }
            fileVisitResult = PathsKt__PathRecursiveFunctionsKt.toFileVisitResult$PathsKt__PathRecursiveFunctionsKt(function3.invoke(DefaultCopyActionContext.INSTANCE, path4, PathsKt__PathRecursiveFunctionsKt.copyToRecursively$destination$PathsKt__PathRecursiveFunctionsKt(path, path2, path3, path4)));
        }
        catch (Exception exception) {
            fileVisitResult = PathsKt__PathRecursiveFunctionsKt.copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt(function32, path, path2, path3, path4, exception);
        }
        return fileVisitResult;
    }

    private static final Unit copyToRecursively$lambda$5$PathsKt__PathRecursiveFunctionsKt(ArrayList arrayList, Function3 function3, Path path, Path path2, Path path3, Function3 function32, FileVisitorBuilder fileVisitorBuilder) {
        Intrinsics.checkNotNullParameter(fileVisitorBuilder, "");
        fileVisitorBuilder.onPreVisitDirectory((arg_0, arg_1) -> PathsKt__PathRecursiveFunctionsKt.copyToRecursively$lambda$5$0$PathsKt__PathRecursiveFunctionsKt(arrayList, function3, path, path2, path3, function32, arg_0, arg_1));
        fileVisitorBuilder.onVisitFile((Function2<? super Path, ? super BasicFileAttributes, ? extends FileVisitResult>)new Function2<Path, BasicFileAttributes, FileVisitResult>((ArrayList<Path>)arrayList, (Function3<? super CopyActionContext, ? super Path, ? super Path, ? extends CopyActionResult>)function3, path, path2, path3, (Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult>)function32){
            final /* synthetic */ ArrayList<Path> $stack;
            final /* synthetic */ Function3<CopyActionContext, Path, Path, CopyActionResult> $copyAction;
            final /* synthetic */ Path $this_copyToRecursively;
            final /* synthetic */ Path $target;
            final /* synthetic */ Path $normalizedTarget;
            final /* synthetic */ Function3<Path, Path, Exception, OnErrorResult> $onError;
            {
                this.$stack = arrayList;
                this.$copyAction = function3;
                this.$this_copyToRecursively = path;
                this.$target = path2;
                this.$normalizedTarget = path3;
                this.$onError = function32;
                super(2, Intrinsics.Kotlin.class, "copy", "copyToRecursively$copy$PathsKt__PathRecursiveFunctionsKt(Ljava/util/ArrayList;Lkotlin/jvm/functions/Function3;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function3;Ljava/nio/file/Path;Ljava/nio/file/attribute/BasicFileAttributes;)Ljava/nio/file/FileVisitResult;", 0);
            }

            public final FileVisitResult invoke(Path path, BasicFileAttributes basicFileAttributes) {
                Intrinsics.checkNotNullParameter(path, "");
                Intrinsics.checkNotNullParameter(basicFileAttributes, "");
                return PathsKt__PathRecursiveFunctionsKt.access$copyToRecursively$copy(this.$stack, this.$copyAction, this.$this_copyToRecursively, this.$target, this.$normalizedTarget, this.$onError, path, basicFileAttributes);
            }
        });
        fileVisitorBuilder.onVisitFileFailed((Function2<? super Path, ? super IOException, ? extends FileVisitResult>)new Function2<Path, Exception, FileVisitResult>((Function3<? super Path, ? super Path, ? super Exception, ? extends OnErrorResult>)function32, path, path2, path3){
            final /* synthetic */ Function3<Path, Path, Exception, OnErrorResult> $onError;
            final /* synthetic */ Path $this_copyToRecursively;
            final /* synthetic */ Path $target;
            final /* synthetic */ Path $normalizedTarget;
            {
                this.$onError = function3;
                this.$this_copyToRecursively = path;
                this.$target = path2;
                this.$normalizedTarget = path3;
                super(2, Intrinsics.Kotlin.class, "error", "copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt(Lkotlin/jvm/functions/Function3;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/Exception;)Ljava/nio/file/FileVisitResult;", 0);
            }

            public final FileVisitResult invoke(Path path, Exception exception) {
                Intrinsics.checkNotNullParameter(path, "");
                Intrinsics.checkNotNullParameter(exception, "");
                return PathsKt__PathRecursiveFunctionsKt.access$copyToRecursively$error(this.$onError, this.$this_copyToRecursively, this.$target, this.$normalizedTarget, path, exception);
            }
        });
        fileVisitorBuilder.onPostVisitDirectory((arg_0, arg_1) -> PathsKt__PathRecursiveFunctionsKt.copyToRecursively$lambda$5$1$PathsKt__PathRecursiveFunctionsKt(arrayList, function32, path, path2, path3, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ FileVisitResult access$copyToRecursively$copy(ArrayList arrayList, Function3 function3, Path path, Path path2, Path path3, Function3 function32, Path path4, BasicFileAttributes basicFileAttributes) {
        return PathsKt__PathRecursiveFunctionsKt.copyToRecursively$copy$PathsKt__PathRecursiveFunctionsKt(arrayList, function3, path, path2, path3, function32, path4, basicFileAttributes);
    }

    public static final /* synthetic */ FileVisitResult access$copyToRecursively$error(Function3 function3, Path path, Path path2, Path path3, Path path4, Exception exception) {
        return PathsKt__PathRecursiveFunctionsKt.copyToRecursively$error$PathsKt__PathRecursiveFunctionsKt(function3, path, path2, path3, path4, exception);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CopyActionResult.values().length];
            try {
                nArray[CopyActionResult.CONTINUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CopyActionResult.TERMINATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CopyActionResult.SKIP_SUBTREE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OnErrorResult.values().length];
            try {
                nArray[OnErrorResult.TERMINATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OnErrorResult.SKIP_SUBTREE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

