/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.lang.annotation.Annotation;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SealedClassSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonClassDiscriminator;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonEncodingException;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.TreeJsonDecoderKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\u001ai\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0006\u0010\u0006\u001a\u0002H\u000226\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00010\bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000e\u001a(\u0010\u000f\u001a\u00020\u00012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0011\u001a\u00020\tH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a7\u0010\u0015\u001a\u0002H\u0002\"\u0004\b\u0000\u0010\u0002*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001aH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001a\u0014\u0010\u0011\u001a\u00020\t*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u001a\u0010\u001f\u001a\u00020 2\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010!\u001a\u00020\"H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006#"}, d2={"encodePolymorphically", "", "T", "Lkotlinx/serialization/json/JsonEncoder;", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "ifPolymorphic", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "discriminatorName", "serialName", "(Lkotlinx/serialization/json/JsonEncoder;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "validateIfSealed", "actualSerializer", "classDiscriminator", "checkKind", "kind", "Lkotlinx/serialization/descriptors/SerialKind;", "decodeSerializableValuePolymorphic", "Lkotlinx/serialization/json/JsonDecoder;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "path", "Lkotlin/Function0;", "(Lkotlinx/serialization/json/JsonDecoder;Lkotlinx/serialization/DeserializationStrategy;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "json", "Lkotlinx/serialization/json/Json;", "throwJsonElementPolymorphicException", "", "element", "Lkotlinx/serialization/json/JsonElement;", "kotlinx-serialization-json"})
public final class PolymorphicKt {
    public static final <T> void encodePolymorphically(JsonEncoder jsonEncoder, SerializationStrategy<? super T> serialKind, T t, Function2<? super String, ? super String, Unit> function2) {
        SerialKind serialKind2;
        SerialKind serialKind3;
        String string;
        SerialKind serialKind4;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)jsonEncoder, (String)"");
        Intrinsics.checkNotNullParameter(serialKind, (String)"");
        Intrinsics.checkNotNullParameter(function2, (String)"");
        boolean bl2 = false;
        if (jsonEncoder.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serialKind.serialize((Encoder)jsonEncoder, t);
            return;
        }
        boolean bl3 = serialKind instanceof AbstractPolymorphicSerializer;
        if (bl3) {
            bl = jsonEncoder.getJson().getConfiguration().getClassDiscriminatorMode() != ClassDiscriminatorMode.NONE;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[jsonEncoder.getJson().getConfiguration().getClassDiscriminatorMode().ordinal()]) {
                case 1: 
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    serialKind4 = serialKind.getDescriptor().getKind();
                    boolean bl4 = false;
                    if (Intrinsics.areEqual((Object)serialKind4, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind4, (Object)StructureKind.OBJECT.INSTANCE)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        boolean bl5 = bl;
        String string2 = string = bl5 ? PolymorphicKt.classDiscriminator(serialKind.getDescriptor(), jsonEncoder.getJson()) : null;
        if (bl3) {
            AbstractPolymorphicSerializer abstractPolymorphicSerializer = (AbstractPolymorphicSerializer)serialKind;
            if (t == null) {
                boolean bl6 = false;
                String string3 = "Value for serializer " + ((AbstractPolymorphicSerializer)serialKind).getDescriptor() + " should always be non-null. Please report issue to the kotlinx.serialization tracker.";
                throw new IllegalArgumentException(string3.toString());
            }
            serialKind4 = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)abstractPolymorphicSerializer, (Encoder)jsonEncoder, t);
            if (string != null) {
                PolymorphicKt.validateIfSealed((SerializationStrategy)serialKind, (SerializationStrategy)serialKind4, string);
                PolymorphicKt.checkKind(serialKind4.getDescriptor().getKind());
            }
            Intrinsics.checkNotNull((Object)serialKind4);
            serialKind3 = serialKind4;
        } else {
            serialKind3 = serialKind2 = serialKind;
        }
        if (string != null) {
            function2.invoke((Object)string, (Object)serialKind2.getDescriptor().getSerialName());
        }
        serialKind2.serialize((Encoder)jsonEncoder, t);
    }

    private static final void validateIfSealed(SerializationStrategy<?> serializationStrategy, SerializationStrategy<?> serializationStrategy2, String string) {
        if (!(serializationStrategy instanceof SealedClassSerializer)) {
            return;
        }
        if (JsonInternalDependenciesKt.jsonCachedSerialNames((SerialDescriptor)serializationStrategy2.getDescriptor()).contains(string)) {
            String string2 = ((SealedClassSerializer)serializationStrategy).getDescriptor().getSerialName();
            String string3 = serializationStrategy2.getDescriptor().getSerialName();
            throw new IllegalStateException(("Sealed class '" + string3 + "' cannot be serialized as base class '" + string2 + "' because it has property name that conflicts with JSON class discriminator '" + string + "'. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism").toString());
        }
    }

    public static final void checkKind(SerialKind serialKind) {
        Intrinsics.checkNotNullParameter((Object)serialKind, (String)"");
        if (serialKind instanceof SerialKind.ENUM) {
            throw new IllegalStateException("Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (serialKind instanceof PrimitiveKind) {
            throw new IllegalStateException("Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (serialKind instanceof PolymorphicKind) {
            throw new IllegalStateException("Actual serializer for polymorphic cannot be polymorphic itself".toString());
        }
    }

    public static final <T> T decodeSerializableValuePolymorphic(JsonDecoder jsonDecoder, DeserializationStrategy<? extends T> deserializationStrategy, Function0<String> function0) {
        DeserializationStrategy deserializationStrategy2;
        Intrinsics.checkNotNullParameter((Object)jsonDecoder, (String)"");
        Intrinsics.checkNotNullParameter(deserializationStrategy, (String)"");
        Intrinsics.checkNotNullParameter(function0, (String)"");
        boolean bl = false;
        if (!(deserializationStrategy instanceof AbstractPolymorphicSerializer) || jsonDecoder.getJson().getConfiguration().getUseArrayPolymorphism()) {
            return (T)deserializationStrategy.deserialize((Decoder)jsonDecoder);
        }
        String string = PolymorphicKt.classDiscriminator(((AbstractPolymorphicSerializer)deserializationStrategy).getDescriptor(), jsonDecoder.getJson());
        JsonElement jsonElement = jsonDecoder.decodeJsonElement();
        String string2 = ((AbstractPolymorphicSerializer)deserializationStrategy).getDescriptor().getSerialName();
        boolean bl2 = false;
        if (!(jsonElement instanceof JsonObject)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName() + ", but had " + Reflection.getOrCreateKotlinClass(jsonElement.getClass()).getSimpleName() + " as the serialized body of " + string2 + " at element: " + (String)function0.invoke(), jsonElement.toString());
        }
        JsonObject jsonObject = (JsonObject)jsonElement;
        JsonElement jsonElement2 = (JsonElement)jsonObject.get((Object)string);
        jsonElement = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive(jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
        try {
            deserializationStrategy2 = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)((AbstractPolymorphicSerializer)deserializationStrategy), (CompositeDecoder)jsonDecoder, (String)((Object)jsonElement));
        }
        catch (SerializationException serializationException) {
            String string3 = serializationException.getMessage();
            Intrinsics.checkNotNull((Object)string3);
            throw JsonExceptionsKt.JsonDecodingException(-1, string3, jsonObject.toString());
        }
        DeserializationStrategy deserializationStrategy3 = deserializationStrategy2;
        Intrinsics.checkNotNull((Object)deserializationStrategy3);
        string2 = deserializationStrategy3;
        return TreeJsonDecoderKt.readPolymorphicJson(jsonDecoder.getJson(), string, jsonObject, string2);
    }

    public static final String classDiscriminator(SerialDescriptor serialDescriptor, Json json) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        for (Annotation annotation : serialDescriptor.getAnnotations()) {
            if (!(annotation instanceof JsonClassDiscriminator)) continue;
            return ((JsonClassDiscriminator)annotation).discriminator();
        }
        return json.getConfiguration().getClassDiscriminator();
    }

    public static final Void throwJsonElementPolymorphicException(String string, JsonElement jsonElement) {
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"");
        throw new JsonEncodingException("Class with serial name " + string + " cannot be serialized polymorphically because it is represented as " + Reflection.getOrCreateKotlinClass(jsonElement.getClass()).getSimpleName() + ". Make sure that its JsonTransformingSerializer returns JsonObject, so class discriminator can be added to it.");
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=176)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassDiscriminatorMode.values().length];
            try {
                nArray[ClassDiscriminatorMode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassDiscriminatorMode.POLYMORPHIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassDiscriminatorMode.ALL_JSON_OBJECTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

