/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.ArrayAsSequence;
import kotlinx.serialization.json.internal.CharArrayPoolBatchSize;
import kotlinx.serialization.json.internal.InternalJsonReader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u0010\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\rH\u0016J\u0018\u0010$\u001a\u00020 2\u0006\u0010#\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0016J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0014J\u001a\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u0013H\u0016J\u0006\u0010,\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\r8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006-"}, d2={"Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "reader", "Lkotlinx/serialization/json/internal/InternalJsonReader;", "buffer", "", "<init>", "(Lkotlinx/serialization/json/internal/InternalJsonReader;[C)V", "getReader", "()Lkotlinx/serialization/json/internal/InternalJsonReader;", "getBuffer", "()[C", "threshold", "", "source", "Lkotlinx/serialization/json/internal/ArrayAsSequence;", "getSource", "()Lkotlinx/serialization/json/internal/ArrayAsSequence;", "canConsumeValue", "", "preload", "", "unprocessedCount", "prefetchOrEof", "position", "consumeNextToken", "", "expected", "", "skipWhitespaces", "ensureHaveChars", "consumeKeyString", "", "indexOf", "char", "startPos", "substring", "endPos", "appendRange", "fromIndex", "toIndex", "peekLeadingMatchingValue", "keyToMatch", "isLenient", "release", "kotlinx-serialization-json"})
public class ReaderJsonLexer
extends AbstractJsonLexer {
    private final InternalJsonReader reader;
    private final char[] buffer;
    protected int threshold;
    private final ArrayAsSequence source;

    public ReaderJsonLexer(InternalJsonReader internalJsonReader, char[] cArray) {
        Intrinsics.checkNotNullParameter((Object)internalJsonReader, (String)"");
        Intrinsics.checkNotNullParameter((Object)cArray, (String)"");
        this.reader = internalJsonReader;
        this.buffer = cArray;
        this.threshold = 128;
        this.source = new ArrayAsSequence(this.buffer);
        this.preload(0);
    }

    public /* synthetic */ ReaderJsonLexer(InternalJsonReader internalJsonReader, char[] cArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cArray = CharArrayPoolBatchSize.INSTANCE.take();
        }
        this(internalJsonReader, cArray);
    }

    public final InternalJsonReader getReader() {
        return this.reader;
    }

    public final char[] getBuffer() {
        return this.buffer;
    }

    @Override
    protected ArrayAsSequence getSource() {
        return this.source;
    }

    @Override
    public boolean canConsumeValue() {
        this.ensureHaveChars();
        int n = this.currentPosition;
        while ((n = this.prefetchOrEof(n)) != -1) {
            char c = this.getSource().charAt(n);
            AbstractJsonLexer abstractJsonLexer = this;
            char c2 = c;
            boolean bl = false;
            if (c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t') {
                ++n;
                continue;
            }
            this.currentPosition = n;
            return this.isValidValueStart(c);
        }
        this.currentPosition = n;
        return false;
    }

    private final void preload(int n) {
        int n2;
        char[] cArray = this.getSource().getBuffer$kotlinx_serialization_json();
        if (n != 0) {
            ArraysKt.copyInto((char[])cArray, (char[])cArray, (int)0, (int)this.currentPosition, (int)(this.currentPosition + n));
        }
        int n3 = this.getSource().length();
        for (int i = n; i != n3; i += n2) {
            n2 = this.reader.read(cArray, i, n3 - i);
            if (n2 != -1) continue;
            this.getSource().trim(i);
            this.threshold = -1;
            break;
        }
        this.currentPosition = 0;
    }

    @Override
    public int prefetchOrEof(int n) {
        if (n < this.getSource().length()) {
            return n;
        }
        this.currentPosition = n;
        this.ensureHaveChars();
        if (this.currentPosition != 0 || ((CharSequence)this.getSource()).length() == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public byte consumeNextToken() {
        this.ensureHaveChars();
        ArrayAsSequence arrayAsSequence = this.getSource();
        int n = this.currentPosition;
        while ((n = this.prefetchOrEof(n)) != -1) {
            char c;
            byte by;
            if ((by = AbstractJsonLexerKt.charToTokenClass(c = arrayAsSequence.charAt(n++))) == 3) continue;
            this.currentPosition = n;
            return by;
        }
        this.currentPosition = n;
        return 10;
    }

    @Override
    public void consumeNextToken(char c) {
        this.ensureHaveChars();
        ArrayAsSequence arrayAsSequence = this.getSource();
        int n = this.currentPosition;
        while ((n = this.prefetchOrEof(n)) != -1) {
            char c2 = arrayAsSequence.charAt(n++);
            AbstractJsonLexer abstractJsonLexer = this;
            char c3 = c2;
            boolean bl = false;
            if (c3 == ' ' || c3 == '\n' || c3 == '\r' || c3 == '\t') continue;
            this.currentPosition = n;
            if (c2 == c) {
                return;
            }
            this.unexpectedToken(c);
        }
        this.currentPosition = n;
        this.unexpectedToken(c);
    }

    @Override
    public int skipWhitespaces() {
        int n = this.currentPosition;
        while ((n = this.prefetchOrEof(n)) != -1) {
            char c = this.getSource().charAt(n);
            AbstractJsonLexer abstractJsonLexer = this;
            char c2 = c;
            boolean bl = false;
            if (!(c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t')) break;
            ++n;
        }
        this.currentPosition = n;
        return n;
    }

    @Override
    public void ensureHaveChars() {
        int n = this.currentPosition;
        int n2 = this.getSource().length();
        int n3 = n2 - n;
        if (n3 > this.threshold) {
            return;
        }
        this.preload(n3);
    }

    @Override
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int n = this.currentPosition;
        int n2 = this.indexOf('\"', n);
        if (n2 == -1) {
            if ((n = this.prefetchOrEof(n)) == -1) {
                String string;
                AbstractJsonLexer abstractJsonLexer = this;
                byte by = 1;
                boolean bl = true;
                boolean bl2 = false;
                String string2 = AbstractJsonLexerKt.tokenDescription(by);
                int n3 = abstractJsonLexer.currentPosition - 1;
                String string3 = string = abstractJsonLexer.currentPosition == AbstractJsonLexer.access$getSource(abstractJsonLexer).length() || n3 < 0 ? "EOF" : String.valueOf(AbstractJsonLexer.access$getSource(abstractJsonLexer).charAt(n3));
                String string4 = string2;
                AbstractJsonLexer abstractJsonLexer2 = abstractJsonLexer;
                boolean bl3 = false;
                AbstractJsonLexer.fail$default(abstractJsonLexer2, "Expected " + string4 + ", but had '" + string3 + "' instead", n3, null, 4, null);
                throw new KotlinNothingValueException();
            }
            return this.consumeString(this.getSource(), this.currentPosition, n);
        }
        for (int i = n; i < n2; ++i) {
            if (this.getSource().charAt(i) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i);
        }
        this.currentPosition = n2 + 1;
        return this.substring(n, n2);
    }

    @Override
    public int indexOf(char c, int n) {
        ArrayAsSequence arrayAsSequence = this.getSource();
        int n2 = arrayAsSequence.length();
        for (int i = n; i < n2; ++i) {
            if (arrayAsSequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String substring(int n, int n2) {
        return this.getSource().substring(n, n2);
    }

    @Override
    protected void appendRange(int n, int n2) {
        StringBuilder stringBuilder = this.getEscapedString();
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(this.getSource().getBuffer$kotlinx_serialization_json(), n, n2 - n), (String)"");
    }

    @Override
    public String peekLeadingMatchingValue(String string, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return null;
    }

    public final void release() {
        CharArrayPoolBatchSize.INSTANCE.release(this.buffer);
    }
}

