/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.FloatDecayAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J \u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/compose/animation/core/FloatExponentialDecaySpec;", "Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "frictionMultiplier", "", "absVelocityThreshold", "<init>", "(FF)V", "getAbsVelocityThreshold", "()F", "friction", "getValueFromNanos", "playTimeNanos", "", "initialValue", "initialVelocity", "getVelocityFromNanos", "getDurationNanos", "getTargetValue", "animation-core"})
public final class FloatExponentialDecaySpec
implements FloatDecayAnimationSpec {
    private final float absVelocityThreshold;
    private final float friction;
    public static final int $stable;

    public FloatExponentialDecaySpec(float f, float f2) {
        this.absVelocityThreshold = Math.max(1.0E-7f, Math.abs(f2));
        this.friction = -4.2f * Math.max(1.0E-4f, f);
    }

    public /* synthetic */ FloatExponentialDecaySpec(float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.1f;
        }
        this(f, f2);
    }

    @Override
    public float getAbsVelocityThreshold() {
        return this.absVelocityThreshold;
    }

    @Override
    public float getValueFromNanos(long l2, float f, float f2) {
        long l3 = l2 / 1000000L;
        return f - f2 / this.friction + f2 / this.friction * (float)Math.exp(this.friction * (float)l3 / 1000.0f);
    }

    @Override
    public float getVelocityFromNanos(long l2, float f, float f2) {
        long l3 = l2 / 1000000L;
        return f2 * (float)Math.exp((float)l3 / 1000.0f * this.friction);
    }

    @Override
    public long getDurationNanos(float f, float f2) {
        return (long)(1000.0f * (float)Math.log(this.getAbsVelocityThreshold() / Math.abs(f2)) / this.friction) * 1000000L;
    }

    @Override
    public float getTargetValue(float f, float f2) {
        if (Math.abs(f2) <= this.getAbsVelocityThreshold()) {
            return f;
        }
        double d2 = Math.log(Math.abs(this.getAbsVelocityThreshold() / f2)) / (double)this.friction * (double)1000;
        return f - f2 / this.friction + f2 / this.friction * (float)Math.exp((double)this.friction * d2 / (double)1000.0f);
    }

    public FloatExponentialDecaySpec() {
        this(0.0f, 0.0f, 3, null);
    }
}

