/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatComboBoxUI;
import com.formdev.flatlaf.ui.FlatScrollPaneUI;
import com.formdev.flatlaf.ui.FlatSpinnerUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicBorders;

public class FlatBorder
extends BasicBorders.MarginBorder
implements FlatStylingSupport.StyleableBorder {
    @FlatStylingSupport.Styleable
    protected int focusWidth = UIManager.getInt("Component.focusWidth");
    @FlatStylingSupport.Styleable
    protected float innerFocusWidth = FlatUIUtils.getUIFloat("Component.innerFocusWidth", 0.0f);
    @FlatStylingSupport.Styleable
    protected float innerOutlineWidth = FlatUIUtils.getUIFloat("Component.innerOutlineWidth", 0.0f);
    @FlatStylingSupport.Styleable
    protected float borderWidth = FlatUIUtils.getUIFloat("Component.borderWidth", 1.0f);
    @FlatStylingSupport.Styleable
    protected Color focusColor = UIManager.getColor("Component.focusColor");
    @FlatStylingSupport.Styleable
    protected Color borderColor = UIManager.getColor("Component.borderColor");
    @FlatStylingSupport.Styleable
    protected Color disabledBorderColor = UIManager.getColor("Component.disabledBorderColor");
    @FlatStylingSupport.Styleable
    protected Color focusedBorderColor = UIManager.getColor("Component.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color errorBorderColor = UIManager.getColor("Component.error.borderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color errorFocusedBorderColor = UIManager.getColor("Component.error.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color warningBorderColor = UIManager.getColor("Component.warning.borderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color warningFocusedBorderColor = UIManager.getColor("Component.warning.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color customBorderColor = UIManager.getColor("Component.custom.borderColor");
    @FlatStylingSupport.Styleable
    protected String outline;
    @FlatStylingSupport.Styleable
    protected Color outlineColor;
    @FlatStylingSupport.Styleable
    protected Color outlineFocusedColor;

    @Override
    public Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObject(this, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics2D);
            float f = UIScale.scale((float)this.getFocusWidth(component));
            float f2 = 0.0f;
            float f3 = UIScale.scale(this.getBorderWidth(component));
            float f4 = UIScale.scale((float)this.getArc(component));
            Color color = this.getOutlineColor(component);
            Color color2 = null;
            if (color != null || this.isFocused(component)) {
                float f5;
                float f6 = !this.isCellEditor(component) && !(component instanceof JScrollPane) ? (color != null ? this.innerOutlineWidth : this.getInnerFocusWidth(component)) : (f5 = 0.0f);
                if (f > 0.0f || f5 > 0.0f) {
                    color2 = color != null ? color : this.getFocusColor(component);
                    f2 = f3 + UIScale.scale(f5);
                }
            }
            Color color3 = color != null ? color : this.getBorderColor(component);
            FlatUIUtils.paintOutlinedComponent(graphics2D, n, n2, n3, n4, f, 1.0f, f2, f3, f4, color2, color3, null);
        }
        finally {
            graphics2D.dispose();
        }
    }

    protected Color getOutlineColor(Component component) {
        if (!(component instanceof JComponent)) {
            return null;
        }
        Color[] colorArray = ((JComponent)component).getClientProperty("JComponent.outline");
        if (colorArray == null) {
            colorArray = this.outline;
        }
        if (colorArray == null) {
            if (this.outlineColor != null && this.outlineFocusedColor != null) {
                colorArray = new Color[]{this.outlineFocusedColor, this.outlineColor};
            } else if (this.outlineColor != null) {
                colorArray = this.outlineColor;
            } else if (this.outlineFocusedColor != null) {
                colorArray = this.outlineFocusedColor;
            }
        }
        if (colorArray instanceof String) {
            switch ((String)colorArray) {
                case "error": {
                    return this.isFocused(component) ? this.errorFocusedBorderColor : this.errorBorderColor;
                }
                case "warning": {
                    return this.isFocused(component) ? this.warningFocusedBorderColor : this.warningBorderColor;
                }
            }
        } else {
            if (colorArray instanceof Color) {
                Color color = (Color)colorArray;
                if (!this.isFocused(component) && this.customBorderColor instanceof DerivedColor) {
                    color = ((DerivedColor)this.customBorderColor).derive(color);
                }
                return color;
            }
            if (colorArray instanceof Color[] && ((Color[])colorArray).length >= 2) {
                return ((Color[])colorArray)[this.isFocused(component) ? 0 : 1];
            }
        }
        return null;
    }

    protected Color getFocusColor(Component component) {
        return this.focusColor;
    }

    protected Paint getBorderColor(Component component) {
        return this.isEnabled(component) ? (this.isFocused(component) ? this.focusedBorderColor : this.borderColor) : this.disabledBorderColor;
    }

    protected boolean isEnabled(Component component) {
        Component component2;
        if (component instanceof JScrollPane && (component2 = FlatScrollPaneUI.getView((JScrollPane)component)) != null && !this.isEnabled(component2)) {
            return false;
        }
        return component.isEnabled();
    }

    protected boolean isFocused(Component component) {
        if (component instanceof JScrollPane) {
            return FlatScrollPaneUI.isPermanentFocusOwner((JScrollPane)component);
        }
        if (component instanceof JComboBox) {
            return FlatComboBoxUI.isPermanentFocusOwner((JComboBox)component);
        }
        if (component instanceof JSpinner) {
            return FlatSpinnerUI.isPermanentFocusOwner((JSpinner)component);
        }
        return FlatUIUtils.isPermanentFocusOwner(component);
    }

    protected boolean isCellEditor(Component component) {
        return FlatUIUtils.isCellEditor(component);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        float f = UIScale.scale((float)this.getFocusWidth(component));
        int n = Math.round(f + UIScale.scale((float)this.getLineWidth(component)));
        insets = super.getBorderInsets(component, insets);
        insets.top = UIScale.scale(insets.top) + n;
        insets.left = UIScale.scale(insets.left) + n;
        insets.bottom = UIScale.scale(insets.bottom) + n;
        insets.right = UIScale.scale(insets.right) + n;
        if (this.isCellEditor(component)) {
            insets.bottom = 0;
            insets.top = 0;
            if (component.getComponentOrientation().isLeftToRight()) {
                insets.right = 0;
            } else {
                insets.left = 0;
            }
        }
        return insets;
    }

    protected int getFocusWidth(Component component) {
        if (this.isCellEditor(component)) {
            return 0;
        }
        return this.focusWidth;
    }

    protected float getInnerFocusWidth(Component component) {
        return this.innerFocusWidth;
    }

    protected int getLineWidth(Component component) {
        return 1;
    }

    protected float getBorderWidth(Component component) {
        return this.borderWidth;
    }

    protected int getArc(Component component) {
        return 0;
    }
}

