/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatToggleButtonUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class FlatButtonBorder
extends FlatBorder {
    @FlatStylingSupport.Styleable
    protected int arc = UIManager.getInt("Button.arc");
    protected Color endBorderColor = UIManager.getColor("Button.endBorderColor");
    @FlatStylingSupport.Styleable
    protected Color hoverBorderColor = UIManager.getColor("Button.hoverBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected float defaultBorderWidth = FlatUIUtils.getUIFloat("Button.default.borderWidth", 1.0f);
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultBorderColor = FlatUIUtils.getUIColor("Button.default.startBorderColor", "Button.default.borderColor");
    protected Color defaultEndBorderColor = UIManager.getColor("Button.default.endBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusedBorderColor = UIManager.getColor("Button.default.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusColor = UIManager.getColor("Button.default.focusColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultHoverBorderColor = UIManager.getColor("Button.default.hoverBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected float toolbarFocusWidth = FlatUIUtils.getUIFloat("Button.toolbar.focusWidth", 1.5f);
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarFocusColor = UIManager.getColor("Button.toolbar.focusColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Insets toolbarMargin = UIManager.getInsets("Button.toolbar.margin");
    @FlatStylingSupport.Styleable(dot=true)
    protected Insets toolbarSpacingInsets = UIManager.getInsets("Button.toolbar.spacingInsets");

    public FlatButtonBorder() {
        this.innerFocusWidth = FlatUIUtils.getUIFloat("Button.innerFocusWidth", this.innerFocusWidth);
        this.borderWidth = FlatUIUtils.getUIFloat("Button.borderWidth", this.borderWidth);
        this.borderColor = FlatUIUtils.getUIColor("Button.startBorderColor", "Button.borderColor");
        this.disabledBorderColor = UIManager.getColor("Button.disabledBorderColor");
        this.focusedBorderColor = UIManager.getColor("Button.focusedBorderColor");
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!(!FlatButtonUI.isContentAreaFilled(component) || FlatButtonUI.isToolBarButton(component) || FlatButtonUI.isBorderlessButton(component) && !FlatUIUtils.isPermanentFocusOwner(component) || FlatButtonUI.isHelpButton(component) || FlatToggleButtonUI.isTabButton(component))) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
        } else if (FlatButtonUI.isToolBarButton(component) && this.isFocused(component)) {
            this.paintToolBarFocus(component, graphics, n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintToolBarFocus(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics2D);
            float f = UIScale.scale(this.toolbarFocusWidth);
            float f2 = UIScale.scale((float)this.getArc(component));
            Color color = this.getOutlineColor(component);
            Insets insets = UIScale.scale(this.toolbarSpacingInsets);
            Color color2 = color != null ? color : this.getFocusColor(component);
            FlatUIUtils.paintOutlinedComponent(graphics2D, n += insets.left, n2 += insets.top, n3 -= insets.left + insets.right, n4 -= insets.top + insets.bottom, 0.0f, 0.0f, 0.0f, f, f2, null, color2, null);
        }
        finally {
            graphics2D.dispose();
        }
    }

    @Override
    protected Color getFocusColor(Component component) {
        return this.toolbarFocusColor != null && FlatButtonUI.isToolBarButton(component) ? this.toolbarFocusColor : (FlatButtonUI.isDefaultButton(component) ? this.defaultFocusColor : super.getFocusColor(component));
    }

    @Override
    protected boolean isFocused(Component component) {
        return FlatButtonUI.isFocusPainted(component) && super.isFocused(component);
    }

    @Override
    protected Paint getBorderColor(Component component) {
        Color color;
        boolean bl = FlatButtonUI.isDefaultButton(component);
        Paint paint = FlatButtonUI.buttonStateColor(component, bl ? this.defaultBorderColor : this.borderColor, this.disabledBorderColor, bl ? this.defaultFocusedBorderColor : this.focusedBorderColor, bl ? this.defaultHoverBorderColor : this.hoverBorderColor, null);
        Color color2 = bl ? this.defaultBorderColor : this.borderColor;
        Color color3 = color = bl ? this.defaultEndBorderColor : this.endBorderColor;
        if (paint == color2 && color != null && !color2.equals(color)) {
            paint = new GradientPaint(0.0f, 0.0f, color2, 0.0f, component.getHeight(), color);
        }
        return paint;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        if (FlatButtonUI.isToolBarButton(component)) {
            Insets insets2 = component instanceof AbstractButton ? ((AbstractButton)component).getMargin() : null;
            FlatUIUtils.setInsets(insets, UIScale.scale(FlatUIUtils.addInsets(this.toolbarSpacingInsets, insets2 != null && !(insets2 instanceof UIResource) ? insets2 : this.toolbarMargin)));
        } else {
            insets = super.getBorderInsets(component, insets);
            if (FlatButtonUI.isIconOnlyOrSingleCharacterButton(component) && ((AbstractButton)component).getMargin() instanceof UIResource) {
                insets.left = insets.right = Math.min(insets.top, insets.bottom);
            }
        }
        return insets;
    }

    @Override
    protected int getFocusWidth(Component component) {
        return FlatToggleButtonUI.isTabButton(component) ? 0 : super.getFocusWidth(component);
    }

    @Override
    protected float getBorderWidth(Component component) {
        return FlatButtonUI.isDefaultButton(component) ? this.defaultBorderWidth : this.borderWidth;
    }

    @Override
    protected int getArc(Component component) {
        if (this.isCellEditor(component)) {
            return 0;
        }
        switch (FlatButtonUI.getButtonType(component)) {
            case 0: {
                return 0;
            }
            case 1: {
                return Short.MAX_VALUE;
            }
        }
        return this.arc;
    }
}

