/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatTextFieldUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

public class FlatCaret
extends DefaultCaret
implements UIResource {
    private static final String KEY_CARET_INFO = "FlatLaf.internal.caretInfo";
    private final String selectAllOnFocusPolicy;
    private final boolean selectAllOnMouseClick;
    private boolean inInstall;
    private boolean wasFocused;
    private boolean wasTemporaryLost;
    private boolean isMousePressed;
    private boolean isWordSelection;
    private boolean isLineSelection;
    private int dragSelectionStart;
    private int dragSelectionEnd;

    public FlatCaret(String string, boolean bl) {
        this.selectAllOnFocusPolicy = string;
        this.selectAllOnMouseClick = bl;
    }

    @Override
    public void install(JTextComponent jTextComponent) {
        long[] lArray = (long[])jTextComponent.getClientProperty(KEY_CARET_INFO);
        if (lArray != null) {
            jTextComponent.putClientProperty(KEY_CARET_INFO, null);
            if (System.currentTimeMillis() - 500L > lArray[3]) {
                lArray = null;
            }
        }
        if (lArray != null) {
            this.setBlinkRate((int)lArray[2]);
        }
        this.inInstall = true;
        try {
            super.install(jTextComponent);
        }
        finally {
            this.inInstall = false;
        }
        if (lArray != null) {
            this.select((int)lArray[1], (int)lArray[0]);
            if (this.isSelectionVisible()) {
                EventQueue.invokeLater(() -> {
                    if (this.getComponent() == null) {
                        return;
                    }
                    if (this.isSelectionVisible()) {
                        this.setSelectionVisible(false);
                        this.setSelectionVisible(true);
                    }
                });
            }
        }
    }

    @Override
    public void deinstall(JTextComponent jTextComponent) {
        jTextComponent.putClientProperty(KEY_CARET_INFO, new long[]{this.getDot(), this.getMark(), this.getBlinkRate(), System.currentTimeMillis()});
        super.deinstall(jTextComponent);
    }

    @Override
    protected void adjustVisibility(Rectangle rectangle) {
        Rectangle rectangle2;
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent != null && jTextComponent.getUI() instanceof FlatTextFieldUI && (rectangle2 = ((FlatTextFieldUI)jTextComponent.getUI()).getVisibleEditorRect()) != null) {
            rectangle.x -= rectangle2.x - jTextComponent.getInsets().left;
        }
        super.adjustVisibility(rectangle);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!(this.inInstall || this.wasTemporaryLost || this.isMousePressed && !this.selectAllOnMouseClick)) {
            this.selectAllOnFocusGained();
        }
        this.wasTemporaryLost = false;
        this.wasFocused = true;
        super.focusGained(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.wasTemporaryLost = focusEvent.isTemporary();
        super.focusLost(focusEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.isMousePressed = true;
        super.mousePressed(mouseEvent);
        JTextComponent jTextComponent = this.getComponent();
        this.isWordSelection = mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isConsumed();
        boolean bl = this.isLineSelection = mouseEvent.getClickCount() == 3 && SwingUtilities.isLeftMouseButton(mouseEvent) && (!mouseEvent.isConsumed() || jTextComponent.getDragEnabled());
        if (this.isLineSelection) {
            Action action;
            ActionMap actionMap = jTextComponent.getActionMap();
            Action action2 = action = actionMap != null ? actionMap.get("select-line") : null;
            if (action != null) {
                action.actionPerformed(new ActionEvent(jTextComponent, 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
            }
        }
        if (this.isWordSelection || this.isLineSelection) {
            int n = this.getMark();
            int n2 = this.getDot();
            this.dragSelectionStart = Math.min(n2, n);
            this.dragSelectionEnd = Math.max(n2, n);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.isMousePressed = false;
        this.isWordSelection = false;
        this.isLineSelection = false;
        super.mouseReleased(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        block7: {
            if ((this.isWordSelection || this.isLineSelection) && !mouseEvent.isConsumed() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                JTextComponent jTextComponent = this.getComponent();
                int n = jTextComponent.viewToModel(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                try {
                    if (n > this.dragSelectionEnd) {
                        this.select(this.dragSelectionStart, this.isWordSelection ? Utilities.getWordEnd(jTextComponent, n) : Utilities.getRowEnd(jTextComponent, n));
                        break block7;
                    }
                    if (n < this.dragSelectionStart) {
                        this.select(this.dragSelectionEnd, this.isWordSelection ? Utilities.getWordStart(jTextComponent, n) : Utilities.getRowStart(jTextComponent, n));
                        break block7;
                    }
                    this.select(this.dragSelectionStart, this.dragSelectionEnd);
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            } else {
                super.mouseDragged(mouseEvent);
            }
        }
    }

    protected void selectAllOnFocusGained() {
        JTextComponent jTextComponent = this.getComponent();
        Document document = jTextComponent.getDocument();
        if (document == null || !jTextComponent.isEnabled() || !jTextComponent.isEditable() || FlatUIUtils.isCellEditor(jTextComponent)) {
            return;
        }
        Object object = jTextComponent.getClientProperty("JTextField.selectAllOnFocusPolicy");
        if (object == null) {
            object = this.selectAllOnFocusPolicy;
        }
        if (object == null || "never".equals(object)) {
            return;
        }
        if (!"always".equals(object)) {
            int n;
            if (this.wasFocused) {
                return;
            }
            int n2 = this.getDot();
            if (n2 != (n = this.getMark()) || n2 != document.getLength()) {
                return;
            }
        }
        if (jTextComponent instanceof JFormattedTextField) {
            EventQueue.invokeLater(() -> {
                JTextComponent jTextComponent = this.getComponent();
                if (jTextComponent == null) {
                    return;
                }
                this.select(0, jTextComponent.getDocument().getLength());
            });
        } else {
            this.select(0, document.getLength());
        }
    }

    private void select(int n, int n2) {
        if (n != this.getMark()) {
            this.setDot(n);
        }
        if (n2 != this.getDot()) {
            this.moveDot(n2);
        }
    }

    public void scrollCaretToVisible() {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null || jTextComponent.getUI() == null) {
            return;
        }
        try {
            Rectangle rectangle = jTextComponent.getUI().modelToView(jTextComponent, this.getDot(), this.getDotBias());
            if (rectangle != null) {
                this.adjustVisibility(rectangle);
                this.damage(rectangle);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

