/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatDropShadowBorder;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatInternalFrameTitlePane;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.FlatWindowResizer;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class FlatInternalFrameUI
extends BasicInternalFrameUI
implements FlatStylingSupport.StyleableUI {
    protected FlatWindowResizer windowResizer;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatInternalFrameUI((JInternalFrame)jComponent);
    }

    public FlatInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        LookAndFeel.installProperty(this.frame, "opaque", false);
        this.windowResizer = this.createWindowResizer();
        this.installStyle();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (this.windowResizer != null) {
            this.windowResizer.uninstall();
            this.windowResizer = null;
        }
        this.oldStyleValues = null;
        this.borderShared = null;
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        return new FlatInternalFrameTitlePane(jInternalFrame);
    }

    protected FlatWindowResizer createWindowResizer() {
        return new FlatWindowResizer.InternalFrameResizer(this.frame, this::getDesktopManager);
    }

    @Override
    protected MouseInputAdapter createBorderListener(JInternalFrame jInternalFrame) {
        return new FlatBorderListener();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return FlatStylingSupport.createPropertyChangeListener(this.frame, this::installStyle, super.createPropertyChangeListener());
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.frame, "InternalFrame"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.frame, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.frame.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, this.frame.getBorder(), string);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (!jComponent.isOpaque() && !FlatUIUtils.hasOpaqueBeenExplicitlySet(jComponent)) {
            Insets insets = jComponent.getInsets();
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(insets.left, insets.top, jComponent.getWidth() - insets.left - insets.right, jComponent.getHeight() - insets.top - insets.bottom);
        }
        super.update(graphics, jComponent);
    }

    protected class FlatBorderListener
    extends BasicInternalFrameUI.BorderListener {
        protected FlatBorderListener() {
            super(FlatInternalFrameUI.this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Rectangle rectangle;
            if (mouseEvent.getClickCount() == 2 && !FlatInternalFrameUI.this.frame.isIcon() && mouseEvent.getSource() instanceof FlatInternalFrameTitlePane && (rectangle = ((FlatInternalFrameTitlePane)mouseEvent.getSource()).getFrameIconBounds()) != null && rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                if (FlatInternalFrameUI.this.frame.isClosable()) {
                    FlatInternalFrameUI.this.frame.doDefaultCloseAction();
                }
                return;
            }
            super.mouseClicked(mouseEvent);
        }
    }

    public static class FlatInternalFrameBorder
    extends FlatEmptyBorder
    implements FlatStylingSupport.StyleableBorder {
        @FlatStylingSupport.Styleable
        protected Color activeBorderColor = UIManager.getColor("InternalFrame.activeBorderColor");
        @FlatStylingSupport.Styleable
        protected Color inactiveBorderColor = UIManager.getColor("InternalFrame.inactiveBorderColor");
        @FlatStylingSupport.Styleable
        protected int borderLineWidth = FlatUIUtils.getUIInt("InternalFrame.borderLineWidth", 1);
        @FlatStylingSupport.Styleable
        protected boolean dropShadowPainted = UIManager.getBoolean("InternalFrame.dropShadowPainted");
        private final FlatDropShadowBorder activeDropShadowBorder = new FlatDropShadowBorder(UIManager.getColor("InternalFrame.activeDropShadowColor"), UIManager.getInsets("InternalFrame.activeDropShadowInsets"), FlatUIUtils.getUIFloat("InternalFrame.activeDropShadowOpacity", 0.5f));
        private final FlatDropShadowBorder inactiveDropShadowBorder = new FlatDropShadowBorder(UIManager.getColor("InternalFrame.inactiveDropShadowColor"), UIManager.getInsets("InternalFrame.inactiveDropShadowInsets"), FlatUIUtils.getUIFloat("InternalFrame.inactiveDropShadowOpacity", 0.5f));

        public FlatInternalFrameBorder() {
            super(UIManager.getInsets("InternalFrame.borderMargins"));
        }

        @Override
        public Object applyStyleProperty(String string, Object object) {
            switch (string) {
                case "borderMargins": {
                    return this.applyStyleProperty((Insets)object);
                }
                case "activeDropShadowColor": {
                    return this.activeDropShadowBorder.applyStyleProperty("shadowColor", object);
                }
                case "activeDropShadowInsets": {
                    return this.activeDropShadowBorder.applyStyleProperty("shadowInsets", object);
                }
                case "activeDropShadowOpacity": {
                    return this.activeDropShadowBorder.applyStyleProperty("shadowOpacity", object);
                }
                case "inactiveDropShadowColor": {
                    return this.inactiveDropShadowBorder.applyStyleProperty("shadowColor", object);
                }
                case "inactiveDropShadowInsets": {
                    return this.inactiveDropShadowBorder.applyStyleProperty("shadowInsets", object);
                }
                case "inactiveDropShadowOpacity": {
                    return this.inactiveDropShadowBorder.applyStyleProperty("shadowOpacity", object);
                }
            }
            return FlatStylingSupport.applyToAnnotatedObject(this, string, object);
        }

        @Override
        public Map<String, Class<?>> getStyleableInfos() {
            FlatStylingSupport.StyleableInfosMap styleableInfosMap = new FlatStylingSupport.StyleableInfosMap();
            FlatStylingSupport.collectAnnotatedStyleableInfos(this, styleableInfosMap);
            styleableInfosMap.put("borderMargins", Insets.class);
            styleableInfosMap.put("activeDropShadowColor", Color.class);
            styleableInfosMap.put("activeDropShadowInsets", Insets.class);
            styleableInfosMap.put("activeDropShadowOpacity", Float.TYPE);
            styleableInfosMap.put("inactiveDropShadowColor", Color.class);
            styleableInfosMap.put("inactiveDropShadowInsets", Insets.class);
            styleableInfosMap.put("inactiveDropShadowOpacity", Float.TYPE);
            return styleableInfosMap;
        }

        @Override
        public Object getStyleableValue(String string) {
            switch (string) {
                case "borderMargins": {
                    return this.getStyleableValue();
                }
                case "activeDropShadowColor": {
                    return this.activeDropShadowBorder.getStyleableValue("shadowColor");
                }
                case "activeDropShadowInsets": {
                    return this.activeDropShadowBorder.getStyleableValue("shadowInsets");
                }
                case "activeDropShadowOpacity": {
                    return this.activeDropShadowBorder.getStyleableValue("shadowOpacity");
                }
                case "inactiveDropShadowColor": {
                    return this.inactiveDropShadowBorder.getStyleableValue("shadowColor");
                }
                case "inactiveDropShadowInsets": {
                    return this.inactiveDropShadowBorder.getStyleableValue("shadowInsets");
                }
                case "inactiveDropShadowOpacity": {
                    return this.inactiveDropShadowBorder.getStyleableValue("shadowOpacity");
                }
            }
            return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            if (component instanceof JInternalFrame && ((JInternalFrame)component).isMaximum()) {
                insets.left = UIScale.scale(Math.min(this.borderLineWidth, this.left));
                insets.top = UIScale.scale(Math.min(this.borderLineWidth, this.top));
                insets.right = UIScale.scale(Math.min(this.borderLineWidth, this.right));
                insets.bottom = UIScale.scale(Math.min(this.borderLineWidth, this.bottom));
                return insets;
            }
            return super.getBorderInsets(component, insets);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JInternalFrame jInternalFrame = (JInternalFrame)component;
            Insets insets = this.getBorderInsets(component);
            float f = UIScale.scale((float)this.borderLineWidth);
            float f2 = (float)(n + insets.left) - f;
            float f3 = (float)(n2 + insets.top) - f;
            float f4 = (float)(n3 - insets.left - insets.right) + f * 2.0f;
            float f5 = (float)(n4 - insets.top - insets.bottom) + f * 2.0f;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                FlatUIUtils.setRenderingHints(graphics2D);
                graphics2D.setColor(jInternalFrame.isSelected() ? this.activeBorderColor : this.inactiveBorderColor);
                if (this.dropShadowPainted) {
                    FlatDropShadowBorder flatDropShadowBorder = jInternalFrame.isSelected() ? this.activeDropShadowBorder : this.inactiveDropShadowBorder;
                    Insets insets2 = flatDropShadowBorder.getBorderInsets();
                    flatDropShadowBorder.paintBorder(component, graphics2D, (int)f2 - insets2.left, (int)f3 - insets2.top, (int)f4 + insets2.left + insets2.right, (int)f5 + insets2.top + insets2.bottom);
                }
                graphics2D.fill(FlatUIUtils.createRectangle(f2, f3, f4, f5, f));
            }
            finally {
                graphics2D.dispose();
            }
        }
    }
}

