/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatMenuBarUI;
import com.formdev.flatlaf.ui.FlatMenuItemRenderer;
import com.formdev.flatlaf.ui.FlatMenuItemUI;
import com.formdev.flatlaf.ui.FlatRootPaneUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.function.Function;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.BasicMenuUI;

@FlatStylingSupport.StyleableFields(value={@FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="selectionBackground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="selectionForeground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="disabledForeground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="acceleratorForeground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="acceleratorSelectionForeground")})
public class FlatMenuUI
extends BasicMenuUI
implements FlatStylingSupport.StyleableLookupProvider,
FlatStylingSupport.StyleableUI {
    private FlatMenuItemRenderer renderer;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatMenuUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.menuItem, "iconTextGap", FlatUIUtils.getUIInt("MenuItem.iconTextGap", 4));
        this.menuItem.setRolloverEnabled(true);
        this.renderer = this.createRenderer();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        FlatMenuItemRenderer.clearClientProperties(this.menuItem.getParent());
        this.renderer = null;
        this.oldStyleValues = null;
    }

    protected FlatMenuItemRenderer createRenderer() {
        return new FlatMenuRenderer(this.menuItem, this.checkIcon, this.arrowIcon, this.acceleratorFont, this.acceleratorDelimiter);
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new BasicMenuUI.MouseInputHandler(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                this.rollover(mouseEvent, true);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                this.rollover(mouseEvent, false);
            }

            private void rollover(MouseEvent mouseEvent, boolean bl) {
                JMenu jMenu = (JMenu)mouseEvent.getSource();
                if (jMenu.isTopLevelMenu() && jMenu.isRolloverEnabled()) {
                    jMenu.getModel().setRollover(bl);
                    jMenu.repaint();
                }
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return FlatStylingSupport.createPropertyChangeListener(jComponent, this::installStyle, super.createPropertyChangeListener(jComponent));
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.menuItem, "Menu"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        return FlatMenuItemUI.applyStyleProperty(this.menuItem, this, this.renderer, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatMenuItemUI.getStyleableInfos(this, this.renderer);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatMenuItemUI.getStyleableValue(this, this.renderer, string);
    }

    @Override
    public MethodHandles.Lookup getLookupForStyling() {
        return MethodHandles.lookup();
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return ((JMenu)this.menuItem).isTopLevelMenu() ? jComponent.getPreferredSize() : null;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        return this.renderer.getPreferredMenuItemSize();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.renderer.paintMenuItem(graphics, this.selectionBackground, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
    }

    protected class FlatMenuRenderer
    extends FlatMenuItemRenderer {
        protected Insets menuBarSelectionInsets;
        protected Insets menuBarSelectionEmbeddedInsets;
        protected int menuBarSelectionArc;
        protected Color hoverBackground;
        protected Color menuBarSelectionBackground;
        protected Color menuBarSelectionForeground;
        protected Color menuBarUnderlineSelectionBackground;
        protected Color menuBarUnderlineSelectionColor;
        protected int menuBarUnderlineSelectionHeight;

        protected FlatMenuRenderer(JMenuItem jMenuItem, Icon icon, Icon icon2, Font font, String string) {
            super(jMenuItem, icon, icon2, font, string);
            this.menuBarSelectionInsets = UIManager.getInsets("MenuBar.selectionInsets");
            this.menuBarSelectionEmbeddedInsets = UIManager.getInsets("MenuBar.selectionEmbeddedInsets");
            this.menuBarSelectionArc = UIManager.getInt("MenuBar.selectionArc");
            this.hoverBackground = UIManager.getColor("MenuBar.hoverBackground");
            this.menuBarSelectionBackground = UIManager.getColor("MenuBar.selectionBackground");
            this.menuBarSelectionForeground = UIManager.getColor("MenuBar.selectionForeground");
            this.menuBarUnderlineSelectionBackground = UIManager.getColor("MenuBar.underlineSelectionBackground");
            this.menuBarUnderlineSelectionColor = UIManager.getColor("MenuBar.underlineSelectionColor");
            this.menuBarUnderlineSelectionHeight = FlatUIUtils.getUIInt("MenuBar.underlineSelectionHeight", -1);
        }

        @Override
        protected void paintBackground(Graphics graphics) {
            super.paintBackground(graphics);
            if (((JMenu)this.menuItem).isTopLevelMenu() && this.isHover()) {
                Color color = this.deriveBackground(this.getStyleFromMenuBarUI(flatMenuBarUI -> flatMenuBarUI.hoverBackground, this.hoverBackground));
                if (this.isUnderlineSelection()) {
                    graphics.setColor(color);
                    graphics.fillRect(0, 0, this.menuItem.getWidth(), this.menuItem.getHeight());
                } else {
                    this.paintSelection(graphics, color, this.selectionInsets, this.selectionArc);
                }
            }
        }

        @Override
        protected void paintSelection(Graphics graphics, Color color, Insets insets, int n) {
            if (((JMenu)this.menuItem).isTopLevelMenu()) {
                Container container;
                JRootPane jRootPane;
                if (!this.isHover()) {
                    color = this.getStyleFromMenuBarUI(flatMenuBarUI -> flatMenuBarUI.selectionBackground, this.menuBarSelectionBackground, color);
                }
                insets = (jRootPane = SwingUtilities.getRootPane(container = this.menuItem.getParent())) != null && jRootPane.getParent() instanceof Window && jRootPane.getJMenuBar() == container && FlatRootPaneUI.isMenuBarEmbedded(jRootPane) ? this.getStyleFromMenuBarUI(flatMenuBarUI -> flatMenuBarUI.selectionEmbeddedInsets, this.menuBarSelectionEmbeddedInsets) : this.getStyleFromMenuBarUI(flatMenuBarUI -> flatMenuBarUI.selectionInsets, this.menuBarSelectionInsets);
                n = this.getStyleFromMenuBarUI(flatMenuBarUI -> flatMenuBarUI.selectionArc != -1 ? Integer.valueOf(flatMenuBarUI.selectionArc) : null, this.menuBarSelectionArc);
            }
            super.paintSelection(graphics, color, insets, n);
        }

        @Override
        protected void paintUnderlineSelection(Graphics graphics, Color color, Color color2, int n) {
            if (((JMenu)this.menuItem).isTopLevelMenu()) {
                color = this.getStyleFromMenuBarUI(flatMenuBarUI -> flatMenuBarUI.underlineSelectionBackground, this.menuBarUnderlineSelectionBackground, color);
                color2 = this.getStyleFromMenuBarUI(flatMenuBarUI -> flatMenuBarUI.underlineSelectionColor, this.menuBarUnderlineSelectionColor, color2);
                n = this.getStyleFromMenuBarUI(flatMenuBarUI -> flatMenuBarUI.underlineSelectionHeight != -1 ? Integer.valueOf(flatMenuBarUI.underlineSelectionHeight) : null, this.menuBarUnderlineSelectionHeight != -1 ? this.menuBarUnderlineSelectionHeight : n);
            }
            super.paintUnderlineSelection(graphics, color, color2, n);
        }

        @Override
        protected void paintText(Graphics graphics, Rectangle rectangle, String string, Color color, Color color2) {
            if (((JMenu)this.menuItem).isTopLevelMenu() && !this.isUnderlineSelection()) {
                color = this.getStyleFromMenuBarUI(flatMenuBarUI -> flatMenuBarUI.selectionForeground, this.menuBarSelectionForeground, color);
            }
            super.paintText(graphics, rectangle, string, color, color2);
        }

        private boolean isHover() {
            ButtonModel buttonModel = this.menuItem.getModel();
            return buttonModel.isRollover() && !buttonModel.isArmed() && !buttonModel.isSelected() && buttonModel.isEnabled();
        }

        private <T> T getStyleFromMenuBarUI(Function<FlatMenuBarUI, T> function, T t, T t2) {
            return this.getStyleFromMenuBarUI(function, t != null ? t : t2);
        }

        private <T> T getStyleFromMenuBarUI(Function<FlatMenuBarUI, T> function, T t) {
            T t2;
            MenuBarUI menuBarUI;
            Container container = this.menuItem.getParent();
            if (container instanceof JMenuBar && (menuBarUI = ((JMenuBar)container).getUI()) instanceof FlatMenuBarUI && (t2 = function.apply((FlatMenuBarUI)menuBarUI)) != null) {
                return t2;
            }
            return t;
        }
    }
}

