/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatTableUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.function.Function;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.TableUI;

public class FlatTableCellBorder
extends FlatLineBorder {
    protected boolean showCellFocusIndicator = UIManager.getBoolean("Table.showCellFocusIndicator");
    private Component c;

    protected FlatTableCellBorder() {
        super(UIManager.getInsets("Table.cellMargins"), UIManager.getColor("Table.cellFocusColor"));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2 = FlatTableCellBorder.getStyleFromTableUI(component, flatTableUI -> flatTableUI.cellMargins);
        if (insets2 != null) {
            return FlatTableCellBorder.scaleInsets(component, insets, insets2.top, insets2.left, insets2.bottom, insets2.right);
        }
        return super.getBorderInsets(component, insets);
    }

    @Override
    public Color getLineColor() {
        Color color;
        if (this.c != null && (color = FlatTableCellBorder.getStyleFromTableUI(this.c, flatTableUI -> flatTableUI.cellFocusColor)) != null) {
            return color;
        }
        return super.getLineColor();
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.c = component;
        super.paintBorder(component, graphics, n, n2, n3, n4);
        this.c = null;
    }

    static <T> T getStyleFromTableUI(Component component, Function<FlatTableUI, T> function) {
        TableUI tableUI;
        JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, component);
        if (jTable != null && (tableUI = jTable.getUI()) instanceof FlatTableUI) {
            return function.apply((FlatTableUI)tableUI);
        }
        return null;
    }

    public static class Selected
    extends FlatTableCellBorder {
        public int maxCheckCellsEditable = 50;

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JTable jTable;
            boolean bl;
            Boolean bl2 = Selected.getStyleFromTableUI(component, flatTableUI -> flatTableUI.showCellFocusIndicator);
            boolean bl3 = bl = bl2 != null ? bl2 : this.showCellFocusIndicator;
            if (!bl && (jTable = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, component)) != null && !this.shouldShowCellFocusIndicator(jTable)) {
                return;
            }
            super.paintBorder(component, graphics, n, n2, n3, n4);
        }

        protected boolean shouldShowCellFocusIndicator(JTable jTable) {
            block8: {
                boolean bl;
                block7: {
                    boolean bl2 = jTable.getRowSelectionAllowed();
                    bl = jTable.getColumnSelectionAllowed();
                    if (bl2 && bl) {
                        return false;
                    }
                    if (!bl2) break block7;
                    if (jTable.getSelectedRowCount() != 1) {
                        return false;
                    }
                    int n = jTable.getColumnCount();
                    if (n > this.maxCheckCellsEditable) {
                        return true;
                    }
                    int n2 = jTable.getSelectedRow();
                    for (int i = 0; i < n; ++i) {
                        if (!jTable.isCellEditable(n2, i)) continue;
                        return true;
                    }
                    break block8;
                }
                if (!bl) break block8;
                if (jTable.getSelectedColumnCount() != 1) {
                    return false;
                }
                int n = jTable.getRowCount();
                if (n > this.maxCheckCellsEditable) {
                    return true;
                }
                int n3 = jTable.getSelectedColumn();
                for (int i = 0; i < n; ++i) {
                    if (!jTable.isCellEditable(i, n3)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class Focused
    extends FlatTableCellBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Border border;
            JTable jTable;
            if (component != null && component.getClass().getName().equals("javax.swing.JTable$BooleanRenderer") && (jTable = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, component)) != null && component.getForeground() == jTable.getSelectionForeground() && component.getBackground() == jTable.getSelectionBackground() && (border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder")) != null) {
                border.paintBorder(component, graphics, n, n2, n3, n4);
                return;
            }
            super.paintBorder(component, graphics, n, n2, n3, n4);
        }
    }

    public static class Default
    extends FlatTableCellBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }
    }
}

