/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatTableHeaderUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class FlatTableHeaderBorder
extends FlatEmptyBorder {
    protected Color separatorColor = UIManager.getColor("TableHeader.separatorColor");
    protected Color bottomSeparatorColor = UIManager.getColor("TableHeader.bottomSeparatorColor");
    protected boolean showTrailingVerticalLine = UIManager.getBoolean("TableHeader.showTrailingVerticalLine");

    public FlatTableHeaderBorder() {
        super(UIManager.getInsets("TableHeader.cellMargins"));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        JTableHeader jTableHeader = (JTableHeader)SwingUtilities.getAncestorOfClass(JTableHeader.class, component);
        if (jTableHeader != null && jTableHeader.getUI() instanceof FlatTableHeaderUI) {
            FlatTableHeaderUI flatTableHeaderUI = (FlatTableHeaderUI)jTableHeader.getUI();
            if (flatTableHeaderUI.cellMargins != null) {
                Insets insets2 = flatTableHeaderUI.cellMargins;
                return FlatTableHeaderBorder.scaleInsets(component, insets, insets2.top, insets2.left, insets2.bottom, insets2.right);
            }
        }
        return super.getBorderInsets(component, insets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        JTableHeader jTableHeader = (JTableHeader)SwingUtilities.getAncestorOfClass(JTableHeader.class, component);
        boolean bl = (jTableHeader != null ? jTableHeader : component).getComponentOrientation().isLeftToRight();
        boolean bl2 = !bl;
        boolean bl3 = bl;
        Color color = this.separatorColor;
        Color color2 = this.bottomSeparatorColor;
        if (jTableHeader != null) {
            int n5 = SwingUtilities.convertPoint((Component)component, (int)n, (int)n2, (Component)jTableHeader).x;
            if (this.isDraggedColumn(jTableHeader, n5)) {
                bl3 = true;
                bl2 = true;
            } else {
                if (n5 <= 0 && !bl && this.hideTrailingVerticalLine(jTableHeader)) {
                    bl2 = false;
                }
                if (n5 + n3 >= jTableHeader.getWidth() && bl && this.hideTrailingVerticalLine(jTableHeader)) {
                    bl3 = false;
                }
            }
            if (jTableHeader.getUI() instanceof FlatTableHeaderUI) {
                object = (FlatTableHeaderUI)jTableHeader.getUI();
                if (((FlatTableHeaderUI)object).separatorColor != null) {
                    color = ((FlatTableHeaderUI)object).separatorColor;
                }
                if (((FlatTableHeaderUI)object).bottomSeparatorColor != null) {
                    color2 = ((FlatTableHeaderUI)object).bottomSeparatorColor;
                }
            }
        }
        float f = UIScale.scale(1.0f);
        object = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints((Graphics)object);
            ((Graphics)object).setColor(color);
            if (bl2) {
                ((Graphics2D)object).fill(new Rectangle2D.Float(n, n2, f, (float)n4 - f));
            }
            if (bl3) {
                ((Graphics2D)object).fill(new Rectangle2D.Float((float)(n + n3) - f, n2, f, (float)n4 - f));
            }
            ((Graphics)object).setColor(color2);
            ((Graphics2D)object).fill(new Rectangle2D.Float(n, (float)(n2 + n4) - f, n3, f));
        }
        finally {
            ((Graphics)object).dispose();
        }
    }

    protected boolean isDraggedColumn(JTableHeader jTableHeader, int n) {
        TableColumn tableColumn = jTableHeader.getDraggedColumn();
        if (tableColumn == null) {
            return false;
        }
        int n2 = jTableHeader.getDraggedDistance();
        if (n2 == 0) {
            return false;
        }
        int n3 = jTableHeader.getColumnModel().getColumnCount();
        for (int i = 0; i < n3; ++i) {
            if (jTableHeader.getHeaderRect((int)i).x + n2 != n) continue;
            return true;
        }
        return false;
    }

    protected boolean hideTrailingVerticalLine(JTableHeader jTableHeader) {
        Container container;
        Object object;
        if (jTableHeader.getUI() instanceof FlatTableHeaderUI) {
            object = (FlatTableHeaderUI)jTableHeader.getUI();
            if (((FlatTableHeaderUI)object).showTrailingVerticalLine != null) {
                return ((FlatTableHeaderUI)object).showTrailingVerticalLine == false;
            }
        }
        if (this.showTrailingVerticalLine) {
            return false;
        }
        object = jTableHeader.getParent();
        Container container2 = container = object != null ? ((Component)object).getParent() : null;
        if (!(container instanceof JScrollPane)) {
            return false;
        }
        JScrollPane jScrollPane = (JScrollPane)container;
        JViewport jViewport = jScrollPane.getColumnHeader();
        if (object != jViewport) {
            return false;
        }
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        if (jScrollBar == null || !jScrollBar.isVisible()) {
            return true;
        }
        return jScrollBar.getY() == ((Component)object).getY();
    }
}

