/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.util.MultiResolutionImageSupport;
import com.formdev.flatlaf.util.ScaledImageIcon;
import java.awt.Dimension;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;

public class FlatTitlePaneIcon
extends ScaledImageIcon {
    private final List<Image> images;

    public FlatTitlePaneIcon(List<Image> list, Dimension dimension) {
        super(null, dimension.width, dimension.height);
        this.images = list;
    }

    @Override
    protected Image getResolutionVariant(int n, int n2) {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        for (Image image3 : this.images) {
            if (MultiResolutionImageSupport.isMultiResolutionImage(image3)) {
                arrayList.add(MultiResolutionImageSupport.getResolutionVariant(image3, n, n2));
                continue;
            }
            arrayList.add(image3);
        }
        if (arrayList.size() == 1) {
            return (Image)arrayList.get(0);
        }
        arrayList.sort((image, image2) -> image.getWidth(null) - image2.getWidth(null));
        for (Image image3 : arrayList) {
            if (n > image3.getWidth(null) || n2 > image3.getHeight(null)) continue;
            return image3;
        }
        return (Image)arrayList.get(arrayList.size() - 1);
    }
}

