/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.HSLColor;
import java.awt.Color;

public class ColorFunctions {
    public static Color lighten(Color color, float f) {
        return ColorFunctions.hslIncreaseDecrease(color, f, 2, true);
    }

    public static Color darken(Color color, float f) {
        return ColorFunctions.hslIncreaseDecrease(color, f, 2, false);
    }

    public static Color saturate(Color color, float f) {
        return ColorFunctions.hslIncreaseDecrease(color, f, 1, true);
    }

    public static Color desaturate(Color color, float f) {
        return ColorFunctions.hslIncreaseDecrease(color, f, 1, false);
    }

    public static Color spin(Color color, float f) {
        return ColorFunctions.hslIncreaseDecrease(color, f, 0, true);
    }

    private static Color hslIncreaseDecrease(Color color, float f, int n, boolean bl) {
        float f2;
        float[] fArray = HSLColor.fromRGB(color);
        float f3 = (float)color.getAlpha() / 255.0f;
        float f4 = f2 = bl ? f : -f;
        if (n == 0) {
            fArray[0] = (fArray[0] + f2) % 360.0f;
        } else {
            fArray[n] = ColorFunctions.clamp(fArray[n] + f2 * 100.0f);
        }
        return HSLColor.toRGB(fArray[0], fArray[1], fArray[2], f3);
    }

    public static Color fade(Color color, float f) {
        int n = Math.round(255.0f * f);
        return new Color(color.getRGB() & 0xFFFFFF | n << 24, true);
    }

    public static Color mix(Color color, Color color2, float f) {
        if (f >= 1.0f) {
            return color;
        }
        if (f <= 0.0f) {
            return color2;
        }
        if (color.equals(color2)) {
            return color;
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        int n5 = color2.getRed();
        int n6 = color2.getGreen();
        int n7 = color2.getBlue();
        int n8 = color2.getAlpha();
        return new Color(Math.round((float)n5 + (float)(n - n5) * f), Math.round((float)n6 + (float)(n2 - n6) * f), Math.round((float)n7 + (float)(n3 - n7) * f), Math.round((float)n8 + (float)(n4 - n8) * f));
    }

    public static Color tint(Color color, float f) {
        return ColorFunctions.mix(Color.white, color, f);
    }

    public static Color shade(Color color, float f) {
        return ColorFunctions.mix(Color.black, color, f);
    }

    public static float luma(Color color) {
        float f = ColorFunctions.gammaCorrection((float)color.getRed() / 255.0f);
        float f2 = ColorFunctions.gammaCorrection((float)color.getGreen() / 255.0f);
        float f3 = ColorFunctions.gammaCorrection((float)color.getBlue() / 255.0f);
        return 0.2126f * f + 0.7152f * f2 + 0.0722f * f3;
    }

    private static float gammaCorrection(float f) {
        return f <= 0.03928f ? f / 12.92f : (float)Math.pow(((double)f + 0.055) / 1.055, 2.4);
    }

    public static Color applyFunctions(Color color, ColorFunction ... colorFunctionArray) {
        if (colorFunctionArray.length == 1 && colorFunctionArray[0] instanceof Mix) {
            Mix mix = (Mix)colorFunctionArray[0];
            return ColorFunctions.mix(color, mix.color2, mix.weight / 100.0f);
        }
        float[] fArray = HSLColor.fromRGB(color);
        float f = (float)color.getAlpha() / 255.0f;
        float[] fArray2 = new float[]{fArray[0], fArray[1], fArray[2], f * 100.0f};
        for (ColorFunction colorFunction : colorFunctionArray) {
            colorFunction.apply(fArray2);
        }
        return HSLColor.toRGB(fArray2[0], fArray2[1], fArray2[2], fArray2[3] / 100.0f);
    }

    public static float clamp(float f) {
        return f < 0.0f ? 0.0f : (f > 100.0f ? 100.0f : f);
    }

    public static class Mix
    implements ColorFunction {
        public final Color color2;
        public final float weight;

        public Mix(Color color, float f) {
            this.color2 = color;
            this.weight = f;
        }

        @Override
        public void apply(float[] fArray) {
            Color color = HSLColor.toRGB(fArray[0], fArray[1], fArray[2], fArray[3] / 100.0f);
            Color color2 = ColorFunctions.mix(color, this.color2, this.weight / 100.0f);
            float[] fArray2 = HSLColor.fromRGB(color2);
            System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
            fArray[3] = (float)color2.getAlpha() / 255.0f * 100.0f;
        }

        public String toString() {
            return String.format("mix(#%08x,%.0f%%)", this.color2.getRGB(), Float.valueOf(this.weight));
        }
    }

    public static class Fade
    implements ColorFunction {
        public final float amount;

        public Fade(float f) {
            this.amount = f;
        }

        @Override
        public void apply(float[] fArray) {
            fArray[3] = ColorFunctions.clamp(this.amount);
        }

        public String toString() {
            return String.format("fade(%.0f%%)", Float.valueOf(this.amount));
        }
    }

    public static class HSLChange
    implements ColorFunction {
        public final int hslIndex;
        public final float value;

        public HSLChange(int n, float f) {
            this.hslIndex = n;
            this.value = f;
        }

        @Override
        public void apply(float[] fArray) {
            fArray[this.hslIndex] = this.hslIndex == 0 ? this.value % 360.0f : ColorFunctions.clamp(this.value);
        }

        public String toString() {
            String string;
            switch (this.hslIndex) {
                case 0: {
                    string = "changeHue";
                    break;
                }
                case 1: {
                    string = "changeSaturation";
                    break;
                }
                case 2: {
                    string = "changeLightness";
                    break;
                }
                case 3: {
                    string = "changeAlpha";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return String.format("%s(%.0f%s)", string, Float.valueOf(this.value), this.hslIndex == 0 ? "" : "%");
        }
    }

    public static class HSLIncreaseDecrease
    implements ColorFunction {
        public final int hslIndex;
        public final boolean increase;
        public final float amount;
        public final boolean relative;
        public final boolean autoInverse;

        public HSLIncreaseDecrease(int n, boolean bl, float f, boolean bl2, boolean bl3) {
            this.hslIndex = n;
            this.increase = bl;
            this.amount = f;
            this.relative = bl2;
            this.autoInverse = bl3;
        }

        @Override
        public void apply(float[] fArray) {
            float f;
            float f2 = f = this.increase ? this.amount : -this.amount;
            if (this.hslIndex == 0) {
                fArray[0] = (fArray[0] + f) % 360.0f;
                return;
            }
            f = this.autoInverse && this.shouldInverse(fArray) ? -f : f;
            fArray[this.hslIndex] = ColorFunctions.clamp(this.relative ? fArray[this.hslIndex] * ((100.0f + f) / 100.0f) : fArray[this.hslIndex] + f);
        }

        protected boolean shouldInverse(float[] fArray) {
            return this.increase ? fArray[this.hslIndex] > 65.0f : fArray[this.hslIndex] < 35.0f;
        }

        public String toString() {
            String string;
            switch (this.hslIndex) {
                case 0: {
                    string = "spin";
                    break;
                }
                case 1: {
                    string = this.increase ? "saturate" : "desaturate";
                    break;
                }
                case 2: {
                    string = this.increase ? "lighten" : "darken";
                    break;
                }
                case 3: {
                    string = this.increase ? "fadein" : "fadeout";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return String.format("%s(%.0f%%%s%s)", string, Float.valueOf(this.amount), this.relative ? " relative" : "", this.autoInverse ? " autoInverse" : "");
        }
    }

    public static interface ColorFunction {
        public void apply(float[] var1);
    }
}

