/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class NativeLibrary {
    private static final String DELETE_SUFFIX = ".delete";
    private static boolean deletedTemporary;
    private final boolean loaded;

    public NativeLibrary(String string, ClassLoader classLoader, boolean bl) {
        this.loaded = bl ? NativeLibrary.loadLibraryFromJar(string, classLoader) : false;
    }

    public NativeLibrary(File file, boolean bl) {
        this.loaded = bl ? this.loadLibraryFromFile(file) : false;
    }

    public NativeLibrary(String string, boolean bl) {
        this.loaded = bl ? this.loadLibraryFromSystem(string) : false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private static boolean loadLibraryFromJar(String string, ClassLoader classLoader) {
        URL uRL;
        string = NativeLibrary.decorateLibraryName(string);
        URL uRL2 = uRL = classLoader != null ? classLoader.getResource(string) : NativeLibrary.class.getResource("/" + string);
        if (uRL == null) {
            LoggingFacade.INSTANCE.logSevere("Library '" + string + "' not found", null);
            return false;
        }
        File file = null;
        try {
            Object object;
            Object object2;
            if ("file".equals(uRL.getProtocol())) {
                object2 = uRL.getPath();
                object = ((String)object2).replace("flatlaf-core/bin/main/", "flatlaf-core/src/main/resources/");
                File file2 = new File((String)object);
                if (!file2.isFile()) {
                    file2 = new File((String)object2);
                }
                if (file2.isFile()) {
                    System.load(file2.getCanonicalPath());
                    return true;
                }
            }
            object2 = NativeLibrary.createTempFile(string);
            file = object2.toFile();
            object = uRL.openStream();
            try {
                Files.copy((InputStream)object, (Path)object2, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            System.load(file.getCanonicalPath());
            NativeLibrary.deleteOrMarkForDeletion(file);
            return true;
        }
        catch (Throwable throwable) {
            LoggingFacade.INSTANCE.logSevere(throwable.getMessage(), throwable);
            if (file != null) {
                NativeLibrary.deleteOrMarkForDeletion(file);
            }
            return false;
        }
    }

    private boolean loadLibraryFromFile(File file) {
        try {
            System.load(file.getAbsolutePath());
            return true;
        }
        catch (Throwable throwable) {
            LoggingFacade.INSTANCE.logSevere(throwable.getMessage(), throwable);
            return false;
        }
    }

    private boolean loadLibraryFromSystem(String string) {
        try {
            System.loadLibrary(string);
            return true;
        }
        catch (Throwable throwable) {
            String string2 = throwable.getMessage();
            if (throwable instanceof UnsatisfiedLinkError && string2 != null && string2.contains("java.library.path")) {
                return false;
            }
            LoggingFacade.INSTANCE.logSevere(string2, throwable);
            return false;
        }
    }

    private static String decorateLibraryName(String string) {
        int n = string.lastIndexOf(47);
        return n >= 0 ? string.substring(0, n + 1) + System.mapLibraryName(string.substring(n + 1)) : System.mapLibraryName(string);
    }

    private static Path createTempFile(String string) {
        int n = string.lastIndexOf(47);
        String string2 = n >= 0 ? string.substring(n + 1) : string;
        int n2 = string2.lastIndexOf(46);
        String string3 = (n2 >= 0 ? string2.substring(0, n2) : string2) + '-';
        String string4 = n2 >= 0 ? string2.substring(n2) : "";
        Path path = NativeLibrary.getTempDir();
        long l = System.nanoTime();
        int n3 = 0;
        while (true) {
            String string5 = string3 + Long.toUnsignedString(l) + n3 + string4;
            try {
                return Files.createFile(path.resolve(string5), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                ++n3;
                continue;
            }
            break;
        }
    }

    private static Path getTempDir() {
        String string = System.getProperty("java.io.tmpdir");
        if (SystemInfo.isWindows) {
            string = string + "\\flatlaf.temp";
        }
        Path path = Paths.get(string, new String[0]);
        Files.createDirectories(path, new FileAttribute[0]);
        if (SystemInfo.isWindows) {
            NativeLibrary.deleteTemporaryFiles(path);
        }
        return path;
    }

    private static void deleteTemporaryFiles(Path path) {
        if (deletedTemporary) {
            return;
        }
        deletedTemporary = true;
        File[] fileArray = path.toFile().listFiles((file, string) -> string.endsWith(DELETE_SUFFIX));
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            File file3 = new File(file2.getParent(), StringUtils.removeTrailing(file2.getName(), DELETE_SUFFIX));
            if (file3.exists() && !file3.delete()) continue;
            file2.delete();
        }
    }

    private static void deleteOrMarkForDeletion(File file) {
        if (file.delete()) {
            return;
        }
        try {
            File file2 = new File(file.getParent(), file.getName() + DELETE_SUFFIX);
            file2.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

