/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.HashesKt;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.RenderKt;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.NamedCurvesKt;
import io.ktor.network.tls.extensions.PointFormat;
import io.ktor.network.tls.extensions.PointFormatKt;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import io.ktor.network.tls.extensions.TLSExtensionType;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelOperationsKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.ByteReadPacketKt;
import io.ktor.utils.io.core.StringsKt;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.b.a;
import kotlinx.b.s;
import kotlinx.b.v;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u001c\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0080@\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a#\u0010\u000b\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001aE\u0010\u0017\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a!\u0010\u001c\u001a\u00020\u0003*\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a+\u0010\"\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020!H\u0000\u00a2\u0006\u0004\b\"\u0010#\u001a\u001f\u0010(\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010&\u001a\u00020%H\u0000\u00a2\u0006\u0004\b(\u0010)\u001a)\u0010+\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010&\u001a\u00020%2\b\b\u0002\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b+\u0010,\u001a\u001b\u0010.\u001a\u00020\u0003*\u00020\u00062\u0006\u0010-\u001a\u00020\u001fH\u0000\u00a2\u0006\u0004\b.\u0010/\u001a#\u00103\u001a\u00020\u0003*\u00020\u00062\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b3\u00104\u001a\u001f\u00107\u001a\u00020'2\u000e\b\u0002\u00106\u001a\b\u0012\u0004\u0012\u0002050\u000fH\u0002\u00a2\u0006\u0004\b7\u00108\u001a\u0017\u0010:\u001a\u00020'2\u0006\u00109\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b:\u0010;\u001a\u001f\u0010>\u001a\u00020'2\u000e\b\u0002\u0010=\u001a\b\u0012\u0004\u0012\u00020<0\u000fH\u0002\u00a2\u0006\u0004\b>\u00108\u001a\u001f\u0010A\u001a\u00020'2\u000e\b\u0002\u0010@\u001a\b\u0012\u0004\u0012\u00020?0\u000fH\u0002\u00a2\u0006\u0004\bA\u00108\u001a#\u0010C\u001a\u00020\u0003*\u00020\u00062\u0006\u0010B\u001a\u00020\u00122\u0006\u00102\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bC\u0010D\u001a\u001b\u0010F\u001a\u00020\u0003*\u00020\u00062\u0006\u0010E\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bF\u0010G\"\u0014\u0010H\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bH\u0010I\"\u0014\u0010J\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bJ\u0010I\u00a8\u0006K"}, d2={"Lio/ktor/utils/io/ByteWriteChannel;", "Lio/ktor/network/tls/TLSRecord;", "record", "", "writeRecord", "(Lio/ktor/utils/io/ByteWriteChannel;Lio/ktor/network/tls/TLSRecord;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlinx/io/Sink;", "Lio/ktor/network/tls/TLSHandshakeType;", "type", "", "length", "writeTLSHandshakeType", "(Lkotlinx/io/Sink;Lio/ktor/network/tls/TLSHandshakeType;I)V", "Lio/ktor/network/tls/TLSVersion;", "version", "", "Lio/ktor/network/tls/CipherSuite;", "suites", "", "random", "sessionId", "", "serverName", "writeTLSClientHello", "(Lkotlinx/io/Sink;Lio/ktor/network/tls/TLSVersion;Ljava/util/List;[B[BLjava/lang/String;)V", "", "Ljava/security/cert/X509Certificate;", "certificates", "writeTLSCertificates", "(Lkotlinx/io/Sink;[Ljava/security/cert/X509Certificate;)V", "preSecret", "Ljava/security/PublicKey;", "publicKey", "Ljava/security/SecureRandom;", "writeEncryptedPreMasterSecret", "(Lkotlinx/io/Sink;[BLjava/security/PublicKey;Ljava/security/SecureRandom;)V", "digest", "Ljavax/crypto/SecretKey;", "secretKey", "Lkotlinx/io/Source;", "finished", "([BLjavax/crypto/SecretKey;)Lkotlinx/io/Source;", "handshakeHash", "serverFinished", "([BLjavax/crypto/SecretKey;I)[B", "key", "writePublicKeyUncompressed", "(Lkotlinx/io/Sink;Ljava/security/PublicKey;)V", "Ljava/security/spec/ECPoint;", "point", "fieldSize", "writeECPoint", "(Lkotlinx/io/Sink;Ljava/security/spec/ECPoint;I)V", "Lio/ktor/network/tls/extensions/HashAndSign;", "algorithms", "buildSignatureAlgorithmsExtension", "(Ljava/util/List;)Lkotlinx/io/Source;", "name", "buildServerNameExtension", "(Ljava/lang/String;)Lkotlinx/io/Source;", "Lio/ktor/network/tls/extensions/NamedCurve;", "curves", "buildECCurvesExtension", "Lio/ktor/network/tls/extensions/PointFormat;", "formats", "buildECPointFormatExtension", "src", "writeAligned", "(Lkotlinx/io/Sink;[BI)V", "value", "writeTripleByteLength", "(Lkotlinx/io/Sink;I)V", "MAX_SERVER_NAME_LENGTH", "I", "MAX_CURVES_QUANTITY", "ktor-network-tls"})
public final class RenderKt {
    private static final int MAX_SERVER_NAME_LENGTH = 32762;
    private static final int MAX_CURVES_QUANTITY = 16382;

    /*
     * Unable to fully structure code
     */
    public static final Object writeRecord(ByteWriteChannel var0, TLSRecord var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof writeRecord.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var6_3 = new ContinuationImpl(var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                public final Object invokeSuspend(Object object) {
                    this.result = object;
                    this.label |= Integer.MIN_VALUE;
                    return RenderKt.writeRecord(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        var5_4 = var6_3.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var6_3.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var5_4);
                var3_6 = var1_1;
                var4_7 = false;
                var6_3.L$0 = var0;
                var6_3.L$1 = var3_6;
                var6_3.label = 1;
                v0 = ByteWriteChannelOperationsKt.writeByte((ByteWriteChannel)var0, (byte)((byte)var3_6.getType().getCode()), (Continuation)var6_3);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                var4_8 = false;
                var3_6 = (TLSRecord)var6_3.L$1;
                var0 = (ByteWriteChannel)var6_3.L$0;
                ResultKt.throwOnFailure((Object)var5_4);
                v0 = var5_4;
lbl27:
                // 2 sources

                var6_3.L$0 = var0;
                var6_3.L$1 = var3_6;
                var6_3.label = 2;
                v1 = ByteWriteChannelOperationsKt.writeByte((ByteWriteChannel)var0, (byte)((byte)(var3_6.getVersion().getCode() >> 8)), (Continuation)var6_3);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl40
            }
            case 2: {
                var4_9 = false;
                var3_6 = (TLSRecord)var6_3.L$1;
                var0 = (ByteWriteChannel)var6_3.L$0;
                ResultKt.throwOnFailure((Object)var5_4);
                v1 = var5_4;
lbl40:
                // 2 sources

                var6_3.L$0 = var0;
                var6_3.L$1 = var3_6;
                var6_3.label = 3;
                v2 = ByteWriteChannelOperationsKt.writeByte((ByteWriteChannel)var0, (byte)((byte)var3_6.getVersion().getCode()), (Continuation)var6_3);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl53
            }
            case 3: {
                var4_10 = false;
                var3_6 = (TLSRecord)var6_3.L$1;
                var0 = (ByteWriteChannel)var6_3.L$0;
                ResultKt.throwOnFailure((Object)var5_4);
                v2 = var5_4;
lbl53:
                // 2 sources

                var6_3.L$0 = var0;
                var6_3.L$1 = var3_6;
                var6_3.label = 4;
                v3 = ByteWriteChannelOperationsKt.writeShort((ByteWriteChannel)var0, (short)((short)ByteReadPacketKt.getRemaining((v)var3_6.getPacket())), (Continuation)var6_3);
                if (v3 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl66
            }
            case 4: {
                var4_11 = false;
                var3_6 = (TLSRecord)var6_3.L$1;
                var0 = (ByteWriteChannel)var6_3.L$0;
                ResultKt.throwOnFailure((Object)var5_4);
                v3 = var5_4;
lbl66:
                // 2 sources

                var6_3.L$0 = var0;
                var6_3.L$1 = null;
                var6_3.label = 5;
                v4 = ByteWriteChannelOperationsKt.writePacket((ByteWriteChannel)var0, (v)var3_6.getPacket(), (Continuation)var6_3);
                if (v4 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl78
            }
            case 5: {
                var4_12 = false;
                var0 = (ByteWriteChannel)var6_3.L$0;
                ResultKt.throwOnFailure((Object)var5_4);
                v4 = var5_4;
lbl78:
                // 2 sources

                var6_3.L$0 = null;
                var6_3.label = 6;
                v5 = var0.flush((Continuation)var6_3);
                if (v5 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl88
            }
            case 6: {
                var4_13 = false;
                ResultKt.throwOnFailure((Object)var5_4);
                v5 = var5_4;
lbl88:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final void writeTLSHandshakeType(s s2, TLSHandshakeType tLSHandshakeType, int n) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)tLSHandshakeType), (String)"");
        if (n > 0xFFFFFF) {
            throw new TLSException("TLS handshake size limit exceeded: " + n, null, 2, null);
        }
        int n2 = tLSHandshakeType.getCode() << 24 | n;
        s2.b(n2);
    }

    public static final void writeTLSClientHello(s s2, TLSVersion tLSVersion, List<CipherSuite> list, byte[] byArray, byte[] byArray2, String string) {
        int n;
        Intrinsics.checkNotNullParameter((Object)s2, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)tLSVersion), (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)byArray2, (String)"");
        s2.a((short)tLSVersion.getCode());
        BytePacketBuilderKt.writeFully$default((s)s2, (byte[])byArray, (int)0, (int)0, (int)6, null);
        int n2 = byArray2.length;
        if (n2 < 0 || n2 > 255 || n2 > byArray2.length) {
            throw new TLSException("Illegal sessionIdLength", null, 2, null);
        }
        s2.a((byte)n2);
        BytePacketBuilderKt.writeFully((s)s2, (byte[])byArray2, (int)0, (int)n2);
        s2.a((short)(list.size() * 2));
        for (CipherSuite iterator2 : list) {
            s2.a(iterator2.getCode());
        }
        s2.a((byte)1);
        s2.a((byte)0);
        ArrayList arrayList = new ArrayList();
        ((Collection)arrayList).add(RenderKt.buildSignatureAlgorithmsExtension$default(null, 1, null));
        ((Collection)arrayList).add(RenderKt.buildECCurvesExtension$default(null, 1, null));
        ((Collection)arrayList).add(RenderKt.buildECPointFormatExtension$default(null, 1, null));
        String string2 = string;
        if (string2 != null) {
            String v3 = string2;
            boolean bl = false;
            ((Collection)arrayList).add(RenderKt.buildServerNameExtension(v3));
        }
        Iterable iterable = arrayList;
        s s3 = s2;
        int n3 = 0;
        for (Object t : iterable) {
            v v2 = (v)t;
            n = n3;
            boolean bl = false;
            int n4 = (int)ByteReadPacketKt.getRemaining((v)v2);
            n3 = n + n4;
        }
        n = n3;
        s3.a((short)n);
        Iterator iterator = arrayList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"");
            v v3 = (v)e;
            BytePacketBuilderKt.writePacket((s)s2, (v)v3);
        }
    }

    public static /* synthetic */ void writeTLSClientHello$default(s s2, TLSVersion tLSVersion, List list, byte[] byArray, byte[] byArray2, String string, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        RenderKt.writeTLSClientHello(s2, tLSVersion, list, byArray, byArray2, string);
    }

    public static final void writeTLSCertificates(s s2, X509Certificate[] x509CertificateArray) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"");
        Intrinsics.checkNotNullParameter((Object)x509CertificateArray, (String)"");
        boolean bl = false;
        a a2 = new a();
        s s3 = (s)a2;
        boolean bl2 = false;
        for (X509Certificate x509Certificate : x509CertificateArray) {
            byte[] byArray;
            Intrinsics.checkNotNull((Object)x509Certificate.getEncoded());
            RenderKt.writeTripleByteLength(s3, byArray.length);
            BytePacketBuilderKt.writeFully$default((s)s3, (byte[])byArray, (int)0, (int)0, (int)6, null);
        }
        v v2 = (v)a2;
        RenderKt.writeTripleByteLength(s2, (int)ByteReadPacketKt.getRemaining((v)v2));
        BytePacketBuilderKt.writePacket((s)s2, (v)v2);
    }

    public static final void writeEncryptedPreMasterSecret(s s2, byte[] byArray, PublicKey publicKey, SecureRandom secureRandom) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"");
        Intrinsics.checkNotNullParameter((Object)secureRandom, (String)"");
        if (!(byArray.length == 48)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        Intrinsics.checkNotNull((Object)cipher);
        Cipher cipher2 = cipher;
        cipher2.init(1, (Key)publicKey, secureRandom);
        byte[] byArray2 = cipher2.doFinal(byArray);
        if (byArray2.length > 65535) {
            throw new TLSException("Encrypted premaster secret is too long", null, 2, null);
        }
        s2.a((short)byArray2.length);
        Intrinsics.checkNotNull((Object)byArray2);
        BytePacketBuilderKt.writeFully$default((s)s2, (byte[])byArray2, (int)0, (int)0, (int)6, null);
    }

    public static final v finished(byte[] byArray, SecretKey secretKey) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"");
        boolean bl = false;
        a a2 = new a();
        s s2 = (s)a2;
        boolean bl2 = false;
        byte[] byArray2 = HashesKt.PRF(secretKey, KeysKt.getCLIENT_FINISHED_LABEL(), byArray, 12);
        BytePacketBuilderKt.writeFully$default((s)s2, (byte[])byArray2, (int)0, (int)0, (int)6, null);
        return (v)a2;
    }

    public static final byte[] serverFinished(byte[] byArray, SecretKey secretKey, int n) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"");
        return HashesKt.PRF(secretKey, KeysKt.getSERVER_FINISHED_LABEL(), byArray, n);
    }

    public static /* synthetic */ byte[] serverFinished$default(byte[] byArray, SecretKey secretKey, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 12;
        }
        return RenderKt.serverFinished(byArray, secretKey, n);
    }

    public static final void writePublicKeyUncompressed(s s2, PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"");
        if (!(publicKey instanceof ECPublicKey)) {
            throw new TLSException("Unsupported public key type: " + publicKey, null, 2, null);
        }
        int n = ((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize();
        ECPoint eCPoint = ((ECPublicKey)publicKey).getW();
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"");
        RenderKt.writeECPoint(s2, eCPoint, n);
    }

    public static final void writeECPoint(s s2, ECPoint eCPoint, int n) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"");
        Intrinsics.checkNotNullParameter((Object)eCPoint, (String)"");
        boolean bl = false;
        a a2 = new a();
        s s3 = (s)a2;
        boolean bl2 = false;
        s3.a((byte)4);
        byte[] byArray = eCPoint.getAffineX().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
        RenderKt.writeAligned(s3, byArray, n);
        byte[] byArray2 = eCPoint.getAffineY().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"");
        RenderKt.writeAligned(s3, byArray2, n);
        v v2 = (v)a2;
        s2.a((byte)ByteReadPacketKt.getRemaining((v)v2));
        BytePacketBuilderKt.writePacket((s)s2, (v)v2);
    }

    private static final v buildSignatureAlgorithmsExtension(List<HashAndSign> list) {
        boolean bl = false;
        a a2 = new a();
        s s2 = (s)a2;
        boolean bl2 = false;
        s2.a(TLSExtensionType.SIGNATURE_ALGORITHMS.getCode());
        int n = list.size();
        s2.a((short)(2 + n * 2));
        s2.a((short)(n * 2));
        Iterable iterable = list;
        boolean bl3 = false;
        for (Object t : iterable) {
            HashAndSign hashAndSign = (HashAndSign)t;
            boolean bl4 = false;
            s2.a(hashAndSign.getHash().getCode());
            s2.a(hashAndSign.getSign().getCode());
        }
        return (v)a2;
    }

    static /* synthetic */ v buildSignatureAlgorithmsExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = SignatureAlgorithmKt.getSupportedSignatureAlgorithms();
        }
        return RenderKt.buildSignatureAlgorithmsExtension(list);
    }

    private static final v buildServerNameExtension(String string) {
        boolean bl = false;
        a a2 = new a();
        s s2 = (s)a2;
        boolean bl2 = false;
        if (!(string.length() < 32762)) {
            boolean bl3 = false;
            String string2 = "Server name length limit exceeded: at most 32762 characters allowed";
            throw new IllegalArgumentException(string2.toString());
        }
        s2.a(TLSExtensionType.SERVER_NAME.getCode());
        s2.a((short)(string.length() + 2 + 1 + 2));
        s2.a((short)(string.length() + 2 + 1));
        s2.a((byte)0);
        s2.a((short)string.length());
        StringsKt.writeText$default((s)s2, (CharSequence)string, (int)0, (int)0, null, (int)14, null);
        return (v)a2;
    }

    private static final v buildECCurvesExtension(List<? extends NamedCurve> list) {
        boolean bl = false;
        a a2 = new a();
        s s2 = (s)a2;
        boolean bl2 = false;
        if (!(list.size() <= 16382)) {
            boolean bl3 = false;
            String string = "Too many named curves provided: at most 16382 could be provided";
            throw new IllegalArgumentException(string.toString());
        }
        s2.a(TLSExtensionType.ELLIPTIC_CURVES.getCode());
        int n = list.size() * 2;
        s2.a((short)(2 + n));
        s2.a((short)n);
        Iterable iterable = list;
        boolean bl4 = false;
        for (Object t : iterable) {
            NamedCurve namedCurve = (NamedCurve)((Object)t);
            boolean bl5 = false;
            s2.a(namedCurve.getCode());
        }
        return (v)a2;
    }

    static /* synthetic */ v buildECCurvesExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = NamedCurvesKt.getSupportedNamedCurves();
        }
        return RenderKt.buildECCurvesExtension(list);
    }

    private static final v buildECPointFormatExtension(List<? extends PointFormat> list) {
        boolean bl = false;
        a a2 = new a();
        s s2 = (s)a2;
        boolean bl2 = false;
        s2.a(TLSExtensionType.EC_POINT_FORMAT.getCode());
        int n = list.size();
        s2.a((short)(1 + n));
        s2.a((byte)n);
        Iterable iterable = list;
        boolean bl3 = false;
        for (Object t : iterable) {
            PointFormat pointFormat = (PointFormat)((Object)t);
            boolean bl4 = false;
            s2.a(pointFormat.getCode());
        }
        return (v)a2;
    }

    static /* synthetic */ v buildECPointFormatExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = PointFormatKt.getSupportedPointFormats();
        }
        return RenderKt.buildECPointFormatExtension(list);
    }

    private static final void writeAligned(s s2, byte[] byArray, int n) {
        int n2;
        int n3;
        block2: {
            n3 = n + 7 >>> 3;
            byte[] byArray2 = byArray;
            boolean bl = false;
            int n4 = byArray2.length;
            for (int i = 0; i < n4; ++i) {
                byte by = byArray2[i];
                boolean bl2 = false;
                if (!(by != 0)) continue;
                n2 = i;
                break block2;
            }
            n2 = -1;
        }
        int n5 = n2;
        int n6 = n3 - (byArray.length - n5);
        if (n6 > 0) {
            BytePacketBuilderKt.writeFully$default((s)s2, (byte[])new byte[n6], (int)0, (int)0, (int)6, null);
        }
        BytePacketBuilderKt.writeFully((s)s2, (byte[])byArray, (int)n5, (int)(byArray.length - n5));
    }

    private static final void writeTripleByteLength(s s2, int n) {
        int n2 = n >>> 16 & 0xFF;
        int n3 = n & 0xFFFF;
        s2.a((byte)n2);
        s2.a((short)n3);
    }
}

