/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.tls.cipher.CipherKt;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a?\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a?\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lio/ktor/network/tls/CipherSuite;", "suite", "", "keyMaterial", "Lio/ktor/network/tls/TLSRecordType;", "recordType", "", "recordLength", "", "recordIv", "recordId", "Ljavax/crypto/Cipher;", "gcmEncryptCipher", "(Lio/ktor/network/tls/CipherSuite;[BLio/ktor/network/tls/TLSRecordType;IJJ)Ljavax/crypto/Cipher;", "gcmDecryptCipher", "ktor-network-tls"})
public final class GCMCipherKt {
    private static final Cipher gcmEncryptCipher(CipherSuite cipherSuite, byte[] byArray, TLSRecordType tLSRecordType, int n2, long l2, long l3) {
        byte[] byArray2;
        Cipher cipher = Cipher.getInstance(cipherSuite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher);
        Cipher cipher2 = cipher;
        SecretKeySpec secretKeySpec = KeysKt.clientKey(byArray, cipherSuite);
        byte[] byArray3 = KeysKt.clientIV(byArray, cipherSuite);
        byte[] byArray4 = Arrays.copyOf(byArray3, cipherSuite.getIvLength());
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"");
        byte[] byArray5 = byArray4;
        CipherKt.set(byArray5, cipherSuite.getFixedIvLength(), l2);
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(cipherSuite.getCipherTagSizeInBytes() * 8, byArray5);
        cipher2.init(1, (Key)secretKeySpec, gCMParameterSpec);
        byte[] byArray6 = byArray2 = new byte[13];
        boolean bl = false;
        CipherKt.set(byArray6, 0, l3);
        byArray6[8] = (byte)tLSRecordType.getCode();
        byArray6[9] = 3;
        byArray6[10] = 3;
        CipherKt.set(byArray6, 11, (short)n2);
        byte[] byArray7 = byArray2;
        cipher2.updateAAD(byArray7);
        return cipher2;
    }

    private static final Cipher gcmDecryptCipher(CipherSuite cipherSuite, byte[] byArray, TLSRecordType tLSRecordType, int n2, long l2, long l3) {
        byte[] byArray2;
        Cipher cipher = Cipher.getInstance(cipherSuite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher);
        Cipher cipher2 = cipher;
        SecretKeySpec secretKeySpec = KeysKt.serverKey(byArray, cipherSuite);
        byte[] byArray3 = KeysKt.serverIV(byArray, cipherSuite);
        byte[] byArray4 = Arrays.copyOf(byArray3, cipherSuite.getIvLength());
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"");
        byte[] byArray5 = byArray4;
        CipherKt.set(byArray5, cipherSuite.getFixedIvLength(), l2);
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(cipherSuite.getCipherTagSizeInBytes() * 8, byArray5);
        cipher2.init(2, (Key)secretKeySpec, gCMParameterSpec);
        int n3 = n2 - (cipherSuite.getIvLength() - cipherSuite.getFixedIvLength()) - cipherSuite.getCipherTagSizeInBytes();
        if (!(n3 < 65536)) {
            boolean bl = false;
            String string = "Content size should fit in 2 bytes, actual: " + n3;
            throw new IllegalStateException(string.toString());
        }
        byte[] byArray6 = byArray2 = new byte[13];
        boolean bl = false;
        CipherKt.set(byArray6, 0, l3);
        byArray6[8] = (byte)tLSRecordType.getCode();
        byArray6[9] = 3;
        byArray6[10] = 3;
        CipherKt.set(byArray6, 11, (short)n3);
        byte[] byArray7 = byArray2;
        cipher2.updateAAD(byArray7);
        return cipher2;
    }

    public static final /* synthetic */ Cipher access$gcmEncryptCipher(CipherSuite cipherSuite, byte[] byArray, TLSRecordType tLSRecordType, int n2, long l2, long l3) {
        return GCMCipherKt.gcmEncryptCipher(cipherSuite, byArray, tLSRecordType, n2, l2, l3);
    }

    public static final /* synthetic */ Cipher access$gcmDecryptCipher(CipherSuite cipherSuite, byte[] byArray, TLSRecordType tLSRecordType, int n2, long l2, long l3) {
        return GCMCipherKt.gcmDecryptCipher(cipherSuite, byArray, tLSRecordType, n2, l2, l3);
    }
}

