/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.internal.ObjectUtil;

public final class PreferHeapByteBufAllocator
implements ByteBufAllocator {
    private final ByteBufAllocator allocator;

    public PreferHeapByteBufAllocator(ByteBufAllocator byteBufAllocator) {
        this.allocator = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)byteBufAllocator, (String)"allocator");
    }

    public ByteBuf buffer() {
        return this.allocator.heapBuffer();
    }

    public ByteBuf buffer(int n) {
        return this.allocator.heapBuffer(n);
    }

    public ByteBuf buffer(int n, int n2) {
        return this.allocator.heapBuffer(n, n2);
    }

    public ByteBuf ioBuffer() {
        return this.allocator.heapBuffer();
    }

    public ByteBuf ioBuffer(int n) {
        return this.allocator.heapBuffer(n);
    }

    public ByteBuf ioBuffer(int n, int n2) {
        return this.allocator.heapBuffer(n, n2);
    }

    public ByteBuf heapBuffer() {
        return this.allocator.heapBuffer();
    }

    public ByteBuf heapBuffer(int n) {
        return this.allocator.heapBuffer(n);
    }

    public ByteBuf heapBuffer(int n, int n2) {
        return this.allocator.heapBuffer(n, n2);
    }

    public ByteBuf directBuffer() {
        return this.allocator.directBuffer();
    }

    public ByteBuf directBuffer(int n) {
        return this.allocator.directBuffer(n);
    }

    public ByteBuf directBuffer(int n, int n2) {
        return this.allocator.directBuffer(n, n2);
    }

    public CompositeByteBuf compositeBuffer() {
        return this.allocator.compositeHeapBuffer();
    }

    public CompositeByteBuf compositeBuffer(int n) {
        return this.allocator.compositeHeapBuffer(n);
    }

    public CompositeByteBuf compositeHeapBuffer() {
        return this.allocator.compositeHeapBuffer();
    }

    public CompositeByteBuf compositeHeapBuffer(int n) {
        return this.allocator.compositeHeapBuffer(n);
    }

    public CompositeByteBuf compositeDirectBuffer() {
        return this.allocator.compositeDirectBuffer();
    }

    public CompositeByteBuf compositeDirectBuffer(int n) {
        return this.allocator.compositeDirectBuffer(n);
    }

    public boolean isDirectBufferPooled() {
        return this.allocator.isDirectBufferPooled();
    }

    public int calculateNewCapacity(int n, int n2) {
        return this.allocator.calculateNewCapacity(n, n2);
    }
}

