/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.AnchoredGroupPath;
import androidx.compose.runtime.DataIterator;
import androidx.compose.runtime.GroupIterator;
import androidx.compose.runtime.GroupSourceInformation;
import androidx.compose.runtime.SlotReader;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableKt;
import androidx.compose.runtime.SourceInformationGroupDataIterator;
import androidx.compose.runtime.SourceInformationGroupIterator;
import androidx.compose.runtime.SourceInformationSlotTableGroupIdentity;
import androidx.compose.runtime.tooling.CompositionGroup;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010$H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010,\u001a\u00020\u0013H\u0016J\u0013\u0010-\u001a\u00020\u00102\b\u0010.\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010/\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u001c\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0014\u0010%\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\rR\u0014\u0010'\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\r\u00a8\u00060"}, d2={"Landroidx/compose/runtime/SlotTableGroup;", "Landroidx/compose/runtime/tooling/CompositionGroup;", "", "table", "Landroidx/compose/runtime/SlotTable;", "group", "", "version", "<init>", "(Landroidx/compose/runtime/SlotTable;II)V", "getTable", "()Landroidx/compose/runtime/SlotTable;", "getGroup", "()I", "getVersion", "isEmpty", "", "()Z", "key", "", "getKey", "()Ljava/lang/Object;", "sourceInfo", "", "getSourceInfo", "()Ljava/lang/String;", "node", "getNode", "data", "getData", "()Ljava/lang/Iterable;", "identity", "getIdentity", "compositionGroups", "getCompositionGroups", "iterator", "", "groupSize", "getGroupSize", "slotsSize", "getSlotsSize", "validateRead", "", "find", "identityToFind", "equals", "other", "hashCode", "runtime"})
final class SlotTableGroup
implements CompositionGroup,
Iterable<CompositionGroup>,
KMappedMarker {
    private final SlotTable table;
    private final int group;
    private final int version;

    public SlotTableGroup(SlotTable slotTable, int n2, int n3) {
        this.table = slotTable;
        this.group = n2;
        this.version = n3;
    }

    public /* synthetic */ SlotTableGroup(SlotTable slotTable, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n3 = slotTable.getVersion$runtime();
        }
        this(slotTable, n2, n3);
    }

    public final SlotTable getTable() {
        return this.table;
    }

    public final int getGroup() {
        return this.group;
    }

    public final int getVersion() {
        return this.version;
    }

    @Override
    public boolean isEmpty() {
        return SlotTableKt.access$groupSize(this.table.getGroups(), this.group) == 0;
    }

    @Override
    public Object getKey() {
        Object object;
        int[] nArray = this.table.getGroups();
        int n2 = this.group;
        boolean bl = false;
        if ((nArray[n2 * 5 + 1] & 0x20000000) != 0) {
            Object object2 = this.table.getSlots()[SlotTableKt.access$objectKeyIndex(this.table.getGroups(), this.group)];
            object = object2;
            Intrinsics.checkNotNull((Object)object2);
        } else {
            nArray = this.table.getGroups();
            n2 = this.group;
            bl = false;
            object = nArray[n2 * 5];
        }
        return object;
    }

    @Override
    public String getSourceInfo() {
        GroupSourceInformation groupSourceInformation = this.table.sourceInformationOf(this.group);
        return groupSourceInformation != null ? groupSourceInformation.getSourceInformation() : null;
    }

    @Override
    public Object getNode() {
        Object object;
        int[] nArray = this.table.getGroups();
        int n2 = this.group;
        boolean bl = false;
        if ((nArray[n2 * 5 + 1] & 0x40000000) != 0) {
            nArray = this.table.getGroups();
            n2 = this.group;
            bl = false;
            object = this.table.getSlots()[nArray[n2 * 5 + 4]];
        } else {
            object = null;
        }
        return object;
    }

    @Override
    public Iterable<Object> getData() {
        Iterable iterable;
        GroupSourceInformation groupSourceInformation = this.table.sourceInformationOf(this.group);
        if (groupSourceInformation != null) {
            GroupSourceInformation groupSourceInformation2 = groupSourceInformation;
            boolean bl = false;
            iterable = new SourceInformationGroupDataIterator(this.table, this.group, groupSourceInformation2);
        } else {
            iterable = new DataIterator(this.table, this.group);
        }
        return iterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getIdentity() {
        Anchor anchor;
        this.validateRead();
        SlotTable slotTable = this.table;
        boolean bl = false;
        boolean bl2 = false;
        try (SlotReader slotReader = slotTable.openReader();){
            SlotReader slotReader2 = slotReader;
            boolean bl3 = false;
            anchor = slotReader2.anchor(this.group);
        }
        return anchor;
    }

    @Override
    public Iterable<CompositionGroup> getCompositionGroups() {
        return this;
    }

    @Override
    public Iterator<CompositionGroup> iterator() {
        Iterator iterator2;
        this.validateRead();
        GroupSourceInformation groupSourceInformation = this.table.sourceInformationOf(this.group);
        if (groupSourceInformation != null) {
            GroupSourceInformation groupSourceInformation2 = groupSourceInformation;
            boolean bl = false;
            iterator2 = new SourceInformationGroupIterator(this.table, this.group, groupSourceInformation2, new AnchoredGroupPath(this.group));
        } else {
            iterator2 = new GroupIterator(this.table, this.group + 1, this.group + SlotTableKt.access$groupSize(this.table.getGroups(), this.group));
        }
        return iterator2;
    }

    @Override
    public int getGroupSize() {
        return SlotTableKt.access$groupSize(this.table.getGroups(), this.group);
    }

    @Override
    public int getSlotsSize() {
        int n2;
        boolean bl;
        int n3;
        int[] nArray;
        int n4 = this.group + this.getGroupSize();
        if (n4 < this.table.getGroupsSize()) {
            nArray = this.table.getGroups();
            n3 = n4;
            bl = false;
            n2 = nArray[n3 * 5 + 4];
        } else {
            n2 = this.table.getSlotsSize();
        }
        int n5 = n2;
        nArray = this.table.getGroups();
        n3 = this.group;
        bl = false;
        return n5 - nArray[n3 * 5 + 4];
    }

    private final void validateRead() {
        if (this.table.getVersion$runtime() != this.version) {
            SlotTableKt.throwConcurrentModificationException();
        }
    }

    @Override
    public CompositionGroup find(Object object) {
        CompositionGroup compositionGroup;
        Object object2 = object;
        if (object2 instanceof Anchor) {
            compositionGroup = SlotTableGroup.find$findAnchoredGroup(this, (Anchor)object);
        } else if (object2 instanceof SourceInformationSlotTableGroupIdentity) {
            CompositionGroup compositionGroup2 = this.find(((SourceInformationSlotTableGroupIdentity)object).getParentIdentity());
            if (compositionGroup2 != null) {
                CompositionGroup compositionGroup3 = compositionGroup2;
                boolean bl = false;
                compositionGroup = SlotTableGroup.find$findRelativeGroup(compositionGroup3, ((SourceInformationSlotTableGroupIdentity)object).getIndex());
            } else {
                compositionGroup = null;
            }
        } else {
            compositionGroup = null;
        }
        return compositionGroup;
    }

    public boolean equals(Object object) {
        return object instanceof SlotTableGroup && ((SlotTableGroup)object).group == this.group && ((SlotTableGroup)object).version == this.version && Intrinsics.areEqual((Object)((SlotTableGroup)object).table, (Object)this.table);
    }

    public int hashCode() {
        return this.group + 31 * this.table.hashCode();
    }

    private static final CompositionGroup find$findAnchoredGroup(SlotTableGroup slotTableGroup, Anchor anchor) {
        int n2;
        if (slotTableGroup.table.ownsAnchor(anchor) && (n2 = slotTableGroup.table.anchorIndex(anchor)) >= slotTableGroup.group && n2 - slotTableGroup.group < SlotTableKt.access$groupSize(slotTableGroup.table.getGroups(), slotTableGroup.group)) {
            return new SlotTableGroup(slotTableGroup.table, n2, slotTableGroup.version);
        }
        return null;
    }

    private static final CompositionGroup find$findRelativeGroup(CompositionGroup compositionGroup, int n2) {
        return (CompositionGroup)CollectionsKt.firstOrNull((List)CollectionsKt.drop(compositionGroup.getCompositionGroups(), (int)n2));
    }
}

