/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.chat;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.e.a.e;
import org.e.a.g;
import org.e.a.i;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManagerListener;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FlexibleStanzaTypeFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;

@Deprecated
public final class ChatManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(ChatManager.class.getName());
    private static final Map<XMPPConnection, ChatManager> INSTANCES = new WeakHashMap<XMPPConnection, ChatManager>();
    private static boolean defaultIsNormalInclude = true;
    private static MatchMode defaultMatchMode = MatchMode.BARE_JID;
    private final StanzaFilter packetFilter = new OrFilter(new StanzaFilter[]{MessageTypeFilter.CHAT, new FlexibleStanzaTypeFilter<Message>(){

        protected boolean acceptSpecific(Message message) {
            return ChatManager.this.normalIncluded ? message.getType() == Message.Type.normal : false;
        }
    }});
    private boolean normalIncluded = defaultIsNormalInclude;
    private MatchMode matchMode = defaultMatchMode;
    private final Map<String, Chat> threadChats = new ConcurrentHashMap<String, Chat>();
    private final Map<i, Chat> jidChats = new ConcurrentHashMap<i, Chat>();
    private final Map<e, Chat> baseJidChats = new ConcurrentHashMap<e, Chat>();
    private final Set<ChatManagerListener> chatManagerListeners = new CopyOnWriteArraySet<ChatManagerListener>();
    private final Map<MessageListener, StanzaFilter> interceptors = new WeakHashMap<MessageListener, StanzaFilter>();

    public static synchronized ChatManager getInstanceFor(XMPPConnection xMPPConnection) {
        ChatManager chatManager = INSTANCES.get(xMPPConnection);
        if (chatManager == null) {
            chatManager = new ChatManager(xMPPConnection);
        }
        return chatManager;
    }

    private ChatManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        xMPPConnection.addSyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                Message message = (Message)stanza;
                Chat chat = message.getThread() == null ? ChatManager.this.getUserChat(message.getFrom()) : ChatManager.this.getThreadChat(message.getThread());
                if (chat == null) {
                    chat = ChatManager.this.createChat(message);
                }
                if (chat == null) {
                    return;
                }
                ChatManager.deliverMessage(chat, message);
            }
        }, this.packetFilter);
        INSTANCES.put(xMPPConnection, this);
    }

    public boolean isNormalIncluded() {
        return this.normalIncluded;
    }

    public void setNormalIncluded(boolean bl) {
        this.normalIncluded = bl;
    }

    public MatchMode getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(MatchMode matchMode) {
        this.matchMode = matchMode;
    }

    public Chat createChat(g g2) {
        return this.createChat(g2, null);
    }

    public Chat createChat(g g2, ChatMessageListener chatMessageListener) {
        return this.createChat(g2, null, chatMessageListener);
    }

    public Chat createChat(g g2, String string, ChatMessageListener chatMessageListener) {
        Chat chat;
        if (string == null) {
            string = ChatManager.nextID();
        }
        if ((chat = this.threadChats.get(string)) != null) {
            throw new IllegalArgumentException("ThreadID is already used");
        }
        chat = this.createChat(g2, string, true);
        chat.addMessageListener(chatMessageListener);
        return chat;
    }

    private Chat createChat(g g2, String string, boolean bl) {
        Chat chat = new Chat(this, g2, string);
        this.threadChats.put(string, chat);
        this.jidChats.put((i)g2, chat);
        this.baseJidChats.put(g2.b(), chat);
        for (ChatManagerListener chatManagerListener : this.chatManagerListeners) {
            chatManagerListener.chatCreated(chat, bl);
        }
        return chat;
    }

    void closeChat(Chat chat) {
        this.threadChats.remove(chat.getThreadID());
        g g2 = chat.getParticipant();
        this.jidChats.remove(g2);
        this.baseJidChats.remove(g2.b());
    }

    private Chat createChat(Message message) {
        i i2 = message.getFrom();
        if (i2 == null) {
            return null;
        }
        g g2 = i2.s();
        if (g2 == null) {
            LOGGER.warning("Message from JID without localpart: '" + message.toXML() + "'");
            return null;
        }
        String string = message.getThread();
        if (string == null) {
            string = ChatManager.nextID();
        }
        return this.createChat(g2, string, false);
    }

    private Chat getUserChat(i i2) {
        e e2;
        if (this.matchMode == MatchMode.NONE) {
            return null;
        }
        if (i2 == null) {
            return null;
        }
        Chat chat = this.jidChats.get(i2);
        if (chat == null && this.matchMode == MatchMode.BARE_JID && (e2 = i2.o()) != null) {
            chat = this.baseJidChats.get(e2);
        }
        return chat;
    }

    public Chat getThreadChat(String string) {
        return this.threadChats.get(string);
    }

    public void addChatListener(ChatManagerListener chatManagerListener) {
        this.chatManagerListeners.add(chatManagerListener);
    }

    public void removeChatListener(ChatManagerListener chatManagerListener) {
        this.chatManagerListeners.remove(chatManagerListener);
    }

    public Set<ChatManagerListener> getChatListeners() {
        return Collections.unmodifiableSet(this.chatManagerListeners);
    }

    private static void deliverMessage(Chat chat, Message message) {
        chat.deliver(message);
    }

    void sendMessage(Chat chat, Message message) {
        for (Map.Entry<MessageListener, StanzaFilter> entry : this.interceptors.entrySet()) {
            StanzaFilter stanzaFilter = entry.getValue();
            if (stanzaFilter == null || !stanzaFilter.accept((Stanza)message)) continue;
            entry.getKey().processMessage(message);
        }
        this.connection().sendStanza((Stanza)message);
    }

    StanzaCollector createStanzaCollector(Chat chat) {
        return this.connection().createStanzaCollector((StanzaFilter)new AndFilter(new StanzaFilter[]{new ThreadFilter(chat.getThreadID()), FromMatchesFilter.create((i)chat.getParticipant())}));
    }

    public void addOutgoingMessageInterceptor(MessageListener messageListener) {
        this.addOutgoingMessageInterceptor(messageListener, null);
    }

    public void addOutgoingMessageInterceptor(MessageListener messageListener, StanzaFilter stanzaFilter) {
        if (messageListener == null) {
            return;
        }
        this.interceptors.put(messageListener, stanzaFilter);
    }

    private static String nextID() {
        return StringUtils.secureUniqueRandomString();
    }

    public static void setDefaultMatchMode(MatchMode matchMode) {
        defaultMatchMode = matchMode;
    }

    public static void setDefaultIsNormalIncluded(boolean bl) {
        defaultIsNormalInclude = bl;
    }

    public static enum MatchMode {
        NONE,
        SUPPLIED_JID,
        BARE_JID;

    }
}

