/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.e.a.a;
import org.e.a.i;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.util.EqualsUtil;

public final class RosterEntry
extends Manager {
    private RosterPacket.Item item;
    private final Roster roster;

    RosterEntry(RosterPacket.Item item, Roster roster, XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.item = item;
        this.roster = roster;
    }

    @Deprecated
    public String getUser() {
        return this.getJid().toString();
    }

    public a getJid() {
        return this.item.getJid();
    }

    public String getName() {
        return this.item.getName();
    }

    public synchronized void setName(String string) {
        if (string != null && string.equals(this.getName())) {
            return;
        }
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.set);
        rosterPacket.addRosterItem(RosterEntry.toRosterItem(this, string));
        this.connection().createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
        this.item.setName(string);
    }

    void updateItem(RosterPacket.Item item) {
        assert (item != null);
        this.item = item;
    }

    public boolean isApproved() {
        return this.item.isApproved();
    }

    public List<RosterGroup> getGroups() {
        ArrayList<RosterGroup> arrayList = new ArrayList<RosterGroup>();
        for (RosterGroup rosterGroup : this.roster.getGroups()) {
            if (!rosterGroup.contains(this)) continue;
            arrayList.add(rosterGroup);
        }
        return arrayList;
    }

    public RosterPacket.ItemType getType() {
        return this.item.getItemType();
    }

    public boolean isSubscriptionPending() {
        return this.item.isSubscriptionPending();
    }

    public boolean canSeeMyPresence() {
        switch (this.getType()) {
            case from: 
            case both: {
                return true;
            }
        }
        return false;
    }

    public boolean canSeeHisPresence() {
        switch (this.getType()) {
            case both: 
            case to: {
                return true;
            }
        }
        return false;
    }

    public void cancelSubscription() {
        XMPPConnection xMPPConnection = this.connection();
        Presence presence = ((PresenceBuilder)xMPPConnection.getStanzaFactory().buildPresenceStanza().to((i)this.item.getJid())).ofType(Presence.Type.unsubscribed).build();
        xMPPConnection.sendStanza((Stanza)presence);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getName() != null) {
            stringBuilder.append(this.getName()).append(": ");
        }
        stringBuilder.append((CharSequence)this.getJid());
        List<RosterGroup> list = this.getGroups();
        if (!list.isEmpty()) {
            stringBuilder.append(" [");
            Iterator iterator = list.iterator();
            RosterGroup rosterGroup = (RosterGroup)((Object)iterator.next());
            stringBuilder.append(rosterGroup.getName());
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                rosterGroup = (RosterGroup)((Object)iterator.next());
                stringBuilder.append(rosterGroup.getName());
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.getJid().hashCode();
    }

    public boolean equals(Object object) {
        return EqualsUtil.equals((Object)((Object)this), (Object)object, (builder, rosterEntry) -> builder.append((Object)this.getJid(), (Object)rosterEntry.getJid()));
    }

    public boolean equalsDeep(Object object) {
        return EqualsUtil.equals((Object)((Object)this), (Object)object, (builder, rosterEntry) -> builder.append((Object)this.item, (Object)rosterEntry.item));
    }

    static RosterPacket.Item toRosterItem(RosterEntry rosterEntry) {
        return RosterEntry.toRosterItem(rosterEntry, rosterEntry.getName(), false);
    }

    static RosterPacket.Item toRosterItem(RosterEntry rosterEntry, String string) {
        return RosterEntry.toRosterItem(rosterEntry, string, false);
    }

    static RosterPacket.Item toRosterItem(RosterEntry rosterEntry, boolean bl) {
        return RosterEntry.toRosterItem(rosterEntry, rosterEntry.getName(), bl);
    }

    private static RosterPacket.Item toRosterItem(RosterEntry rosterEntry, String string, boolean bl) {
        RosterPacket.Item item = new RosterPacket.Item(rosterEntry.getJid(), string);
        item.setItemType(rosterEntry.getType());
        if (bl) {
            item.setSubscriptionPending(rosterEntry.isSubscriptionPending());
        }
        item.setApproved(rosterEntry.isApproved());
        for (RosterGroup rosterGroup : rosterEntry.getGroups()) {
            item.addGroupName(rosterGroup.getName());
        }
        return item;
    }
}

