/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.io.Closeable;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/exposed/sql/BasicBinaryColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "", "()V", "nonNullValueToString", "", "value", "readObject", "", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "exposed-core"})
public class BasicBinaryColumnType
extends ColumnType<byte[]> {
    public BasicBinaryColumnType() {
        super(false, 1, null);
    }

    @Override
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().binaryType();
    }

    @Override
    public Object readObject(ResultSet resultSet, int n) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
        return resultSet.getBytes(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] valueFromDB(Object object) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Object object3 = object;
        if (object3 instanceof Blob) {
            Closeable closeable = ((Blob)object).getBinaryStream();
            Throwable throwable = null;
            try {
                Object object4 = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)object4);
                object4 = ByteStreamsKt.readBytes((InputStream)object4);
                object2 = object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else if (object3 instanceof InputStream) {
            Closeable closeable = (Closeable)object;
            Throwable throwable = null;
            try {
                Object object5 = (InputStream)closeable;
                boolean bl = false;
                object5 = ByteStreamsKt.readBytes((InputStream)object5);
                object2 = object5;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else if (object3 instanceof byte[]) {
            object2 = (byte[])object;
        } else {
            throw new IllegalStateException(("Unexpected value " + object + " of type " + Reflection.getOrCreateKotlinClass(object.getClass()).getQualifiedName()).toString());
        }
        return object2;
    }

    @Override
    public String nonNullValueToString(byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        return new String(byArray, Charsets.UTF_8);
    }
}

