/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/exposed/sql/UUIDColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Ljava/util/UUID;", "()V", "nonNullValueToString", "", "value", "notNullValueToDB", "", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "Companion", "exposed-core"})
public final class UUIDColumnType
extends ColumnType<UUID> {
    public static final Companion Companion = new Companion(null);
    private static final Regex uuidRegexp = new Regex("[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}", RegexOption.IGNORE_CASE);

    public UUIDColumnType() {
        super(false, 1, null);
    }

    @Override
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().uuidType();
    }

    @Override
    public UUID valueFromDB(Object object) {
        CharSequence charSequence;
        UUID uUID;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (object instanceof UUID) {
            uUID = (UUID)object;
        } else if (object instanceof byte[]) {
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object);
            boolean bl = false;
            uUID = new UUID(byteBuffer.getLong(), byteBuffer.getLong());
        } else if (object instanceof String && uuidRegexp.matches(charSequence = (CharSequence)object)) {
            UUID uUID2 = UUID.fromString((String)object);
            uUID = uUID2;
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"");
        } else if (object instanceof String) {
            charSequence = (String)object;
            byte[] byArray = ((String)charSequence).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            boolean bl = false;
            uUID = new UUID(byteBuffer.getLong(), byteBuffer.getLong());
        } else {
            throw new IllegalStateException(("Unexpected value of type UUID: " + object + " of " + Reflection.getOrCreateKotlinClass(object.getClass()).getQualifiedName()).toString());
        }
        return uUID;
    }

    @Override
    public Object notNullValueToDB(UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"");
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().uuidToDB(uUID);
    }

    @Override
    public String nonNullValueToString(UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"");
        return "" + '\'' + uUID + '\'';
    }

    @Override
    public Object readObject(ResultSet resultSet, int n) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
        return DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect ? resultSet.getBytes(n) : (byte[])super.readObject(resultSet, n);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/UUIDColumnType$Companion;", "", "()V", "uuidRegexp", "Lkotlin/text/Regex;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

