/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.transactions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.exceptions.ExposedSQLException;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.TransactionApiKt;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a \u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001aT\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\n0\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u0014\u001a-\u0010\u0015\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\n0\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018\u001aH\u0010\u0002\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\n0\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u0019\u001a6\u0010\u0002\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\n0\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"closeStatementsAndConnection", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "handleSQLException", "cause", "Ljava/sql/SQLException;", "attempts", "", "inTopLevelTransaction", "T", "transactionIsolation", "readOnly", "", "db", "Lorg/jetbrains/exposed/sql/Database;", "outerTransaction", "statement", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(IZLorg/jetbrains/exposed/sql/Database;Lorg/jetbrains/exposed/sql/Transaction;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "keepAndRestoreTransactionRefAfterRun", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(IZLorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "exposed-core"})
public final class ThreadLocalTransactionManagerKt {
    public static final <T> T transaction(Database database, Function1<? super Transaction, ? extends T> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return ThreadLocalTransactionManagerKt.transaction(TransactionApiKt.getTransactionManager(database).getDefaultIsolationLevel(), TransactionApiKt.getTransactionManager(database).getDefaultReadOnly(), database, function1);
    }

    public static /* synthetic */ Object transaction$default(Database database, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(database, function1);
    }

    public static final <T> T transaction(int n, boolean bl, Database database, Function1<? super Transaction, ? extends T> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(database, (Function0)new Function0<T>(database, n, bl, function1){
            final /* synthetic */ Database $db;
            final /* synthetic */ int $transactionIsolation;
            final /* synthetic */ boolean $readOnly;
            final /* synthetic */ Function1<Transaction, T> $statement;
            {
                this.$db = database;
                this.$transactionIsolation = n;
                this.$readOnly = bl;
                this.$statement = function1;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T invoke() {
                Object object;
                block15: {
                    block16: {
                        Object object2;
                        Transaction transaction2;
                        block14: {
                            Object object3;
                            transaction2 = TransactionManager.Companion.currentOrNull();
                            if (transaction2 == null || this.$db != null && !Intrinsics.areEqual((Object)transaction2.getDb(), (Object)this.$db)) break block14;
                            TransactionManager transactionManager = TransactionApiKt.getTransactionManager(transaction2.getDb());
                            Transaction transaction3 = transactionManager.newTransaction(this.$transactionIsolation, this.$readOnly, transaction2);
                            try {
                                Object object4 = object3 = this.$statement.invoke((Object)transaction3);
                                boolean bl = false;
                                if (transaction2.getDb().getUseNestedTransactions()) {
                                    transaction3.commit();
                                }
                            }
                            finally {
                                TransactionManager.Companion.resetCurrent(transactionManager);
                            }
                            object = object3;
                            break block15;
                        }
                        Database database = this.$db;
                        TransactionManager transactionManager = database != null ? TransactionApiKt.getTransactionManager(database) : null;
                        object = transactionManager;
                        if (object == null || (object = object.currentOrNull()) == null) break block16;
                        Object object5 = object;
                        Function1<Transaction, T> function1 = this.$statement;
                        Database database2 = this.$db;
                        Object object6 = object5;
                        boolean bl = false;
                        Transaction transaction4 = transaction2;
                        TransactionManager transactionManager2 = TransactionApiKt.getTransactionManager(transaction4 != null ? transaction4.getDb() : null);
                        try {
                            TransactionManager.Companion.resetCurrent(transactionManager);
                            Object object7 = object2 = function1.invoke(object6);
                            boolean bl2 = false;
                            if (database2.getUseNestedTransactions()) {
                                ((Transaction)object6).commit();
                            }
                        }
                        finally {
                            TransactionManager.Companion.resetCurrent(transactionManager2);
                        }
                        Object object8 = object2;
                        object = object8;
                        if (object8 != null) break block15;
                    }
                    object = ThreadLocalTransactionManagerKt.inTopLevelTransaction(this.$transactionIsolation, this.$readOnly, this.$db, null, this.$statement);
                }
                return (T)object;
            }
        });
    }

    public static /* synthetic */ Object transaction$default(int n, boolean bl, Database database, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(n, bl, database, function1);
    }

    public static final <T> T inTopLevelTransaction(int n, boolean bl, Database database, Transaction transaction2, Function1<? super Transaction, ? extends T> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(database, (Function0)new Function0<T>(transaction2, database, n, bl, function1){
            final /* synthetic */ Transaction $outerTransaction;
            final /* synthetic */ Database $db;
            final /* synthetic */ int $transactionIsolation;
            final /* synthetic */ boolean $readOnly;
            final /* synthetic */ Function1<Transaction, T> $statement;
            {
                this.$outerTransaction = transaction2;
                this.$db = database;
                this.$transactionIsolation = n;
                this.$readOnly = bl;
                this.$statement = function1;
                super(0);
            }

            public final T invoke() {
                return (T)ThreadLocalTransactionManagerKt.access$inTopLevelTransaction$run(this.$outerTransaction, this.$db, this.$transactionIsolation, this.$readOnly, this.$statement);
            }
        });
    }

    public static /* synthetic */ Object inTopLevelTransaction$default(int n, boolean bl, Database database, Transaction transaction2, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            database = null;
        }
        if ((n2 & 8) != 0) {
            transaction2 = null;
        }
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction(n, bl, database, transaction2, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T keepAndRestoreTransactionRefAfterRun(Database database, Function0<? extends T> function0) {
        Object object;
        TransactionManager transactionManager = TransactionApiKt.getTransactionManager(database);
        Transaction transaction2 = transactionManager.currentOrNull();
        try {
            object = function0.invoke();
        }
        finally {
            transactionManager.bindTransactionToThread(transaction2);
        }
        return (T)object;
    }

    static /* synthetic */ Object keepAndRestoreTransactionRefAfterRun$default(Database database, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(database, function0);
    }

    public static final void handleSQLException(SQLException sQLException, Transaction transaction2, int n) {
        Intrinsics.checkNotNullParameter((Object)sQLException, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        ExposedSQLException exposedSQLException = sQLException instanceof ExposedSQLException ? (ExposedSQLException)sQLException : null;
        Object object = exposedSQLException;
        if (object == null || (object = ((ExposedSQLException)object).causedByQueries()) == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)";\n", null, null, (int)0, null, null, (int)62, null)) == null) {
            object = String.valueOf(transaction2.getCurrentStatement());
        }
        Object object2 = object;
        String string = "Transaction attempt #" + n + " failed: " + sQLException.getMessage() + ". Statement(s): " + (String)object2;
        Iterable<Throwable> iterable = exposedSQLException;
        if (iterable != null && (iterable = iterable.getContexts()) != null) {
            Iterable iterable2 = iterable;
            boolean bl = false;
            for (Object t : iterable2) {
                StatementContext statementContext = (StatementContext)t;
                boolean bl2 = false;
                Iterable iterable3 = transaction2.getInterceptors$exposed_core();
                boolean bl3 = false;
                Iterable iterable4 = iterable3;
                Collection collection2 = new ArrayList();
                boolean bl4 = false;
                Iterator iterator2 = iterable4.iterator();
                while (iterator2.hasNext()) {
                    Object t2 = iterator2.next();
                    if (!(t2 instanceof SqlLogger)) continue;
                    collection2.add(t2);
                }
                iterable3 = (List)collection2;
                bl3 = false;
                for (Collection collection2 : iterable3) {
                    SqlLogger sqlLogger = (SqlLogger)((Object)collection2);
                    boolean bl5 = false;
                    sqlLogger.log(statementContext, transaction2);
                }
            }
        }
        SQLLogKt.getExposedLogger().warn(string, (Throwable)sQLException);
        TransactionApiKt.rollbackLoggingException(transaction2, (Function1<? super Exception, Unit>)((Function1)handleSQLException.2.INSTANCE));
    }

    public static final void closeStatementsAndConnection(Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        PreparedStatementApi preparedStatementApi = transaction2.getCurrentStatement();
        try {
            PreparedStatementApi preparedStatementApi2 = preparedStatementApi;
            if (preparedStatementApi2 != null) {
                PreparedStatementApi preparedStatementApi3 = preparedStatementApi2;
                boolean bl = false;
                preparedStatementApi3.closeIfPossible();
                transaction2.setCurrentStatement(null);
            }
            transaction2.closeExecutedStatements();
        }
        catch (Exception exception) {
            SQLLogKt.getExposedLogger().warn("Statements close failed", (Throwable)exception);
        }
        TransactionInterface transactionInterface = transaction2;
        boolean bl = false;
        try {
            transactionInterface.close();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            boolean bl2 = false;
            SQLLogKt.getExposedLogger().warn("Transaction close failed: " + exception2.getMessage() + ". Statement: " + preparedStatementApi, (Throwable)exception2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T inTopLevelTransaction$run(Transaction transaction2, Database database, int n, boolean bl, Function1<? super Transaction, ? extends T> function1) {
        TransactionManager transactionManager;
        int n2 = 0;
        Transaction transaction3 = transaction2;
        TransactionManager transactionManager2 = transactionManager = TransactionApiKt.getTransactionManager(transaction3 != null ? transaction3.getDb() : null);
        boolean bl2 = false;
        TransactionManager transactionManager3 = transactionManager2.currentOrNull() != null ? transactionManager : null;
        long l = 0L;
        Long l2 = null;
        while (true) {
            boolean bl3;
            Object object;
            if (database != null) {
                boolean bl4 = false;
                object = TransactionApiKt.getTransactionManager(database);
                bl3 = false;
                TransactionManager.Companion.resetCurrent((TransactionManager)object);
            }
            Transaction transaction4 = TransactionApiKt.getTransactionManager(database).newTransaction(n, bl, transaction2);
            try {
                Schema schema = transaction4.getDb().getConfig().getDefaultSchema();
                if (schema != null) {
                    object = schema;
                    bl3 = false;
                    SchemaUtils.setSchema$default(SchemaUtils.INSTANCE, (Schema)object, false, 2, null);
                }
                Object object2 = function1.invoke((Object)transaction4);
                transaction4.commit();
                Object object3 = object2;
                return (T)object3;
            }
            catch (SQLException sQLException) {
                ThreadLocalTransactionManagerKt.handleSQLException(sQLException, transaction4, n2);
                if (++n2 >= transaction4.getMaxAttempts()) {
                    throw sQLException;
                }
                if (l2 == null) {
                    l2 = transaction4.getRetryInterval$exposed_core();
                    l = transaction4.getMinRetryDelay();
                }
                long l3 = transaction4.getMinRetryDelay() < transaction4.getMaxRetryDelay() ? ThreadLocalRandom.current().nextLong(l += l2 * (long)n2, l + l2) : (transaction4.getMinRetryDelay() == transaction4.getMaxRetryDelay() ? transaction4.getMinRetryDelay() : 0L);
                SQLLogKt.getExposedLogger().warn("Wait " + l3 + " milliseconds before retrying");
                try {
                    Thread.sleep(l3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            catch (Throwable throwable) {
                PreparedStatementApi preparedStatementApi = transaction4.getCurrentStatement();
                TransactionApiKt.rollbackLoggingException(transaction4, (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(preparedStatementApi){
                    final /* synthetic */ PreparedStatementApi $currentStatement;
                    {
                        this.$currentStatement = preparedStatementApi;
                        super(1);
                    }

                    public final void invoke(Exception exception) {
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"");
                        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + exception.getMessage() + ". Statement: " + this.$currentStatement, (Throwable)exception);
                    }
                }));
                throw throwable;
            }
            finally {
                TransactionManager.Companion.resetCurrent(transactionManager3);
                ThreadLocalTransactionManagerKt.closeStatementsAndConnection(transaction4);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ Object access$inTopLevelTransaction$run(Transaction transaction2, Database database, int n, boolean bl, Function1 function1) {
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction$run(transaction2, database, n, bl, function1);
    }
}

