/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.os.Platform;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public abstract class AbstractBuffer<B extends AbstractBuffer>
implements NativeBuffer<B> {
    public static final int POINTER_SIZE;
    protected final Buffer buffer;
    protected final int elementSize;
    protected final int capacity;
    protected int limit;
    protected int position;

    protected AbstractBuffer(Buffer buffer, int n, int n2) {
        this.buffer = buffer;
        this.elementSize = n;
        this.capacity = n2;
        this.limit = n2;
        this.position = 0;
    }

    @Override
    public final int elementSize() {
        return this.elementSize;
    }

    @Override
    public final int limit() {
        return this.limit;
    }

    @Override
    public final B limit(int n) {
        if (0 > n || n >= this.capacity) {
            throw new IllegalArgumentException("New limit " + n + " out of bounds [0 .. capacity " + this.capacity() + "].");
        }
        this.limit = n;
        return (B)this;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public final B position(int n) {
        if (0 > n || n > this.limit) {
            throw new IllegalArgumentException("New position " + n + " out of bounds [0 .. limit " + this.limit() + "].");
        }
        this.position = n;
        return (B)this;
    }

    @Override
    public final int remaining() {
        return this.limit - this.position;
    }

    @Override
    public final boolean hasRemaining() {
        return this.limit > this.position;
    }

    @Override
    public final B clear() {
        this.limit = this.capacity;
        this.position = 0;
        return (B)this;
    }

    @Override
    public final B flip() {
        this.limit = this.position;
        this.position = 0;
        return (B)this;
    }

    @Override
    public final B rewind() {
        this.position = 0;
        return (B)this;
    }

    @Override
    public final Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public final boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public long getDirectBufferAddress() {
        if (this.isDirect()) {
            return Buffers.getDirectBufferAddressImpl(this.buffer);
        }
        return 0L;
    }

    @Override
    public void storeDirectAddress(ByteBuffer byteBuffer) {
        long l = this.getDirectBufferAddress();
        switch (POINTER_SIZE) {
            case 4: {
                byteBuffer.putInt(0, (int)(l & 0xFFFFFFFFL));
                break;
            }
            case 8: {
                byteBuffer.putLong(0, l);
            }
        }
        byteBuffer.position(byteBuffer.position() + POINTER_SIZE);
    }

    @Override
    public void storeDirectAddress(ByteBuffer byteBuffer, int n) {
        long l = this.getDirectBufferAddress();
        switch (POINTER_SIZE) {
            case 4: {
                byteBuffer.putInt(n, (int)(l & 0xFFFFFFFFL));
                break;
            }
            case 8: {
                byteBuffer.putLong(n, l);
            }
        }
    }

    @Override
    public final boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public final int arrayOffset() {
        if (this.hasArray()) {
            return this.buffer.arrayOffset();
        }
        return 0;
    }

    @Override
    public Object array() {
        return this.buffer.array();
    }

    protected String toSubString() {
        return "[direct[" + this.isDirect() + ", addr 0x" + Long.toHexString(this.getDirectBufferAddress()) + "], hasArray " + this.hasArray() + ", capacity " + this.capacity + ", position " + this.position + ", elementSize " + this.elementSize + ", buffer[capacity " + this.buffer.capacity() + ", lim " + this.buffer.limit() + ", pos " + this.buffer.position() + "]]";
    }

    public String toString() {
        return "AbstractBuffer" + this.toSubString();
    }

    static {
        Platform.initSingleton();
        POINTER_SIZE = Platform.is32Bit() ? 4 : 8;
    }
}

