/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.jna.macos.structs;

import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class Termios
extends Structure {
    public static final long TCSANOW = 0L;
    public NativeLong inputFlags;
    public NativeLong outputFlags;
    public NativeLong controlFlags;
    public NativeLong localFlags;
    public byte[] controlChars = new byte[20];
    public NativeLong inputSpeed;
    public NativeLong outputSpeed;

    public static void and(NativeLong nativeLong, int n) {
        nativeLong.setValue(nativeLong.longValue() & (long)n);
    }

    public static void and(NativeLong nativeLong, long l) {
        nativeLong.setValue(nativeLong.longValue() & l);
    }

    public static void or(NativeLong nativeLong, long l) {
        nativeLong.setValue(nativeLong.longValue() | l);
    }

    public static void or(NativeLong nativeLong, int n) {
        nativeLong.setValue(nativeLong.longValue() | (long)n);
    }

    protected List<String> getFieldOrder() {
        return Arrays.asList("inputFlags", "outputFlags", "controlFlags", "localFlags", "controlChars", "inputSpeed", "outputSpeed");
    }

    public static class ControlChars {
        public static final int VEOF = 0;
        public static final int VEOL = 1;
        public static final int VEOL2 = 2;
        public static final int VERASE = 3;
        public static final int VWERASE = 4;
        public static final int VKILL = 5;
        public static final int VREPRINT = 6;
        public static final int VINTR = 8;
        public static final int VQUIT = 9;
        public static final int VSUSP = 10;
        public static final int VDSUSP = 11;
        public static final int VSTART = 12;
        public static final int VSTOP = 13;
        public static final int VLNEXT = 14;
        public static final int VDISCARD = 15;
        public static final int VMIN = 16;
        public static final int VTIME = 17;
    }

    public static class Local {
        public static final int ECHOKE = 1;
        public static final int ECHOE = 2;
        public static final int ECHOK = 4;
        public static final int ECHO = 8;
        public static final int ECHONL = 16;
        public static final int ECHOPRT = 32;
        public static final int ECHOCTL = 64;
        public static final int ISIG = 128;
        public static final int ICANON = 256;
        public static final int IEXTEN = 1024;
        public static final int EXTPROC = 2048;
        public static final int TOSTOP = 0x400000;
        public static final int FLUSHO = 0x800000;
        public static final int PENDIN = 0x20000000;
        public static final int NOFLSH = Integer.MIN_VALUE;
    }

    public static class Control {
        public static final int CSIZE = 48;
        public static final int CS5 = 0;
        public static final int CS6 = 256;
        public static final int CS7 = 512;
        public static final int CS8 = 768;
        public static final int CSTOPB = 1024;
        public static final int CREAD = 2048;
        public static final int PARENB = 4096;
        public static final int PARODD = 8192;
        public static final int HUPCL = 16384;
        public static final int CLOCAL = 32768;
    }

    public static class Output {
        public static final int OPOST = 1;
        public static final int ONLCR = 2;
        public static final int OCRNL = 16;
        public static final int ONOCR = 32;
        public static final int ONLRET = 64;
        public static final int OFILL = 128;
        public static final int OFDEL = 131072;
    }

    public static class Input {
        public static final int IGNBRK = 1;
        public static final int BRKINT = 2;
        public static final int IGNPAR = 4;
        public static final int PARMRK = 8;
        public static final int INPCK = 16;
        public static final int ISTRIP = 32;
        public static final int INLCR = 16;
        public static final int IGNCR = 128;
        public static final int ICRNL = 256;
        public static final int IXON = 512;
        public static final int IXOFF = 1024;
        public static final int IXANY = 2048;
        public static final int IMAXBEL = 8192;
        public static final int IUTF8 = 16384;
    }
}

