/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.Limits;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class IovArray
implements ChannelOutboundBuffer.MessageProcessor {
    private static final int ADDRESS_SIZE = Buffer.addressSize();
    public static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int MAX_CAPACITY = Limits.IOV_MAX * IOV_SIZE;
    private final long memoryAddress;
    private final ByteBuf memory;
    private int count;
    private long size;
    private long maxBytes = Limits.SSIZE_MAX;

    public IovArray() {
        this(Unpooled.wrappedBuffer((ByteBuffer)Buffer.allocateDirectWithNativeOrder(MAX_CAPACITY)).setIndex(0, 0));
    }

    public IovArray(ByteBuf byteBuf) {
        assert (byteBuf.writerIndex() == 0);
        assert (byteBuf.readerIndex() == 0);
        this.memory = PlatformDependent.hasUnsafe() ? byteBuf : byteBuf.order(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        this.memoryAddress = byteBuf.hasMemoryAddress() ? byteBuf.memoryAddress() : Buffer.memoryAddress(byteBuf.internalNioBuffer(0, byteBuf.capacity()));
    }

    public void clear() {
        this.count = 0;
        this.size = 0L;
    }

    @Deprecated
    public boolean add(ByteBuf byteBuf) {
        return this.add(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public boolean add(ByteBuf byteBuf, int n, int n2) {
        ByteBuffer[] byteBufferArray;
        if (this.count == Limits.IOV_MAX) {
            return false;
        }
        if (byteBuf.nioBufferCount() == 1) {
            if (n2 == 0) {
                return true;
            }
            if (byteBuf.hasMemoryAddress()) {
                return this.add(this.memoryAddress, byteBuf.memoryAddress() + (long)n, n2);
            }
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(n, n2);
            return this.add(this.memoryAddress, Buffer.memoryAddress(byteBuffer) + (long)byteBuffer.position(), n2);
        }
        for (ByteBuffer byteBuffer : byteBufferArray = byteBuf.nioBuffers(n, n2)) {
            int n3 = byteBuffer.remaining();
            if (n3 == 0 || this.add(this.memoryAddress, Buffer.memoryAddress(byteBuffer) + (long)byteBuffer.position(), n3) && this.count != Limits.IOV_MAX) continue;
            return false;
        }
        return true;
    }

    private boolean add(long l, long l2, int n) {
        assert (l2 != 0L);
        if (this.maxBytes - (long)n < this.size && this.count > 0 || this.memory.capacity() < (this.count + 1) * IOV_SIZE) {
            return false;
        }
        int n2 = IovArray.idx(this.count);
        int n3 = n2 + ADDRESS_SIZE;
        this.size += (long)n;
        ++this.count;
        if (ADDRESS_SIZE == 8) {
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putLong((long)((long)n2 + l), (long)l2);
                PlatformDependent.putLong((long)((long)n3 + l), (long)n);
            } else {
                this.memory.setLong(n2, l2);
                this.memory.setLong(n3, (long)n);
            }
        } else {
            assert (ADDRESS_SIZE == 4);
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putInt((long)((long)n2 + l), (int)((int)l2));
                PlatformDependent.putInt((long)((long)n3 + l), (int)n);
            } else {
                this.memory.setInt(n2, (int)l2);
                this.memory.setInt(n3, n);
            }
        }
        return true;
    }

    public int count() {
        return this.count;
    }

    public long size() {
        return this.size;
    }

    public void maxBytes(long l) {
        this.maxBytes = Math.min(Limits.SSIZE_MAX, ObjectUtil.checkPositive((long)l, (String)"maxBytes"));
    }

    public long maxBytes() {
        return this.maxBytes;
    }

    public long memoryAddress(int n) {
        return this.memoryAddress + (long)IovArray.idx(n);
    }

    public void release() {
        this.memory.release();
    }

    public boolean processMessage(Object object) {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            return this.add(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
        }
        return false;
    }

    private static int idx(int n) {
        return IOV_SIZE * n;
    }
}

