/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.os.OS;
import dorkbox.util.Sys;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.DirectoryIteratorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001mB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dJ\u0016\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0019J/\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00192\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010%J/\u0010!\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0019J\u0016\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0013J\u0016\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0019J\u0016\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0013J\u0016\u0010,\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0019J\u0016\u0010,\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0013J'\u0010-\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010.J'\u0010-\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u00132\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u00101J\u000e\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0019J\u0018\u00104\u001a\u0004\u0018\u00010\u00132\u0006\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u0013J\u0018\u00107\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0013J\u0018\u00107\u001a\u0004\u0018\u00010\u00132\u0006\u0010/\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0013J\u0018\u00109\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0013J\u0018\u00109\u001a\u0004\u0018\u00010\u00132\u0006\u0010/\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0013J\u0010\u0010:\u001a\u0004\u0018\u00010\u00132\u0006\u0010;\u001a\u00020\u0013J\u000e\u0010<\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010<\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0013J\u000e\u0010=\u001a\u00020\u00042\u0006\u0010*\u001a\u00020>J\u000e\u0010?\u001a\u00020\u00132\u0006\u0010@\u001a\u00020\u0019J\u000e\u0010?\u001a\u00020\u00132\u0006\u0010@\u001a\u00020\u0013J/\u0010A\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00192\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010%J/\u0010A\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010(J\u0016\u0010B\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0019J\u0016\u0010B\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0013J\u0016\u0010B\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0019J\u0016\u0010B\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0013J\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010D\u001a\u00020\u0019J-\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010D\u001a\u00020\u00192\u0012\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010FJ\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010D\u001a\u00020\u0013J'\u0010G\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010I\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010I\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010J\u001a\u00020KJ\u001c\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010L\u001a\u00020\u0004J\u001a\u0010I\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010M\u001a\u00060Nj\u0002`OJ$\u0010I\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010P\u001a\u00060Nj\u0002`O2\b\u0010Q\u001a\u0004\u0018\u00010\u0013J\u0010\u0010I\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0013J\u000e\u0010R\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010S\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010*\u001a\u00020UJ\u0014\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00130W2\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00130W2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010X\u001a\u00020\u0004J$\u0010V\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00130Z2\u0006\u0010X\u001a\u00020\u0004J\u0016\u0010[\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0019J\u000e\u0010]\u001a\u00020\u00132\u0006\u0010^\u001a\u00020\u0013J\u000e\u0010_\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0013J\u000e\u0010`\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010b\u001a\u00020cJ\u000e\u0010a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0013J \u0010d\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00192\u0006\u0010e\u001a\u00020\u00192\u0006\u0010f\u001a\u00020\u0004H\u0002J \u0010g\u001a\u00020\u00172\u0006\u0010h\u001a\u00020i2\u0006\u0010e\u001a\u00020\u00192\u0006\u0010f\u001a\u00020\u0004H\u0002J\u0016\u0010j\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00192\u0006\u0010e\u001a\u00020\u0019J\u0016\u0010j\u001a\u00020\u00172\u0006\u0010h\u001a\u00020i2\u0006\u0010e\u001a\u00020\u0019J\u0016\u0010j\u001a\u00020\u00172\u0006\u0010h\u001a\u00020i2\u0006\u0010e\u001a\u00020\u0013J\u0016\u0010j\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00132\u0006\u0010e\u001a\u00020\u0013J\u001e\u0010k\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00192\u0006\u0010e\u001a\u00020\u00192\u0006\u0010f\u001a\u00020\u0004J\u001e\u0010k\u001a\u00020\u00172\u0006\u0010h\u001a\u00020i2\u0006\u0010e\u001a\u00020\u00192\u0006\u0010f\u001a\u00020\u0004J\u001e\u0010k\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00132\u0006\u0010e\u001a\u00020\u00132\u0006\u0010f\u001a\u00020\u0004J'\u0010l\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\"\u00020\u0013\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010l\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006n"}, d2={"Ldorkbox/util/FileUtil;", "", "()V", "DEBUG", "", "OTHER_SEPARATOR", "", "SYSTEM_SEPARATOR", "UNIX_SEPARATOR", "WINDOWS_SEPARATOR", "ZIP_HEADER", "", "getZIP_HEADER", "()[B", "setZIP_HEADER", "([B)V", "log", "Lorg/slf4j/Logger;", "version", "", "getVersion", "()Ljava/lang/String;", "append", "", "file", "Ljava/io/File;", "text", "", "(Ljava/io/File;[Ljava/lang/String;)V", "", "concatFiles", "one", "two", "copyDirectory", "src_", "dest_", "namesToIgnore", "(Ljava/io/File;Ljava/io/File;[Ljava/lang/String;)V", "src", "dest", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "copyFile", "in", "out", "copyFileToDir", "delete", "(Ljava/io/File;[Ljava/lang/String;)Z", "fileName", "fileNamesToIgnore", "(Ljava/lang/String;[Ljava/lang/String;)Z", "deleteDirectory", "dir", "extractFromZip", "zipFile", "fileToExtract", "getChildRelativeToDir", "dirInHeirarchy", "getParentRelativeToDir", "getPid", "pidFileName", "isZipFile", "isZipStream", "Ljava/io/InputStream;", "mkdir", "location", "moveDirectory", "moveFile", "parseDir", "rootDirectory", "extensionsToMatch", "(Ljava/io/File;[Ljava/lang/String;)Ljava/util/List;", "prepend", "strings", "read", "action", "Ldorkbox/util/FileUtil$Action;", "includeEmptyLines", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "builder", "lineSeparator", "readAsString", "readFirstLine", "readLines", "Ljava/io/Reader;", "readOnePerLine", "Ljava/util/ArrayList;", "trimStrings", "list", "", "renameTo", "source", "tempDirectory", "directoryName", "tempFile", "toBytes", "touch", "timestamp", "", "unjarzip0", "outputDir", "extractManifest", "unjarzip1", "inputStream", "Ljava/util/zip/ZipInputStream;", "unzip", "unzipJar", "write", "Action", "Utilities"})
public final class FileUtil {
    public static final FileUtil INSTANCE = new FileUtil();
    private static final String version = Sys.INSTANCE.getVersion();
    private static final Logger log;
    private static final boolean DEBUG = false;
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR;
    private static final char OTHER_SEPARATOR;
    private static byte[] ZIP_HEADER;

    private FileUtil() {
    }

    public final String getVersion() {
        return version;
    }

    public final byte[] getZIP_HEADER() {
        return ZIP_HEADER;
    }

    public final void setZIP_HEADER(byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        ZIP_HEADER = byArray;
    }

    public final void prepend(File file, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : stringArray) {
            linkedList.add(string);
        }
        this.readOnePerLine(file, (List<String>)linkedList, false);
        this.write(file, (List<String>)linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void append(File file, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        try {
            Closeable closeable = new FileWriter(file, true);
            Throwable throwable = null;
            try {
                FileWriter fileWriter = (FileWriter)closeable;
                boolean bl = false;
                Closeable closeable2 = new BufferedWriter(fileWriter);
                Throwable throwable2 = null;
                try {
                    BufferedWriter bufferedWriter = (BufferedWriter)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = new PrintWriter(bufferedWriter);
                    Throwable throwable3 = null;
                    try {
                        PrintWriter printWriter = (PrintWriter)closeable3;
                        boolean bl3 = false;
                        for (String string : stringArray) {
                            printWriter.println(string);
                        }
                        printWriter = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    bufferedWriter = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                fileWriter = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            log.error("Error appending text", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(File file, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        try {
            Closeable closeable = new FileWriter(file, false);
            Throwable throwable = null;
            try {
                FileWriter fileWriter = (FileWriter)closeable;
                boolean bl = false;
                Closeable closeable2 = new BufferedWriter(fileWriter);
                Throwable throwable2 = null;
                try {
                    BufferedWriter bufferedWriter = (BufferedWriter)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = new PrintWriter(bufferedWriter);
                    Throwable throwable3 = null;
                    try {
                        PrintWriter printWriter = (PrintWriter)closeable3;
                        boolean bl3 = false;
                        for (String string : stringArray) {
                            printWriter.println(string);
                        }
                        printWriter = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    bufferedWriter = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                fileWriter = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            log.error("Error appending text", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(File file, List<String> list) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        try {
            Closeable closeable = new FileWriter(file, false);
            Throwable throwable = null;
            try {
                FileWriter fileWriter = (FileWriter)closeable;
                boolean bl = false;
                Closeable closeable2 = new BufferedWriter(fileWriter);
                Throwable throwable2 = null;
                try {
                    BufferedWriter bufferedWriter = (BufferedWriter)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = new PrintWriter(bufferedWriter);
                    Throwable throwable3 = null;
                    try {
                        PrintWriter printWriter = (PrintWriter)closeable3;
                        boolean bl3 = false;
                        for (String string : list) {
                            printWriter.println(string);
                        }
                        printWriter = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    bufferedWriter = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                fileWriter = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            log.error("Error appending text", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void append(File file, List<String> list) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        try {
            Closeable closeable = new FileWriter(file, true);
            Throwable throwable = null;
            try {
                FileWriter fileWriter = (FileWriter)closeable;
                boolean bl = false;
                Closeable closeable2 = new BufferedWriter(fileWriter);
                Throwable throwable2 = null;
                try {
                    BufferedWriter bufferedWriter = (BufferedWriter)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = new PrintWriter(bufferedWriter);
                    Throwable throwable3 = null;
                    try {
                        PrintWriter printWriter = (PrintWriter)closeable3;
                        boolean bl3 = false;
                        for (String string : list) {
                            printWriter.println(string);
                        }
                        printWriter = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    bufferedWriter = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                fileWriter = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            log.error("Error appending text", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> read(File file, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        List list = new ArrayList();
        if (bl) {
            Object object = file;
            Object object2 = Charsets.UTF_8;
            object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                InputStreamReader inputStreamReader = (InputStreamReader)object;
                boolean bl2 = false;
                TextStreamsKt.forEachLine((Reader)inputStreamReader, (Function1)((Function1)new Function1<String, Unit>((List<String>)list){
                    final /* synthetic */ List<String> $lines;
                    {
                        this.$lines = list;
                        super(1);
                    }

                    public final void invoke(String string) {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"");
                        this.$lines.add(string);
                    }
                }));
                inputStreamReader = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        Object object = file;
        Object object3 = Charsets.UTF_8;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object3);
        object3 = null;
        try {
            InputStreamReader inputStreamReader = (InputStreamReader)object;
            boolean bl3 = false;
            TextStreamsKt.forEachLine((Reader)inputStreamReader, (Function1)((Function1)new Function1<String, Unit>((List<String>)list){
                final /* synthetic */ List<String> $lines;
                {
                    this.$lines = list;
                    super(1);
                }

                public final void invoke(String string) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"");
                    if (((CharSequence)string).length() > 0) {
                        this.$lines.add(string);
                    }
                }
            }));
            inputStreamReader = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object3);
        }
        return list;
    }

    public final String readAsString(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        return FilesKt.readText$default((File)file, null, (int)1, null);
    }

    public final String read(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.read(new File(string));
    }

    public final String read(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        String string = FilesKt.readText$default((File)file, null, (int)1, null);
        if (((CharSequence)string).length() == 0) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(File file, StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
        Closeable closeable = new FileReader(file);
        Throwable throwable = null;
        try {
            FileReader fileReader = (FileReader)closeable;
            boolean bl = false;
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = null;
            while (true) {
                String string2;
                String string3 = string2 = bufferedReader.readLine();
                boolean bl2 = false;
                string = string3;
                if (string2 == null) break;
                stringBuilder.append(string).append(OS.INSTANCE.getLINE_SEPARATOR());
            }
            fileReader = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean read(File file, StringBuilder stringBuilder, String string) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
        if (!file.canRead()) {
            return false;
        }
        try {
            Object object = file;
            Object object2 = Charsets.UTF_8;
            object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                InputStreamReader inputStreamReader = (InputStreamReader)object;
                boolean bl = false;
                TextStreamsKt.forEachLine((Reader)inputStreamReader, (Function1)((Function1)new Function1<String, Unit>(string, stringBuilder){
                    final /* synthetic */ String $lineSeparator;
                    final /* synthetic */ StringBuilder $builder;
                    {
                        this.$lineSeparator = string;
                        this.$builder = stringBuilder;
                        super(1);
                    }

                    public final void invoke(String string) {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"");
                        if (this.$lineSeparator != null) {
                            this.$builder.append(string).append(this.$lineSeparator);
                        } else {
                            this.$builder.append(string);
                        }
                    }
                }));
                inputStreamReader = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean read(File file, Action action) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)action, (String)"");
        if (!file.canRead()) {
            return false;
        }
        try {
            Object object = file;
            Object object2 = Charsets.UTF_8;
            object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                InputStreamReader inputStreamReader = (InputStreamReader)object;
                boolean bl = false;
                TextStreamsKt.forEachLine((Reader)inputStreamReader, (Function1)((Function1)new Function1<String, Unit>(action){
                    final /* synthetic */ Action $action;
                    {
                        this.$action = action;
                        super(1);
                    }

                    public final void invoke(String string) {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"");
                        this.$action.onLineRead(string);
                    }
                }));
                inputStreamReader = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (Exception exception) {
            return false;
        }
        action.finished();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String readFirstLine(File file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        if (!file.canRead()) {
            return "";
        }
        Object object2 = file;
        Object object3 = Charsets.UTF_8;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), (Charset)object3);
        object3 = null;
        try {
            Object object4 = (InputStreamReader)object2;
            boolean bl = false;
            Reader reader = (Reader)object4;
            int n = 8192;
            object4 = (String)SequencesKt.firstOrNull((Sequence)TextStreamsKt.lineSequence((BufferedReader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))));
            object = object4;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        Object object5 = object;
        if (object == null) {
            object5 = "";
        }
        return object5;
    }

    public final String getPid(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        StringBuilder stringBuilder = new StringBuilder();
        return this.read(new File(string), stringBuilder, null) ? stringBuilder.toString() : null;
    }

    public final List<String> readLines(File file) {
        FileReader fileReader;
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new ArrayList();
        }
        FileReader fileReader2 = fileReader;
        return this.readLines(fileReader2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> readLines(Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"");
        List list = new ArrayList();
        Closeable closeable = new BufferedReader(reader);
        Throwable throwable = null;
        try {
            BufferedReader bufferedReader = (BufferedReader)closeable;
            boolean bl = false;
            BufferedReader bufferedReader2 = new BufferedReader(reader);
            String string = null;
            try {
                while (true) {
                    String string2;
                    String string3 = string2 = bufferedReader2.readLine();
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)string3);
                    string = string3;
                    if (string2 != null) {
                        list.add(string);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
            }
            bufferedReader = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    public final ArrayList<String> readOnePerLine(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readOnePerLine(file, (List<String>)arrayList, true);
        return arrayList;
    }

    public final ArrayList<String> readOnePerLine(File file, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readOnePerLine(file, (List<String>)arrayList, bl);
        return arrayList;
    }

    public final void readOnePerLine(File file, List<String> list, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        if (bl) {
            this.read(file, new Action(list){
                private int lineNumber;
                final /* synthetic */ List<String> $list;
                {
                    this.$list = list;
                }

                public final int getLineNumber() {
                    return this.lineNumber;
                }

                public final void setLineNumber(int n) {
                    this.lineNumber = n;
                }

                public void onLineRead(String string) {
                    String string2;
                    Intrinsics.checkNotNullParameter((Object)string, (String)"");
                    if (((CharSequence)string).length() > 0 && !StringsKt.startsWith$default((String)string, (String)"#", (boolean)false, (int)2, null) && ((CharSequence)(string2 = ((Object)StringsKt.trim((CharSequence)string)).toString())).length() > 0) {
                        this.$list.add(string2);
                    }
                    int n = this.lineNumber;
                    this.lineNumber = n + 1;
                }

                public void finished() {
                }
            });
        } else {
            this.read(file, new Action(list){
                private int lineNumber;
                final /* synthetic */ List<String> $list;
                {
                    this.$list = list;
                }

                public final int getLineNumber() {
                    return this.lineNumber;
                }

                public final void setLineNumber(int n) {
                    this.lineNumber = n;
                }

                public void onLineRead(String string) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"");
                    this.$list.add(string);
                    int n = this.lineNumber;
                    this.lineNumber = n + 1;
                }

                public void finished() {
                }
            });
        }
    }

    public final boolean deleteDirectory(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        try {
            return FilesKt.deleteRecursively((File)file);
        }
        catch (IOException iOException) {
            log.error("Error deleting the contents of dir " + file, (Throwable)iOException);
        }
        catch (DirectoryIteratorException directoryIteratorException) {
            log.error("Error deleting the contents of dir " + file, (Throwable)directoryIteratorException);
        }
        return false;
    }

    public final boolean renameTo(File file, File file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        if (file.renameTo(file2)) {
            return true;
        }
        if (file2.exists()) {
            File file3 = new File(file2.getPath() + "_old");
            if (file3.exists() && !file3.delete()) {
            }
            if (file2.renameTo(file3) && file.renameTo(file2)) {
                if (file3.delete()) {
                }
                return true;
            }
        }
        try {
            FilesKt.copyTo$default((File)file, (File)file2, (boolean)false, (int)0, (int)6, null);
            if (!file.delete()) {
            }
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public final File copyFile(String string, File file) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        return this.copyFile(new File(string), file);
    }

    public final File copyFile(File file, String string) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.copyFile(file, new File(string));
    }

    public final File copyFile(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return this.copyFile(new File(string), new File(string2));
    }

    public final File copyFileToDir(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return this.copyFileToDir(new File(string), new File(string2));
    }

    public final File copyFileToDir(File file, File file2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        if (!file2.isDirectory()) {
            throw new IOException("Out file is not a directory! '" + file2.getAbsolutePath() + '\'');
        }
        return this.copyFile(file, new File(file2, file.getName()));
    }

    public final File copyFile(File file, File file2) {
        File file3;
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        String string = FilesKt.normalize((File)file).getAbsolutePath();
        String string2 = FilesKt.normalize((File)file2).getAbsolutePath();
        if (StringsKt.equals((String)string, (String)string2, (boolean)true)) {
            return file2;
        }
        File file4 = file3 = file2.getParentFile();
        boolean bl = file4 != null ? !file4.canWrite() : false;
        if (bl) {
            file3.mkdirs();
        }
        FilesKt.copyTo$default((File)file, (File)file2, (boolean)false, (int)0, (int)6, null);
        file2.setLastModified(file.lastModified());
        return file2;
    }

    public final File concatFiles(File file, File file2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        FilesKt.appendBytes((File)file, (byte[])FilesKt.readBytes((File)file2));
        file.setLastModified(System.currentTimeMillis());
        return file;
    }

    public final File moveFile(String string, File file) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        return this.moveFile(new File(string), file);
    }

    public final File moveFile(File file, String string) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.moveFile(file, new File(string));
    }

    public final File moveFile(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return this.moveFile(new File(string), new File(string2));
    }

    public final File moveFile(File file, File file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        if (file2.canRead()) {
            file2.delete();
        }
        if (!(bl = this.renameTo(file, file2))) {
            throw new IOException("Unable to move file: '" + file.getAbsolutePath() + "' -> '" + file2.getAbsolutePath() + '\'');
        }
        return file2;
    }

    public final void copyDirectory(String string, String string2, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        this.copyDirectory(new File(string), new File(string2), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final void copyDirectory(File file, File file2, String ... stringArray) {
        String[] stringArray2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        File file3 = FilesKt.normalize((File)file);
        File file4 = FilesKt.normalize((File)file2);
        if (file3 == null) {
            boolean bl = false;
            String string = "Source must be valid";
            throw new IllegalArgumentException(string.toString());
        }
        if (file4 == null) {
            boolean bl = false;
            String string = "Destination must be valid";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(stringArray.length == 0)) {
            stringArray2 = file3.getName();
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String string = stringArray[j];
                if (!Intrinsics.areEqual((Object)stringArray2, (Object)string)) continue;
                return;
            }
        }
        if (file3.isDirectory()) {
            if (!file4.exists()) {
                file4.mkdir();
            }
            if ((stringArray2 = file3.list()) != null) {
                for (String string : stringArray2) {
                    File file5 = new File(file3, string);
                    File file6 = new File(file4, string);
                    this.copyDirectory(file5, file6, Arrays.copyOf(stringArray, stringArray.length));
                }
            }
        } else {
            this.copyFile(file3, file4);
        }
    }

    public final void moveDirectory(String string, String string2, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        this.moveDirectory(new File(string), new File(string2), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final void moveDirectory(File file, File file2, String ... stringArray) {
        String[] stringArray2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        if (stringArray.length > 0) {
            stringArray2 = file.getName();
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String string = stringArray[j];
                if (!Intrinsics.areEqual((Object)stringArray2, (Object)string)) continue;
                return;
            }
        }
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            if ((stringArray2 = file.list()) != null) {
                for (String string : stringArray2) {
                    File file3 = new File(file, string);
                    File file4 = new File(file2, string);
                    this.moveDirectory(file3, file4, Arrays.copyOf(stringArray, stringArray.length));
                }
            }
        } else {
            this.moveFile(file, file2);
        }
    }

    public final boolean delete(String string, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return this.delete(new File(string), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final boolean delete(File file, String ... stringArray) {
        File[] fileArray;
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        if (!file.exists()) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            int n = fileArray.length;
            for (int j = 0; j < n; ++j) {
                boolean bl3 = true;
                File file2 = fileArray[j];
                String string = file2.getName();
                Intrinsics.checkNotNull((Object)file2);
                String string2 = FilesKt.normalize((File)file2).getAbsolutePath();
                if (file2.isDirectory()) {
                    int n2 = stringArray.length;
                    for (int k = 0; k < n2; ++k) {
                        String string3 = stringArray[k];
                        if (string3.charAt(0) == '/' && Intrinsics.areEqual((Object)string3, (Object)string)) {
                            bl2 = true;
                            bl3 = false;
                            break;
                        }
                        if (!Intrinsics.areEqual((Object)string3, (Object)string2)) continue;
                        bl2 = true;
                        bl3 = false;
                        break;
                    }
                    if (!bl3) continue;
                    this.delete(file2, Arrays.copyOf(stringArray, stringArray.length));
                    continue;
                }
                for (String string3 : stringArray) {
                    if (string3.charAt(0) != '/' && Intrinsics.areEqual((Object)string3, (Object)string)) {
                        bl2 = true;
                        bl3 = false;
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)string3, (Object)string2)) continue;
                    bl2 = true;
                    bl3 = false;
                    break;
                }
                if (!bl3) continue;
                bl |= file2.delete();
            }
        }
        if (bl2) {
            return false;
        }
        return bl |= file.delete();
    }

    public final byte[] toBytes(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        return FilesKt.readBytes((File)file);
    }

    public final String mkdir(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        File file2 = FilesKt.normalize((File)file).getAbsoluteFile();
        if (file.mkdirs()) {
        }
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final String mkdir(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.mkdir(new File(string));
    }

    public final File tempFile(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        File file = File.createTempFile(string, null);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"");
        File file2 = FilesKt.normalize((File)file).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"");
        return file2;
    }

    public final String tempDirectory(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        File file = File.createTempFile(string, null);
        if (!file.delete()) {
            throw new IOException("Unable to delete temp file: " + file);
        }
        if (!file.mkdir()) {
            throw new IOException("Unable to create temp directory: " + file);
        }
        Intrinsics.checkNotNull((Object)file);
        String string2 = FilesKt.normalize((File)file).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return string2;
    }

    public final boolean isZipStream(InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"");
        InputStream inputStream2 = inputStream;
        if (!inputStream2.markSupported()) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        boolean bl = true;
        try {
            inputStream2.mark(ZIP_HEADER.length);
            int n = ZIP_HEADER.length;
            for (int j = 0; j < n; ++j) {
                if (ZIP_HEADER[j] == (byte)inputStream2.read()) continue;
                bl = false;
                break;
            }
            inputStream2.reset();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public final boolean isZipFile(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.isZipFile(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final boolean isZipFile(File var1_1) {
        block14: {
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"");
            var2_2 = true;
            var3_3 = new byte[FileUtil.ZIP_HEADER.length];
            var4_4 = null;
            try {
                var4_4 = new RandomAccessFile(var1_1, "r");
                var4_4.readFully(var3_3);
                var6_10 = FileUtil.ZIP_HEADER.length;
                for (var5_5 = 0; var5_5 < var6_10; ++var5_5) {
                    if (var3_3[var5_5] == FileUtil.ZIP_HEADER[var5_5]) continue;
                    var2_2 = false;
                    break;
                }
                ** try [egrp 1[TRYBLOCK] [0 : 77->86)] { 
            }
            catch (Exception var5_7) {
                var2_2 = false;
                v0 = var5_7 instanceof FileNotFoundException != false ? (FileNotFoundException)var5_7 : null;
                if (v0 != null) {
                    v0.printStackTrace();
                }
                break block14;
            }
            finally {
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                    }
                    catch (IOException var5_8) {
                        var5_8.printStackTrace();
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                var4_4.close();
            }
lbl18:
            // 1 sources

            catch (IOException var5_6) {
                var5_6.printStackTrace();
            }
            {
            }
        }
        return var2_2;
    }

    public final void unzip(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        this.unzipJar(string, string2, true);
    }

    public final void unzip(File file, File file2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        this.unzipJar(file, file2, true);
    }

    public final void unzip(ZipInputStream zipInputStream, String string) {
        Intrinsics.checkNotNullParameter((Object)zipInputStream, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.unzip(zipInputStream, new File(string));
    }

    public final void unzip(ZipInputStream zipInputStream, File file) {
        Intrinsics.checkNotNullParameter((Object)zipInputStream, (String)"");
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        this.unzipJar(zipInputStream, file, true);
    }

    public final void unzipJar(String string, String string2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        this.unjarzip0(new File(string), new File(string2), bl);
    }

    public final void unzipJar(File file, File file2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        this.unjarzip0(file, file2, bl);
    }

    public final void unzipJar(ZipInputStream zipInputStream, File file, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)zipInputStream, (String)"");
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        this.unjarzip1(zipInputStream, file, bl);
    }

    private final void unjarzip0(File file, File file2, boolean bl) {
        long l = file.length();
        if (l > 0x7FFFFFFEL) {
            throw new RuntimeException("Source filesize is too large!");
        }
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        this.unjarzip1(zipInputStream, file2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unjarzip1(ZipInputStream zipInputStream, File file, boolean bl) {
        Closeable closeable = zipInputStream;
        Throwable throwable = null;
        try {
            ZipInputStream zipInputStream2;
            block13: {
                Throwable throwable2;
                Closeable closeable2;
                zipInputStream2 = (ZipInputStream)closeable;
                boolean bl2 = false;
                ZipEntry zipEntry = null;
                while (true) {
                    Object object;
                    Object object2 = object = zipInputStream.getNextEntry();
                    boolean bl3 = false;
                    zipEntry = object2;
                    if (object == null) break block13;
                    ZipEntry zipEntry2 = zipEntry;
                    Intrinsics.checkNotNull((Object)zipEntry2);
                    object = zipEntry2.getName();
                    if (!bl) {
                        Intrinsics.checkNotNull((Object)object);
                        if (StringsKt.startsWith$default((String)object, (String)"META-INF/", (boolean)false, (int)2, null)) continue;
                    }
                    object2 = new File(file, (String)object);
                    if (zipEntry.isDirectory()) {
                        String string = ((File)object2).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                        INSTANCE.mkdir(string);
                        continue;
                    }
                    String string = ((File)object2).getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    INSTANCE.mkdir(string);
                    closeable2 = new FileOutputStream((File)object2);
                    throwable2 = null;
                    try {
                        FileOutputStream fileOutputStream = (FileOutputStream)closeable2;
                        boolean bl4 = false;
                        long l = ByteStreamsKt.copyTo$default((InputStream)zipInputStream, (OutputStream)fileOutputStream, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            zipInputStream2 = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final List<File> parseDir(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return this.parseDir(new File(string));
    }

    public final List<File> parseDir(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        return this.parseDir(file);
    }

    public final List<File> parseDir(File file, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        List list = new LinkedList();
        LinkedList<File> linkedList = new LinkedList<File>();
        File file2 = FilesKt.normalize((File)file);
        if (!file2.exists()) {
            throw new IOException("Location does not exist: " + file2.getAbsolutePath());
        }
        if (file2.isDirectory()) {
            linkedList.add(file2);
            while (linkedList.peek() != null) {
                File file3;
                File file4 = file3 = (File)linkedList.poll();
                Intrinsics.checkNotNull((Object)file4);
                File[] fileArray = file4.listFiles();
                if (fileArray == null) continue;
                for (File file5 : fileArray) {
                    if (file5.isDirectory()) {
                        linkedList.add(file5);
                        continue;
                    }
                    if (stringArray.length == 0) {
                        Intrinsics.checkNotNull((Object)file5);
                        list.add(file5);
                        continue;
                    }
                    int n = stringArray.length;
                    for (int j = 0; j < n; ++j) {
                        String string = stringArray[j];
                        String string2 = file5.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                        if (!StringsKt.endsWith$default((String)string2, (String)string, (boolean)false, (int)2, null)) continue;
                        Intrinsics.checkNotNull((Object)file5);
                        list.add(file5);
                    }
                }
            }
        } else {
            throw new IOException("Cannot search directory children if the dir is a file name: " + file2.getAbsolutePath());
        }
        return list;
    }

    public final String getChildRelativeToDir(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        if (!(((CharSequence)string).length() == 0)) {
            boolean bl = false;
            String string3 = "fileName cannot be empty.";
            throw new IllegalArgumentException(string3.toString());
        }
        return this.getChildRelativeToDir(new File(string), string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String getChildRelativeToDir(File file, String string) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (!(((CharSequence)string).length() == 0)) {
            boolean bl = false;
            String string2 = "dirInHeirarchy cannot be empty.";
            throw new IllegalArgumentException(string2.toString());
        }
        CharSequence charSequence = string;
        Object object = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.separator, (String)"");
        object = StringsKt.split$default((CharSequence)charSequence, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        Object object2 = object;
        String[] stringArray = object2.toArray(new String[0]);
        int n = stringArray.length - 1;
        String string3 = file.getAbsolutePath();
        object2 = file;
        String string4 = null;
        if (n == 0) {
            while (object2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)((File)object2).getName(), (String)"");
                if (Intrinsics.areEqual((Object)string4, (Object)string)) {
                    String string5 = ((File)object2).getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
                    string4 = string5;
                    Intrinsics.checkNotNull((Object)string3);
                    String string6 = string3.substring(string4.length() + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
                    return string6;
                }
                object2 = ((File)object2).getParentFile();
            }
            return null;
        }
        boolean bl2 = false;
        while (object2 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)((File)object2).getName(), (String)"");
            if (bl2) {
                if (!Intrinsics.areEqual((Object)string4, (Object)stringArray[n])) return null;
                if (--n < 0) {
                    if (string3.length() == string.length()) {
                        return null;
                    }
                    Intrinsics.checkNotNull((Object)string3);
                    String string7 = string3.substring(string.length() + 1, string3.length());
                    String string8 = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"");
                    return string8;
                }
            } else if (Intrinsics.areEqual((Object)string4, (Object)stringArray[n])) {
                bl2 = true;
                --n;
            }
            object2 = ((File)object2).getParentFile();
        }
        return null;
    }

    public final String getParentRelativeToDir(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        if (!(((CharSequence)string).length() == 0)) {
            boolean bl = false;
            String string3 = "fileName cannot be empty.";
            throw new IllegalArgumentException(string3.toString());
        }
        return this.getParentRelativeToDir(new File(string), string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String getParentRelativeToDir(File file, String string) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (!(((CharSequence)string).length() == 0)) {
            boolean bl = false;
            String string2 = "dirInHeirarchy cannot be empty.";
            throw new IllegalArgumentException(string2.toString());
        }
        CharSequence charSequence = string;
        Object object = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.separator, (String)"");
        object = StringsKt.split$default((CharSequence)charSequence, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        Object object2 = object;
        String[] stringArray = object2.toArray(new String[0]);
        int n = stringArray.length - 1;
        File file2 = file;
        object2 = null;
        if (n == 0) {
            while (file2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)file2.getName(), (String)"");
                if (Intrinsics.areEqual((Object)object2, (Object)string)) {
                    file2 = file2.getParentFile();
                    String string3 = file2.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                    return string3;
                }
                file2 = file2.getParentFile();
            }
            return null;
        }
        boolean bl2 = false;
        while (file2 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)file2.getName(), (String)"");
            if (bl2) {
                if (!Intrinsics.areEqual((Object)object2, (Object)stringArray[n])) return null;
                if (--n < 0) {
                    file2 = file2.getParentFile();
                    String string4 = file2.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
                    return string4;
                }
            } else if (Intrinsics.areEqual((Object)object2, (Object)stringArray[n])) {
                bl2 = true;
                --n;
            }
            file2 = file2.getParentFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String extractFromZip(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Closeable closeable = new ZipInputStream(new FileInputStream(string));
        Throwable throwable = null;
        try {
            ZipInputStream zipInputStream;
            block12: {
                Object object;
                ZipEntry zipEntry;
                zipInputStream = (ZipInputStream)closeable;
                boolean bl = false;
                do {
                    object = zipInputStream.getNextEntry();
                    ZipEntry zipEntry2 = object;
                    if (zipEntry2 == null) break block12;
                    Intrinsics.checkNotNull((Object)zipEntry2);
                    zipEntry = object;
                    object = zipEntry.getName();
                } while (zipEntry.isDirectory() || !Intrinsics.areEqual((Object)object, (Object)string2));
                Intrinsics.checkNotNull((Object)object);
                File file = INSTANCE.tempFile((String)object);
                file.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                Closeable closeable2 = fileOutputStream;
                Throwable throwable2 = null;
                try {
                    FileOutputStream fileOutputStream2 = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)zipInputStream, (OutputStream)fileOutputStream2, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                String string3 = file.getAbsolutePath();
                return string3;
            }
            zipInputStream = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return null;
    }

    public final boolean touch(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        long l = System.currentTimeMillis();
        File file = new File(string).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"");
        return this.touch(file, l);
    }

    public final boolean touch(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        long l = System.currentTimeMillis();
        return this.touch(file, l);
    }

    public final boolean touch(File file, long l) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        if (!file.exists()) {
            boolean bl = file.getParentFile().mkdirs();
            if (!bl) {
                return false;
            }
            try {
                new FileOutputStream(file).close();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return file.setLastModified(l);
    }

    static {
        Logger logger = LoggerFactory.getLogger(FileUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        log = logger;
        SYSTEM_SEPARATOR = File.separatorChar;
        OTHER_SEPARATOR = (char)(OS.INSTANCE.isWindows() ? 47 : 92);
        byte[] byArray = new byte[]{80, 75, 3, 4};
        ZIP_HEADER = byArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Ldorkbox/util/FileUtil$Action;", "", "finished", "", "onLineRead", "line", "", "Utilities"})
    public static interface Action {
        public void onLineRead(String var1);

        public void finished();
    }
}

