/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.Sys;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0010\n\n\u0002\b\u0005\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\fH\u0016J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0016J\u0006\u0010$\u001a\u00020\u0004J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u000e\u0010'\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010'\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010(\u001a\u00020\n2\b\u0010)\u001a\u0004\u0018\u00010\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldorkbox/util/MersenneTwisterFast;", "", "()V", "seed", "", "(J)V", "array", "", "([I)V", "__haveNextNextGaussian", "", "__nextNextGaussian", "", "mag01", "mt", "mti", "", "clearGaussian", "", "nextBoolean", "probability", "", "nextByte", "", "nextBytes", "bytes", "", "nextChar", "", "nextDouble", "includeZero", "includeOne", "nextFloat", "nextGaussian", "nextInt", "n", "nextLong", "nextShort", "", "setSeed", "stateEquals", "other", "Companion", "Utilities"})
public class MersenneTwisterFast {
    public static final Companion Companion = new Companion(null);
    private int[] mt;
    private int mti;
    private int[] mag01;
    private double __nextNextGaussian;
    private boolean __haveNextNextGaussian;
    private static final String version = Sys.INSTANCE.getVersion();
    private static final long serialVersionUID = -8219700664442619525L;
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;

    public final boolean stateEquals(MersenneTwisterFast mersenneTwisterFast) {
        int n;
        if (mersenneTwisterFast == this) {
            return true;
        }
        if (mersenneTwisterFast == null) {
            return false;
        }
        if (this.mti != mersenneTwisterFast.mti) {
            return false;
        }
        Intrinsics.checkNotNull((Object)this.mag01);
        int n2 = this.mag01.length;
        for (n = 0; n < n2; ++n) {
            Intrinsics.checkNotNull((Object)this.mag01);
            int n3 = this.mag01[n];
            Intrinsics.checkNotNull((Object)mersenneTwisterFast.mag01);
            if (n3 == mersenneTwisterFast.mag01[n]) continue;
            return false;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n2 = this.mt.length;
        for (n = 0; n < n2; ++n) {
            Intrinsics.checkNotNull((Object)this.mt);
            int n4 = this.mt[n];
            Intrinsics.checkNotNull((Object)mersenneTwisterFast.mt);
            if (n4 == mersenneTwisterFast.mt[n]) continue;
            return false;
        }
        return true;
    }

    public MersenneTwisterFast() {
        this((long)(Math.random() * (double)Long.MAX_VALUE));
    }

    public MersenneTwisterFast(long l) {
        this.setSeed(l);
    }

    public MersenneTwisterFast(int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        this.setSeed(nArray);
    }

    public final void setSeed(long l) {
        int[] nArray;
        this.__haveNextNextGaussian = false;
        this.mt = new int[N];
        int[] nArray2 = nArray = new int[2];
        MersenneTwisterFast mersenneTwisterFast = this;
        boolean bl = false;
        nArray2[0] = 0;
        nArray2[1] = MATRIX_A;
        mersenneTwisterFast.mag01 = nArray;
        Intrinsics.checkNotNull((Object)this.mt);
        this.mt[0] = (int)(l & 0xFFFFFFFFFFFFFFFL);
        this.mti = 1;
        while (this.mti < N) {
            Intrinsics.checkNotNull((Object)this.mt);
            Intrinsics.checkNotNull((Object)this.mt);
            int n = this.mt[this.mti - 1];
            Intrinsics.checkNotNull((Object)this.mt);
            this.mt[this.mti] = 1812433253 * (n ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            int n2 = this.mti;
            this.mti = n2 + 1;
        }
    }

    public final void setSeed(int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Array length must be greater than zero");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.setSeed(19650218L);
        n = 1;
        n2 = 0;
        int n4 = n3 = N > nArray.length ? N : nArray.length;
        while (n3 != 0) {
            Intrinsics.checkNotNull((Object)this.mt);
            Intrinsics.checkNotNull((Object)this.mt);
            int n5 = this.mt[n];
            Intrinsics.checkNotNull((Object)this.mt);
            int n6 = this.mt[n - 1];
            Intrinsics.checkNotNull((Object)this.mt);
            this.mt[n] = (n5 ^ (n6 ^ this.mt[n - 1] >>> 30) * 1664525) + nArray[n2] + n2;
            ++n2;
            if (++n >= N) {
                Intrinsics.checkNotNull((Object)this.mt);
                Intrinsics.checkNotNull((Object)this.mt);
                this.mt[0] = this.mt[N - 1];
                n = 1;
            }
            if (n2 >= nArray.length) {
                n2 = 0;
            }
            --n3;
        }
        for (n3 = N - 1; n3 != 0; --n3) {
            Intrinsics.checkNotNull((Object)this.mt);
            Intrinsics.checkNotNull((Object)this.mt);
            int n7 = this.mt[n];
            Intrinsics.checkNotNull((Object)this.mt);
            int n8 = this.mt[n - 1];
            Intrinsics.checkNotNull((Object)this.mt);
            this.mt[n] = (n7 ^ (n8 ^ this.mt[n - 1] >>> 30) * 1566083941) - n;
            if (++n < N) continue;
            Intrinsics.checkNotNull((Object)this.mt);
            Intrinsics.checkNotNull((Object)this.mt);
            this.mt[0] = this.mt[N - 1];
            n = 1;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        this.mt[0] = Integer.MIN_VALUE;
    }

    public int nextInt() {
        int n;
        int n2 = 0;
        if (this.mti >= N) {
            n = 0;
            int[] nArray = this.mt;
            int[] nArray2 = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n3 = nArray[n + M] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n3 ^ nArray2[n2 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n4 = nArray[n + (M - N)] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n4 ^ nArray2[n2 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray);
            n2 = nArray[N - 1] & UPPER_MASK | nArray[0] & LOWER_MASK;
            int n5 = nArray[M - 1] ^ n2 >>> 1;
            Intrinsics.checkNotNull((Object)nArray2);
            nArray[MersenneTwisterFast.N - 1] = n5 ^ nArray2[n2 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n2 = this.mt[n];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & TEMPERING_MASK_B;
        n2 ^= n2 << 15 & TEMPERING_MASK_C;
        n2 ^= n2 >>> 18;
        return n2;
    }

    public short nextShort() {
        int n;
        int n2 = 0;
        if (this.mti >= N) {
            n = 0;
            int[] nArray = this.mt;
            int[] nArray2 = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n3 = nArray[n + M] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n3 ^ nArray2[n2 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n4 = nArray[n + (M - N)] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n4 ^ nArray2[n2 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray);
            n2 = nArray[N - 1] & UPPER_MASK | nArray[0] & LOWER_MASK;
            int n5 = nArray[M - 1] ^ n2 >>> 1;
            Intrinsics.checkNotNull((Object)nArray2);
            nArray[MersenneTwisterFast.N - 1] = n5 ^ nArray2[n2 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n2 = this.mt[n];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & TEMPERING_MASK_B;
        n2 ^= n2 << 15 & TEMPERING_MASK_C;
        n2 ^= n2 >>> 18;
        return (short)(n2 >>> 16);
    }

    public char nextChar() {
        int n;
        int n2 = 0;
        if (this.mti >= N) {
            n = 0;
            int[] nArray = this.mt;
            int[] nArray2 = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n3 = nArray[n + M] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n3 ^ nArray2[n2 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n4 = nArray[n + (M - N)] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n4 ^ nArray2[n2 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray);
            n2 = nArray[N - 1] & UPPER_MASK | nArray[0] & LOWER_MASK;
            int n5 = nArray[M - 1] ^ n2 >>> 1;
            Intrinsics.checkNotNull((Object)nArray2);
            nArray[MersenneTwisterFast.N - 1] = n5 ^ nArray2[n2 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n2 = this.mt[n];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & TEMPERING_MASK_B;
        n2 ^= n2 << 15 & TEMPERING_MASK_C;
        n2 ^= n2 >>> 18;
        return (char)(n2 >>> 16);
    }

    public boolean nextBoolean() {
        int n;
        int n2 = 0;
        if (this.mti >= N) {
            n = 0;
            int[] nArray = this.mt;
            int[] nArray2 = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n3 = nArray[n + M] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n3 ^ nArray2[n2 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n4 = nArray[n + (M - N)] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n4 ^ nArray2[n2 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray);
            n2 = nArray[N - 1] & UPPER_MASK | nArray[0] & LOWER_MASK;
            int n5 = nArray[M - 1] ^ n2 >>> 1;
            Intrinsics.checkNotNull((Object)nArray2);
            nArray[MersenneTwisterFast.N - 1] = n5 ^ nArray2[n2 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n2 = this.mt[n];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & TEMPERING_MASK_B;
        n2 ^= n2 << 15 & TEMPERING_MASK_C;
        n2 ^= n2 >>> 18;
        return n2 >>> 31 != 0;
    }

    public boolean nextBoolean(float f) {
        int n;
        int n2 = 0;
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (f == 0.0f) {
            return false;
        }
        if (f == 1.0f) {
            return true;
        }
        if (this.mti >= N) {
            n = 0;
            int[] nArray = this.mt;
            int[] nArray2 = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n3 = nArray[n + M] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n3 ^ nArray2[n2 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n4 = nArray[n + (M - N)] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n4 ^ nArray2[n2 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray);
            n2 = nArray[N - 1] & UPPER_MASK | nArray[0] & LOWER_MASK;
            int n5 = nArray[M - 1] ^ n2 >>> 1;
            Intrinsics.checkNotNull((Object)nArray2);
            nArray[MersenneTwisterFast.N - 1] = n5 ^ nArray2[n2 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n2 = this.mt[n];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & TEMPERING_MASK_B;
        n2 ^= n2 << 15 & TEMPERING_MASK_C;
        n2 ^= n2 >>> 18;
        return (float)(n2 >>> 8) / 1.6777216E7f < f;
    }

    public boolean nextBoolean(double d) {
        int[] nArray;
        int[] nArray2;
        int n;
        int n2 = 0;
        int n3 = 0;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (d == 0.0) {
            return false;
        }
        if (d == 1.0) {
            return true;
        }
        if (this.mti >= N) {
            n = 0;
            nArray2 = this.mt;
            nArray = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray2);
                n2 = nArray2[n] & UPPER_MASK | nArray2[n + 1] & LOWER_MASK;
                int n4 = nArray2[n + M] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[n] = n4 ^ nArray[n2 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray2);
                n2 = nArray2[n] & UPPER_MASK | nArray2[n + 1] & LOWER_MASK;
                int n5 = nArray2[n + (M - N)] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[n] = n5 ^ nArray[n2 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray2);
            n2 = nArray2[N - 1] & UPPER_MASK | nArray2[0] & LOWER_MASK;
            int n6 = nArray2[M - 1] ^ n2 >>> 1;
            Intrinsics.checkNotNull((Object)nArray);
            nArray2[MersenneTwisterFast.N - 1] = n6 ^ nArray[n2 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n2 = this.mt[n];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & TEMPERING_MASK_B;
        n2 ^= n2 << 15 & TEMPERING_MASK_C;
        n2 ^= n2 >>> 18;
        if (this.mti >= N) {
            n = 0;
            nArray2 = this.mt;
            nArray = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray2);
                n3 = nArray2[n] & UPPER_MASK | nArray2[n + 1] & LOWER_MASK;
                int n7 = nArray2[n + M] ^ n3 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[n] = n7 ^ nArray[n3 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray2);
                n3 = nArray2[n] & UPPER_MASK | nArray2[n + 1] & LOWER_MASK;
                int n8 = nArray2[n + (M - N)] ^ n3 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[n] = n8 ^ nArray[n3 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray2);
            n3 = nArray2[N - 1] & UPPER_MASK | nArray2[0] & LOWER_MASK;
            int n9 = nArray2[M - 1] ^ n3 >>> 1;
            Intrinsics.checkNotNull((Object)nArray);
            nArray2[MersenneTwisterFast.N - 1] = n9 ^ nArray[n3 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n3 = this.mt[n];
        n3 ^= n3 >>> 11;
        n3 ^= n3 << 7 & TEMPERING_MASK_B;
        n3 ^= n3 << 15 & TEMPERING_MASK_C;
        n3 ^= n3 >>> 18;
        return (double)(((long)(n2 >>> 6) << 27) + (long)(n3 >>> 5)) / 9.007199254740992E15 < d;
    }

    public byte nextByte() {
        int n;
        int n2 = 0;
        if (this.mti >= N) {
            n = 0;
            int[] nArray = this.mt;
            int[] nArray2 = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n3 = nArray[n + M] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n3 ^ nArray2[n2 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n4 = nArray[n + (M - N)] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n4 ^ nArray2[n2 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray);
            n2 = nArray[N - 1] & UPPER_MASK | nArray[0] & LOWER_MASK;
            int n5 = nArray[M - 1] ^ n2 >>> 1;
            Intrinsics.checkNotNull((Object)nArray2);
            nArray[MersenneTwisterFast.N - 1] = n5 ^ nArray2[n2 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n2 = this.mt[n];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & TEMPERING_MASK_B;
        n2 ^= n2 << 15 & TEMPERING_MASK_C;
        n2 ^= n2 >>> 18;
        return (byte)(n2 >>> 24);
    }

    public void nextBytes(byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        int n = 0;
        int n2 = byArray.length;
        for (int j = 0; j < n2; ++j) {
            int n3;
            if (this.mti >= N) {
                n3 = 0;
                int[] nArray = this.mt;
                int[] nArray2 = this.mag01;
                for (n3 = 0; n3 < N - M; ++n3) {
                    Intrinsics.checkNotNull((Object)nArray);
                    n = nArray[n3] & UPPER_MASK | nArray[n3 + 1] & LOWER_MASK;
                    int n4 = nArray[n3 + M] ^ n >>> 1;
                    Intrinsics.checkNotNull((Object)nArray2);
                    nArray[n3] = n4 ^ nArray2[n & 1];
                }
                while (n3 < N - 1) {
                    Intrinsics.checkNotNull((Object)nArray);
                    n = nArray[n3] & UPPER_MASK | nArray[n3 + 1] & LOWER_MASK;
                    int n5 = nArray[n3 + (M - N)] ^ n >>> 1;
                    Intrinsics.checkNotNull((Object)nArray2);
                    nArray[n3] = n5 ^ nArray2[n & 1];
                    ++n3;
                }
                Intrinsics.checkNotNull((Object)nArray);
                n = nArray[N - 1] & UPPER_MASK | nArray[0] & LOWER_MASK;
                int n6 = nArray[M - 1] ^ n >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[MersenneTwisterFast.N - 1] = n6 ^ nArray2[n & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            n3 = this.mti;
            this.mti = n3 + 1;
            n = this.mt[n3];
            n ^= n >>> 11;
            n ^= n << 7 & TEMPERING_MASK_B;
            n ^= n << 15 & TEMPERING_MASK_C;
            n ^= n >>> 18;
            byArray[j] = (byte)(n >>> 24);
        }
    }

    public final long nextLong() {
        int[] nArray;
        int[] nArray2;
        int n;
        int n2 = 0;
        int n3 = 0;
        if (this.mti >= N) {
            n = 0;
            nArray2 = this.mt;
            nArray = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray2);
                n2 = nArray2[n] & UPPER_MASK | nArray2[n + 1] & LOWER_MASK;
                int n4 = nArray2[n + M] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[n] = n4 ^ nArray[n2 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray2);
                n2 = nArray2[n] & UPPER_MASK | nArray2[n + 1] & LOWER_MASK;
                int n5 = nArray2[n + (M - N)] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[n] = n5 ^ nArray[n2 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray2);
            n2 = nArray2[N - 1] & UPPER_MASK | nArray2[0] & LOWER_MASK;
            int n6 = nArray2[M - 1] ^ n2 >>> 1;
            Intrinsics.checkNotNull((Object)nArray);
            nArray2[MersenneTwisterFast.N - 1] = n6 ^ nArray[n2 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n2 = this.mt[n];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & TEMPERING_MASK_B;
        n2 ^= n2 << 15 & TEMPERING_MASK_C;
        n2 ^= n2 >>> 18;
        if (this.mti >= N) {
            n = 0;
            nArray2 = this.mt;
            nArray = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray2);
                n3 = nArray2[n] & UPPER_MASK | nArray2[n + 1] & LOWER_MASK;
                int n7 = nArray2[n + M] ^ n3 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[n] = n7 ^ nArray[n3 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray2);
                n3 = nArray2[n] & UPPER_MASK | nArray2[n + 1] & LOWER_MASK;
                int n8 = nArray2[n + (M - N)] ^ n3 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[n] = n8 ^ nArray[n3 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray2);
            n3 = nArray2[N - 1] & UPPER_MASK | nArray2[0] & LOWER_MASK;
            int n9 = nArray2[M - 1] ^ n3 >>> 1;
            Intrinsics.checkNotNull((Object)nArray);
            nArray2[MersenneTwisterFast.N - 1] = n9 ^ nArray[n3 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n3 = this.mt[n];
        n3 ^= n3 >>> 11;
        n3 ^= n3 << 7 & TEMPERING_MASK_B;
        n3 ^= n3 << 15 & TEMPERING_MASK_C;
        n3 ^= n3 >>> 18;
        return ((long)n2 << 32) + (long)n3;
    }

    public long nextLong(long l) {
        int n;
        int n2;
        if (l <= 0L) {
            throw new IllegalArgumentException("n must be positive, got: " + l);
        }
        long l2 = 0L;
        long l3 = 0L;
        do {
            int[] nArray;
            int[] nArray2;
            int n3;
            n2 = 0;
            n = 0;
            if (this.mti >= N) {
                n3 = 0;
                nArray2 = this.mt;
                nArray = this.mag01;
                for (n3 = 0; n3 < N - M; ++n3) {
                    Intrinsics.checkNotNull((Object)nArray2);
                    n2 = nArray2[n3] & UPPER_MASK | nArray2[n3 + 1] & LOWER_MASK;
                    int n4 = nArray2[n3 + M] ^ n2 >>> 1;
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray2[n3] = n4 ^ nArray[n2 & 1];
                }
                while (n3 < N - 1) {
                    Intrinsics.checkNotNull((Object)nArray2);
                    n2 = nArray2[n3] & UPPER_MASK | nArray2[n3 + 1] & LOWER_MASK;
                    int n5 = nArray2[n3 + (M - N)] ^ n2 >>> 1;
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray2[n3] = n5 ^ nArray[n2 & 1];
                    ++n3;
                }
                Intrinsics.checkNotNull((Object)nArray2);
                n2 = nArray2[N - 1] & UPPER_MASK | nArray2[0] & LOWER_MASK;
                int n6 = nArray2[M - 1] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[MersenneTwisterFast.N - 1] = n6 ^ nArray[n2 & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            n3 = this.mti;
            this.mti = n3 + 1;
            n2 = this.mt[n3];
            n2 ^= n2 >>> 11;
            n2 ^= n2 << 7 & TEMPERING_MASK_B;
            n2 ^= n2 << 15 & TEMPERING_MASK_C;
            n2 ^= n2 >>> 18;
            if (this.mti >= N) {
                n3 = 0;
                nArray2 = this.mt;
                nArray = this.mag01;
                for (n3 = 0; n3 < N - M; ++n3) {
                    Intrinsics.checkNotNull((Object)nArray2);
                    n = nArray2[n3] & UPPER_MASK | nArray2[n3 + 1] & LOWER_MASK;
                    int n7 = nArray2[n3 + M] ^ n >>> 1;
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray2[n3] = n7 ^ nArray[n & 1];
                }
                while (n3 < N - 1) {
                    Intrinsics.checkNotNull((Object)nArray2);
                    n = nArray2[n3] & UPPER_MASK | nArray2[n3 + 1] & LOWER_MASK;
                    int n8 = nArray2[n3 + (M - N)] ^ n >>> 1;
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray2[n3] = n8 ^ nArray[n & 1];
                    ++n3;
                }
                Intrinsics.checkNotNull((Object)nArray2);
                n = nArray2[N - 1] & UPPER_MASK | nArray2[0] & LOWER_MASK;
                int n9 = nArray2[M - 1] ^ n >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[MersenneTwisterFast.N - 1] = n9 ^ nArray[n & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            n3 = this.mti;
            this.mti = n3 + 1;
            n = this.mt[n3];
            n ^= n >>> 11;
            n ^= n << 7 & TEMPERING_MASK_B;
            n ^= n << 15 & TEMPERING_MASK_C;
        } while ((l2 = ((long)n2 << 32) + (long)(n ^= n >>> 18) >>> 1) - (l3 = l2 % l) + (l - 1L) < 0L);
        return l3;
    }

    public double nextDouble() {
        int[] nArray;
        int[] nArray2;
        int n;
        int n2 = 0;
        int n3 = 0;
        if (this.mti >= N) {
            n = 0;
            nArray2 = this.mt;
            nArray = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray2);
                n2 = nArray2[n] & UPPER_MASK | nArray2[n + 1] & LOWER_MASK;
                int n4 = nArray2[n + M] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[n] = n4 ^ nArray[n2 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray2);
                n2 = nArray2[n] & UPPER_MASK | nArray2[n + 1] & LOWER_MASK;
                int n5 = nArray2[n + (M - N)] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[n] = n5 ^ nArray[n2 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray2);
            n2 = nArray2[N - 1] & UPPER_MASK | nArray2[0] & LOWER_MASK;
            int n6 = nArray2[M - 1] ^ n2 >>> 1;
            Intrinsics.checkNotNull((Object)nArray);
            nArray2[MersenneTwisterFast.N - 1] = n6 ^ nArray[n2 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n2 = this.mt[n];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & TEMPERING_MASK_B;
        n2 ^= n2 << 15 & TEMPERING_MASK_C;
        n2 ^= n2 >>> 18;
        if (this.mti >= N) {
            n = 0;
            nArray2 = this.mt;
            nArray = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray2);
                n3 = nArray2[n] & UPPER_MASK | nArray2[n + 1] & LOWER_MASK;
                int n7 = nArray2[n + M] ^ n3 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[n] = n7 ^ nArray[n3 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray2);
                n3 = nArray2[n] & UPPER_MASK | nArray2[n + 1] & LOWER_MASK;
                int n8 = nArray2[n + (M - N)] ^ n3 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[n] = n8 ^ nArray[n3 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray2);
            n3 = nArray2[N - 1] & UPPER_MASK | nArray2[0] & LOWER_MASK;
            int n9 = nArray2[M - 1] ^ n3 >>> 1;
            Intrinsics.checkNotNull((Object)nArray);
            nArray2[MersenneTwisterFast.N - 1] = n9 ^ nArray[n3 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n3 = this.mt[n];
        n3 ^= n3 >>> 11;
        n3 ^= n3 << 7 & TEMPERING_MASK_B;
        n3 ^= n3 << 15 & TEMPERING_MASK_C;
        n3 ^= n3 >>> 18;
        return (double)(((long)(n2 >>> 6) << 27) + (long)(n3 >>> 5)) / 9.007199254740992E15;
    }

    public double nextDouble(boolean bl, boolean bl2) {
        double d = 0.0;
        do {
            d = this.nextDouble();
            if (!bl2 || !this.nextBoolean()) continue;
            d += 1.0;
        } while (d > 1.0 || !bl && d == 0.0);
        return d;
    }

    public final void clearGaussian() {
        this.__haveNextNextGaussian = false;
    }

    public double nextGaussian() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.__haveNextNextGaussian) {
            this.__haveNextNextGaussian = false;
            return this.__nextNextGaussian;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        do {
            int[] nArray;
            int[] nArray2;
            int n5;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            n = 0;
            if (this.mti >= N) {
                n5 = 0;
                nArray2 = this.mt;
                nArray = this.mag01;
                for (n5 = 0; n5 < N - M; ++n5) {
                    Intrinsics.checkNotNull((Object)nArray2);
                    n4 = nArray2[n5] & UPPER_MASK | nArray2[n5 + 1] & LOWER_MASK;
                    int n6 = nArray2[n5 + M] ^ n4 >>> 1;
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray2[n5] = n6 ^ nArray[n4 & 1];
                }
                while (n5 < N - 1) {
                    Intrinsics.checkNotNull((Object)nArray2);
                    n4 = nArray2[n5] & UPPER_MASK | nArray2[n5 + 1] & LOWER_MASK;
                    int n7 = nArray2[n5 + (M - N)] ^ n4 >>> 1;
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray2[n5] = n7 ^ nArray[n4 & 1];
                    ++n5;
                }
                Intrinsics.checkNotNull((Object)nArray2);
                n4 = nArray2[N - 1] & UPPER_MASK | nArray2[0] & LOWER_MASK;
                int n8 = nArray2[M - 1] ^ n4 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[MersenneTwisterFast.N - 1] = n8 ^ nArray[n4 & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            n5 = this.mti;
            this.mti = n5 + 1;
            n4 = this.mt[n5];
            n4 ^= n4 >>> 11;
            n4 ^= n4 << 7 & TEMPERING_MASK_B;
            n4 ^= n4 << 15 & TEMPERING_MASK_C;
            n4 ^= n4 >>> 18;
            if (this.mti >= N) {
                n5 = 0;
                nArray2 = this.mt;
                nArray = this.mag01;
                for (n5 = 0; n5 < N - M; ++n5) {
                    Intrinsics.checkNotNull((Object)nArray2);
                    n3 = nArray2[n5] & UPPER_MASK | nArray2[n5 + 1] & LOWER_MASK;
                    int n9 = nArray2[n5 + M] ^ n3 >>> 1;
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray2[n5] = n9 ^ nArray[n3 & 1];
                }
                while (n5 < N - 1) {
                    Intrinsics.checkNotNull((Object)nArray2);
                    n3 = nArray2[n5] & UPPER_MASK | nArray2[n5 + 1] & LOWER_MASK;
                    int n10 = nArray2[n5 + (M - N)] ^ n3 >>> 1;
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray2[n5] = n10 ^ nArray[n3 & 1];
                    ++n5;
                }
                Intrinsics.checkNotNull((Object)nArray2);
                n3 = nArray2[N - 1] & UPPER_MASK | nArray2[0] & LOWER_MASK;
                int n11 = nArray2[M - 1] ^ n3 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[MersenneTwisterFast.N - 1] = n11 ^ nArray[n3 & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            n5 = this.mti;
            this.mti = n5 + 1;
            n3 = this.mt[n5];
            n3 ^= n3 >>> 11;
            n3 ^= n3 << 7 & TEMPERING_MASK_B;
            n3 ^= n3 << 15 & TEMPERING_MASK_C;
            n3 ^= n3 >>> 18;
            if (this.mti >= N) {
                n5 = 0;
                nArray2 = this.mt;
                nArray = this.mag01;
                for (n5 = 0; n5 < N - M; ++n5) {
                    Intrinsics.checkNotNull((Object)nArray2);
                    n2 = nArray2[n5] & UPPER_MASK | nArray2[n5 + 1] & LOWER_MASK;
                    int n12 = nArray2[n5 + M] ^ n2 >>> 1;
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray2[n5] = n12 ^ nArray[n2 & 1];
                }
                while (n5 < N - 1) {
                    Intrinsics.checkNotNull((Object)nArray2);
                    n2 = nArray2[n5] & UPPER_MASK | nArray2[n5 + 1] & LOWER_MASK;
                    int n13 = nArray2[n5 + (M - N)] ^ n2 >>> 1;
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray2[n5] = n13 ^ nArray[n2 & 1];
                    ++n5;
                }
                Intrinsics.checkNotNull((Object)nArray2);
                n2 = nArray2[N - 1] & UPPER_MASK | nArray2[0] & LOWER_MASK;
                int n14 = nArray2[M - 1] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[MersenneTwisterFast.N - 1] = n14 ^ nArray[n2 & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            n5 = this.mti;
            this.mti = n5 + 1;
            n2 = this.mt[n5];
            n2 ^= n2 >>> 11;
            n2 ^= n2 << 7 & TEMPERING_MASK_B;
            n2 ^= n2 << 15 & TEMPERING_MASK_C;
            n2 ^= n2 >>> 18;
            if (this.mti >= N) {
                n5 = 0;
                nArray2 = this.mt;
                nArray = this.mag01;
                for (n5 = 0; n5 < N - M; ++n5) {
                    Intrinsics.checkNotNull((Object)nArray2);
                    n = nArray2[n5] & UPPER_MASK | nArray2[n5 + 1] & LOWER_MASK;
                    int n15 = nArray2[n5 + M] ^ n >>> 1;
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray2[n5] = n15 ^ nArray[n & 1];
                }
                while (n5 < N - 1) {
                    Intrinsics.checkNotNull((Object)nArray2);
                    n = nArray2[n5] & UPPER_MASK | nArray2[n5 + 1] & LOWER_MASK;
                    int n16 = nArray2[n5 + (M - N)] ^ n >>> 1;
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray2[n5] = n16 ^ nArray[n & 1];
                    ++n5;
                }
                Intrinsics.checkNotNull((Object)nArray2);
                n = nArray2[N - 1] & UPPER_MASK | nArray2[0] & LOWER_MASK;
                int n17 = nArray2[M - 1] ^ n >>> 1;
                Intrinsics.checkNotNull((Object)nArray);
                nArray2[MersenneTwisterFast.N - 1] = n17 ^ nArray[n & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            n5 = this.mti;
            this.mti = n5 + 1;
            n = this.mt[n5];
            n ^= n >>> 11;
            n ^= n << 7 & TEMPERING_MASK_B;
            n ^= n << 15 & TEMPERING_MASK_C;
        } while ((d3 = (d = (double)2 * ((double)(((long)(n4 >>> 6) << 27) + (long)(n3 >>> 5)) / 9.007199254740992E15) - 1.0) * d + (d2 = (double)2 * ((double)(((long)(n2 >>> 6) << 27) + (long)((n ^= n >>> 18) >>> 5)) / 9.007199254740992E15) - 1.0) * d2) >= 1.0 || d3 == 0.0);
        double d4 = Math.sqrt((double)-2 * Math.log(d3) / d3);
        this.__nextNextGaussian = d2 * d4;
        this.__haveNextNextGaussian = true;
        return d * d4;
    }

    public float nextFloat() {
        int n;
        int n2 = 0;
        if (this.mti >= N) {
            n = 0;
            int[] nArray = this.mt;
            int[] nArray2 = this.mag01;
            for (n = 0; n < N - M; ++n) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n3 = nArray[n + M] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n3 ^ nArray2[n2 & 1];
            }
            while (n < N - 1) {
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[n] & UPPER_MASK | nArray[n + 1] & LOWER_MASK;
                int n4 = nArray[n + (M - N)] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[n] = n4 ^ nArray2[n2 & 1];
                ++n;
            }
            Intrinsics.checkNotNull((Object)nArray);
            n2 = nArray[N - 1] & UPPER_MASK | nArray[0] & LOWER_MASK;
            int n5 = nArray[M - 1] ^ n2 >>> 1;
            Intrinsics.checkNotNull((Object)nArray2);
            nArray[MersenneTwisterFast.N - 1] = n5 ^ nArray2[n2 & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mti;
        this.mti = n + 1;
        n2 = this.mt[n];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & TEMPERING_MASK_B;
        n2 ^= n2 << 15 & TEMPERING_MASK_C;
        n2 ^= n2 >>> 18;
        return (float)(n2 >>> 8) / 1.6777216E7f;
    }

    public float nextFloat(boolean bl, boolean bl2) {
        float f = 0.0f;
        do {
            f = this.nextFloat();
            if (!bl2 || !this.nextBoolean()) continue;
            f += 1.0f;
        } while (f > 1.0f || !bl && f == 0.0f);
        return f;
    }

    public int nextInt(int n) {
        int n2;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive, got: " + n);
        }
        if ((n & -n) == n) {
            int n3;
            int n4 = 0;
            if (this.mti >= N) {
                n3 = 0;
                int[] nArray = this.mt;
                int[] nArray2 = this.mag01;
                for (n3 = 0; n3 < N - M; ++n3) {
                    Intrinsics.checkNotNull((Object)nArray);
                    n4 = nArray[n3] & UPPER_MASK | nArray[n3 + 1] & LOWER_MASK;
                    int n5 = nArray[n3 + M] ^ n4 >>> 1;
                    Intrinsics.checkNotNull((Object)nArray2);
                    nArray[n3] = n5 ^ nArray2[n4 & 1];
                }
                while (n3 < N - 1) {
                    Intrinsics.checkNotNull((Object)nArray);
                    n4 = nArray[n3] & UPPER_MASK | nArray[n3 + 1] & LOWER_MASK;
                    int n6 = nArray[n3 + (M - N)] ^ n4 >>> 1;
                    Intrinsics.checkNotNull((Object)nArray2);
                    nArray[n3] = n6 ^ nArray2[n4 & 1];
                    ++n3;
                }
                Intrinsics.checkNotNull((Object)nArray);
                n4 = nArray[N - 1] & UPPER_MASK | nArray[0] & LOWER_MASK;
                int n7 = nArray[M - 1] ^ n4 >>> 1;
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[MersenneTwisterFast.N - 1] = n7 ^ nArray2[n4 & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            n3 = this.mti;
            this.mti = n3 + 1;
            n4 = this.mt[n3];
            n4 ^= n4 >>> 11;
            n4 ^= n4 << 7 & TEMPERING_MASK_B;
            n4 ^= n4 << 15 & TEMPERING_MASK_C;
            n4 ^= n4 >>> 18;
            return (int)((long)n * (long)(n4 >>> 1) >> 31);
        }
        int n8 = 0;
        int n9 = 0;
        do {
            int n10;
            n2 = 0;
            if (this.mti >= N) {
                n10 = 0;
                int[] nArray = this.mt;
                int[] nArray3 = this.mag01;
                for (n10 = 0; n10 < N - M; ++n10) {
                    Intrinsics.checkNotNull((Object)nArray);
                    n2 = nArray[n10] & UPPER_MASK | nArray[n10 + 1] & LOWER_MASK;
                    int n11 = nArray[n10 + M] ^ n2 >>> 1;
                    Intrinsics.checkNotNull((Object)nArray3);
                    nArray[n10] = n11 ^ nArray3[n2 & 1];
                }
                while (n10 < N - 1) {
                    Intrinsics.checkNotNull((Object)nArray);
                    n2 = nArray[n10] & UPPER_MASK | nArray[n10 + 1] & LOWER_MASK;
                    int n12 = nArray[n10 + (M - N)] ^ n2 >>> 1;
                    Intrinsics.checkNotNull((Object)nArray3);
                    nArray[n10] = n12 ^ nArray3[n2 & 1];
                    ++n10;
                }
                Intrinsics.checkNotNull((Object)nArray);
                n2 = nArray[N - 1] & UPPER_MASK | nArray[0] & LOWER_MASK;
                int n13 = nArray[M - 1] ^ n2 >>> 1;
                Intrinsics.checkNotNull((Object)nArray3);
                nArray[MersenneTwisterFast.N - 1] = n13 ^ nArray3[n2 & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            n10 = this.mti;
            this.mti = n10 + 1;
            n2 = this.mt[n10];
            n2 ^= n2 >>> 11;
            n2 ^= n2 << 7 & TEMPERING_MASK_B;
            n2 ^= n2 << 15 & TEMPERING_MASK_C;
        } while ((n8 = (n2 ^= n2 >>> 18) >>> 1) - (n9 = n8 % n) + (n - 1) < 0);
        return n9;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ldorkbox/util/MersenneTwisterFast$Companion;", "", "()V", "LOWER_MASK", "", "M", "MATRIX_A", "N", "TEMPERING_MASK_B", "TEMPERING_MASK_C", "UPPER_MASK", "serialVersionUID", "", "version", "", "getVersion", "()Ljava/lang/String;", "Utilities"})
    public static final class Companion {
        private Companion() {
        }

        public final String getVersion() {
            return version;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

