/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.MultiParagraphIntrinsicsKt;
import androidx.compose.ui.text.ParagraphIntrinsicInfo;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.ParagraphIntrinsicsKt;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.DelegatingFontLoaderForDeprecatedUsage_skikoKt;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.unit.Density;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fB=\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000e\u0010\u0012J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0004\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001d\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001c\u001a\u0004\b\u001e\u0010\u001aR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "Landroidx/compose/ui/text/ParagraphIntrinsics;", "annotatedString", "Landroidx/compose/ui/text/AnnotatedString;", "style", "Landroidx/compose/ui/text/TextStyle;", "placeholders", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/Placeholder;", "density", "Landroidx/compose/ui/unit/Density;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "<init>", "(Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/FontFamily$Resolver;)V", "resourceLoader", "Landroidx/compose/ui/text/font/Font$ResourceLoader;", "(Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/Font$ResourceLoader;)V", "getAnnotatedString", "()Landroidx/compose/ui/text/AnnotatedString;", "getPlaceholders", "()Ljava/util/List;", "minIntrinsicWidth", "", "getMinIntrinsicWidth", "()F", "minIntrinsicWidth$delegate", "Lkotlin/Lazy;", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "maxIntrinsicWidth$delegate", "infoList", "Landroidx/compose/ui/text/ParagraphIntrinsicInfo;", "getInfoList$ui_text", "hasStaleResolvedFonts", "", "getHasStaleResolvedFonts", "()Z", "resolveTextDirection", "Landroidx/compose/ui/text/ParagraphStyle;", "defaultStyle", "ui-text"})
public final class MultiParagraphIntrinsics
implements ParagraphIntrinsics {
    private final AnnotatedString annotatedString;
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    private final Lazy minIntrinsicWidth$delegate;
    private final Lazy maxIntrinsicWidth$delegate;
    private final List<ParagraphIntrinsicInfo> infoList;
    public static final int $stable = 8;

    public MultiParagraphIntrinsics(AnnotatedString annotatedString, TextStyle textStyle, List<AnnotatedString.Range<Placeholder>> list, Density density, FontFamily.Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)density, (String)"");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"");
        this.annotatedString = annotatedString;
        this.placeholders = list;
        this.minIntrinsicWidth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> MultiParagraphIntrinsics.minIntrinsicWidth_delegate$lambda$0(this));
        this.maxIntrinsicWidth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> MultiParagraphIntrinsics.maxIntrinsicWidth_delegate$lambda$0(this));
        ParagraphStyle paragraphStyle = textStyle.toParagraphStyle();
        AnnotatedString annotatedString2 = this.annotatedString;
        ParagraphStyle paragraphStyle2 = paragraphStyle;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this;
        boolean bl = false;
        List<AnnotatedString.Range<ParagraphStyle>> list2 = AnnotatedStringKt.normalizedParagraphStyles(annotatedString2, paragraphStyle2);
        boolean bl2 = false;
        ArrayList arrayList = new ArrayList(list2.size());
        List<AnnotatedString.Range<ParagraphStyle>> list3 = list2;
        boolean bl3 = false;
        int n = ((Collection)list3).size();
        for (int k = 0; k < n; ++k) {
            AnnotatedString.Range<ParagraphStyle> range;
            AnnotatedString.Range<ParagraphStyle> range2 = range = list3.get(k);
            boolean bl4 = false;
            AnnotatedString.Range<ParagraphStyle> range3 = range2;
            Collection collection = arrayList;
            boolean bl5 = false;
            AnnotatedString annotatedString3 = AnnotatedStringKt.access$substringWithoutParagraphStyles(annotatedString2, range3.getStart(), range3.getEnd());
            AnnotatedString.Range<ParagraphStyle> range4 = range3;
            AnnotatedString annotatedString4 = annotatedString3;
            boolean bl6 = false;
            ParagraphStyle paragraphStyle3 = this.resolveTextDirection(range4.getItem(), paragraphStyle);
            String string = annotatedString4.getText();
            TextStyle textStyle2 = textStyle.merge(paragraphStyle3);
            List list4 = annotatedString4.getAnnotations$ui_text();
            if (list4 == null) {
                list4 = CollectionsKt.emptyList();
            }
            List list5 = list4;
            List list6 = MultiParagraphIntrinsicsKt.access$getLocalPlaceholders(this.getPlaceholders(), range4.getStart(), range4.getEnd());
            collection.add(new ParagraphIntrinsicInfo(ParagraphIntrinsicsKt.ParagraphIntrinsics(string, textStyle2, list5, density, resolver, list6), range4.getStart(), range4.getEnd()));
        }
        multiParagraphIntrinsics.infoList = arrayList;
    }

    public final AnnotatedString getAnnotatedString() {
        return this.annotatedString;
    }

    public final List<AnnotatedString.Range<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    @Deprecated(message="Font.ResourceLoader is deprecated, call with fontFamilyResolver", replaceWith=@ReplaceWith(expression="MultiParagraphIntrinsics(annotatedString, style, placeholders, density, fontFamilyResolver)", imports={}))
    public MultiParagraphIntrinsics(AnnotatedString annotatedString, TextStyle textStyle, List<AnnotatedString.Range<Placeholder>> list, Density density, Font.ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)density, (String)"");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"");
        this(annotatedString, textStyle, list, density, DelegatingFontLoaderForDeprecatedUsage_skikoKt.createFontFamilyResolver(resourceLoader));
    }

    @Override
    public float getMinIntrinsicWidth() {
        Lazy lazy = this.minIntrinsicWidth$delegate;
        return ((Number)lazy.getValue()).floatValue();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        Lazy lazy = this.maxIntrinsicWidth$delegate;
        return ((Number)lazy.getValue()).floatValue();
    }

    public final List<ParagraphIntrinsicInfo> getInfoList$ui_text() {
        return this.infoList;
    }

    @Override
    public boolean getHasStaleResolvedFonts() {
        boolean bl;
        block1: {
            List<ParagraphIntrinsicInfo> list = this.infoList;
            boolean bl2 = false;
            List<ParagraphIntrinsicInfo> list2 = list;
            boolean bl3 = false;
            int n = ((Collection)list2).size();
            for (int k = 0; k < n; ++k) {
                ParagraphIntrinsicInfo paragraphIntrinsicInfo;
                ParagraphIntrinsicInfo paragraphIntrinsicInfo2 = paragraphIntrinsicInfo = list2.get(k);
                boolean bl4 = false;
                ParagraphIntrinsicInfo paragraphIntrinsicInfo3 = paragraphIntrinsicInfo2;
                boolean bl5 = false;
                if (!paragraphIntrinsicInfo3.getIntrinsics().getHasStaleResolvedFonts()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final ParagraphStyle resolveTextDirection(ParagraphStyle paragraphStyle, ParagraphStyle paragraphStyle2) {
        return !TextDirection.equals-impl0(paragraphStyle.getTextDirection-s_7X-co(), TextDirection.Companion.getUnspecified-s_7X-co()) ? paragraphStyle : ParagraphStyle.copy-ykzQM6k$default(paragraphStyle, 0, paragraphStyle2.getTextDirection-s_7X-co(), 0L, null, null, null, 0, 0, null, 509, null);
    }

    private static final float minIntrinsicWidth_delegate$lambda$0(MultiParagraphIntrinsics multiParagraphIntrinsics) {
        Object object;
        ParagraphIntrinsicInfo paragraphIntrinsicInfo;
        List<ParagraphIntrinsicInfo> list = multiParagraphIntrinsics.infoList;
        boolean bl = false;
        if (list.isEmpty()) {
            paragraphIntrinsicInfo = null;
        } else {
            ParagraphIntrinsicInfo paragraphIntrinsicInfo2;
            ParagraphIntrinsicInfo paragraphIntrinsicInfo3 = paragraphIntrinsicInfo2 = list.get(0);
            int n = 0;
            float f = paragraphIntrinsicInfo3.getIntrinsics().getMinIntrinsicWidth();
            n = 1;
            int n2 = CollectionsKt.getLastIndex(list);
            if (n <= n2) {
                while (true) {
                    ParagraphIntrinsicInfo paragraphIntrinsicInfo4;
                    ParagraphIntrinsicInfo paragraphIntrinsicInfo5 = paragraphIntrinsicInfo4 = list.get(n);
                    boolean bl2 = false;
                    float f2 = paragraphIntrinsicInfo5.getIntrinsics().getMinIntrinsicWidth();
                    if (Float.compare(f, f2) < 0) {
                        paragraphIntrinsicInfo2 = paragraphIntrinsicInfo4;
                        f = f2;
                    }
                    if (n == n2) break;
                    ++n;
                }
            }
            paragraphIntrinsicInfo = paragraphIntrinsicInfo2;
        }
        return (object = (ParagraphIntrinsicInfo)paragraphIntrinsicInfo) != null && (object = ((ParagraphIntrinsicInfo)object).getIntrinsics()) != null ? object.getMinIntrinsicWidth() : 0.0f;
    }

    private static final float maxIntrinsicWidth_delegate$lambda$0(MultiParagraphIntrinsics multiParagraphIntrinsics) {
        Object object;
        ParagraphIntrinsicInfo paragraphIntrinsicInfo;
        List<ParagraphIntrinsicInfo> list = multiParagraphIntrinsics.infoList;
        boolean bl = false;
        if (list.isEmpty()) {
            paragraphIntrinsicInfo = null;
        } else {
            ParagraphIntrinsicInfo paragraphIntrinsicInfo2;
            ParagraphIntrinsicInfo paragraphIntrinsicInfo3 = paragraphIntrinsicInfo2 = list.get(0);
            int n = 0;
            float f = paragraphIntrinsicInfo3.getIntrinsics().getMaxIntrinsicWidth();
            n = 1;
            int n2 = CollectionsKt.getLastIndex(list);
            if (n <= n2) {
                while (true) {
                    ParagraphIntrinsicInfo paragraphIntrinsicInfo4;
                    ParagraphIntrinsicInfo paragraphIntrinsicInfo5 = paragraphIntrinsicInfo4 = list.get(n);
                    boolean bl2 = false;
                    float f2 = paragraphIntrinsicInfo5.getIntrinsics().getMaxIntrinsicWidth();
                    if (Float.compare(f, f2) < 0) {
                        paragraphIntrinsicInfo2 = paragraphIntrinsicInfo4;
                        f = f2;
                    }
                    if (n == n2) break;
                    ++n;
                }
            }
            paragraphIntrinsicInfo = paragraphIntrinsicInfo2;
        }
        return (object = (ParagraphIntrinsicInfo)paragraphIntrinsicInfo) != null && (object = ((ParagraphIntrinsicInfo)object).getIntrinsics()) != null ? object.getMaxIntrinsicWidth() : 0.0f;
    }
}

