/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.GapBuffer;
import androidx.compose.ui.text.input.GapBufferKt;
import androidx.compose.ui.text.input.GapBuffer_jvmKt;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0086\u0002J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Landroidx/compose/ui/text/input/PartialGapBuffer;", "", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "setText", "buffer", "Landroidx/compose/ui/text/input/GapBuffer;", "bufStart", "", "bufEnd", "length", "getLength", "()I", "replace", "", "start", "end", "get", "", "index", "toString", "Companion", "ui-text"})
public final class PartialGapBuffer {
    public static final Companion Companion = new Companion(null);
    private String text;
    private GapBuffer buffer;
    private int bufStart;
    private int bufEnd;
    public static final int $stable = 8;
    public static final int BUF_SIZE = 255;
    public static final int SURROUNDING_SIZE = 64;
    public static final int NOWHERE = -1;

    public PartialGapBuffer(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.text = string;
        this.bufStart = -1;
        this.bufEnd = -1;
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.text = string;
    }

    public final int getLength() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.length();
        }
        GapBuffer gapBuffer2 = gapBuffer;
        return this.text.length() - (this.bufEnd - this.bufStart) + gapBuffer2.length();
    }

    public final void replace(int n, int n2, String string) {
        int n3;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        boolean bl = n <= n2;
        int n4 = 0;
        if (!bl) {
            n3 = 0;
            InlineClassHelperKt.throwIllegalArgumentException("start index must be less than or equal to end index: " + n + " > " + n2);
        }
        bl = n >= 0;
        n4 = 0;
        if (!bl) {
            n3 = 0;
            InlineClassHelperKt.throwIllegalArgumentException("start must be non-negative, but was " + n);
        }
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            char[] cArray = new char[Math.max(255, string.length() + 128)];
            n3 = Math.min(n, 64);
            int n5 = Math.min(this.text.length() - n2, 64);
            GapBuffer_jvmKt.toCharArray(this.text, cArray, 0, n - n3, n);
            GapBuffer_jvmKt.toCharArray(this.text, cArray, cArray.length - n5, n2, n2 + n5);
            GapBufferKt.access$toCharArray(string, cArray, n3);
            this.buffer = new GapBuffer(cArray, n3 + string.length(), cArray.length - n5);
            this.bufStart = n - n3;
            this.bufEnd = n2 + n5;
            return;
        }
        n4 = n - this.bufStart;
        n3 = n2 - this.bufStart;
        if (n4 < 0 || n3 > gapBuffer.length()) {
            this.text = this.toString();
            this.buffer = null;
            this.bufStart = -1;
            this.bufEnd = -1;
            this.replace(n, n2, string);
            return;
        }
        gapBuffer.replace(n4, n3, string);
    }

    public final char get(int n) {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.charAt(n);
        }
        GapBuffer gapBuffer2 = gapBuffer;
        if (n < this.bufStart) {
            return this.text.charAt(n);
        }
        int n2 = gapBuffer2.length();
        if (n < n2 + this.bufStart) {
            return gapBuffer2.get(n - this.bufStart);
        }
        return this.text.charAt(n - (n2 - this.bufEnd + this.bufStart));
    }

    public String toString() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text;
        }
        GapBuffer gapBuffer2 = gapBuffer;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.text, 0, this.bufStart);
        gapBuffer2.append(stringBuilder);
        stringBuilder.append(this.text, this.bufEnd, this.text.length());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/text/input/PartialGapBuffer$Companion;", "", "<init>", "()V", "BUF_SIZE", "", "SURROUNDING_SIZE", "NOWHERE", "ui-text"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

