/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Landroidx/compose/ui/text/input/SetComposingTextCommand;", "Landroidx/compose/ui/text/input/EditCommand;", "annotatedString", "Landroidx/compose/ui/text/AnnotatedString;", "newCursorPosition", "", "<init>", "(Landroidx/compose/ui/text/AnnotatedString;I)V", "text", "", "(Ljava/lang/String;I)V", "getAnnotatedString", "()Landroidx/compose/ui/text/AnnotatedString;", "getNewCursorPosition", "()I", "getText", "()Ljava/lang/String;", "applyTo", "", "buffer", "Landroidx/compose/ui/text/input/EditingBuffer;", "equals", "", "other", "", "hashCode", "toString", "ui-text"})
public final class SetComposingTextCommand
implements EditCommand {
    private final AnnotatedString annotatedString;
    private final int newCursorPosition;
    public static final int $stable;

    public SetComposingTextCommand(AnnotatedString annotatedString, int n) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"");
        this.annotatedString = annotatedString;
        this.newCursorPosition = n;
    }

    public final AnnotatedString getAnnotatedString() {
        return this.annotatedString;
    }

    public final int getNewCursorPosition() {
        return this.newCursorPosition;
    }

    public SetComposingTextCommand(String string, int n) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this(new AnnotatedString(string, null, 2, null), n);
    }

    public final String getText() {
        return this.annotatedString.getText();
    }

    @Override
    public void applyTo(EditingBuffer editingBuffer) {
        int n;
        Intrinsics.checkNotNullParameter((Object)editingBuffer, (String)"");
        if (editingBuffer.hasComposition$ui_text()) {
            n = editingBuffer.getCompositionStart$ui_text();
            editingBuffer.replace$ui_text(editingBuffer.getCompositionStart$ui_text(), editingBuffer.getCompositionEnd$ui_text(), this.getText());
            if (((CharSequence)this.getText()).length() > 0) {
                editingBuffer.setComposition$ui_text(n, n + this.getText().length());
            }
        } else {
            n = editingBuffer.getSelectionStart$ui_text();
            editingBuffer.replace$ui_text(editingBuffer.getSelectionStart$ui_text(), editingBuffer.getSelectionEnd$ui_text(), this.getText());
            if (((CharSequence)this.getText()).length() > 0) {
                editingBuffer.setComposition$ui_text(n, n + this.getText().length());
            }
        }
        n = editingBuffer.getCursor$ui_text();
        int n2 = this.newCursorPosition > 0 ? n + this.newCursorPosition - 1 : n + this.newCursorPosition - this.getText().length();
        editingBuffer.setCursor$ui_text(RangesKt.coerceIn((int)n2, (int)0, (int)editingBuffer.getLength$ui_text()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SetComposingTextCommand)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getText(), (Object)((SetComposingTextCommand)object).getText())) {
            return false;
        }
        return this.newCursorPosition == ((SetComposingTextCommand)object).newCursorPosition;
    }

    public int hashCode() {
        int n = this.getText().hashCode();
        n = 31 * n + this.newCursorPosition;
        return n;
    }

    public String toString() {
        return "SetComposingTextCommand(text='" + this.getText() + "', newCursorPosition=" + this.newCursorPosition + ")";
    }
}

