/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.MimesKt;
import io.ktor.util.CharsetKt;
import io.ktor.util.CollectionsKt;
import io.ktor.util.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\r\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0019\u0010\u0007\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\u0005\u001a\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0004\b\f\u0010\n\u001a\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0019\u0010\u000f\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\bH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u0013\u0010\u0014\u001a\u00020\u0003*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001aC\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u001a\"\u0004\b\u0000\u0010\u0016\"\u0004\b\u0001\u0010\u0017*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00190\u0018H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0013\u0010\u001d\u001a\u00020\u0003*\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001e\"-\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"-\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010 \u001a\u0004\b%\u0010\"\u00a8\u0006'"}, d2={"Lio/ktor/http/ContentType$Companion;", "", "extension", "Lio/ktor/http/ContentType;", "defaultForFileExtension", "(Lio/ktor/http/ContentType$Companion;Ljava/lang/String;)Lio/ktor/http/ContentType;", "path", "defaultForFilePath", "", "fromFilePath", "(Lio/ktor/http/ContentType$Companion;Ljava/lang/String;)Ljava/util/List;", "ext", "fromFileExtension", "fileExtensions", "(Lio/ktor/http/ContentType;)Ljava/util/List;", "selectDefault", "(Ljava/util/List;)Lio/ktor/http/ContentType;", "", "matchApplicationTypeWithCharset", "(Lio/ktor/http/ContentType;)Z", "withCharsetUTF8IfNeeded", "(Lio/ktor/http/ContentType;)Lio/ktor/http/ContentType;", "A", "B", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "groupByPairs", "(Lkotlin/sequences/Sequence;)Ljava/util/Map;", "toContentType", "(Ljava/lang/String;)Lio/ktor/http/ContentType;", "contentTypesByExtensions$delegate", "Lkotlin/Lazy;", "getContentTypesByExtensions", "()Ljava/util/Map;", "contentTypesByExtensions", "extensionsByContentType$delegate", "getExtensionsByContentType", "extensionsByContentType", "ktor-http"})
public final class FileContentTypeKt {
    private static final Lazy contentTypesByExtensions$delegate = LazyKt.lazy(FileContentTypeKt::contentTypesByExtensions_delegate$lambda$0);
    private static final Lazy extensionsByContentType$delegate = LazyKt.lazy(FileContentTypeKt::extensionsByContentType_delegate$lambda$0);

    public static final ContentType defaultForFileExtension(ContentType.Companion companion, String string) {
        Intrinsics.checkNotNullParameter((Object)companion, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFileExtension(ContentType.Companion, string));
    }

    public static final ContentType defaultForFilePath(ContentType.Companion companion, String string) {
        Intrinsics.checkNotNullParameter((Object)companion, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFilePath(ContentType.Companion, string));
    }

    public static final List<ContentType> fromFilePath(ContentType.Companion companion, String string) {
        Intrinsics.checkNotNullParameter((Object)companion, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = StringsKt.lastIndexOfAny$default((CharSequence)string, (char[])CharsetKt.toCharArray((String)"/\\"), (int)0, (boolean)false, (int)6, null);
        int n2 = StringsKt.indexOf$default((CharSequence)string, (char)'.', (int)(n + 1), (boolean)false, (int)4, null);
        if (n2 == -1) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        String string2 = string.substring(n2 + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return FileContentTypeKt.fromFileExtension(companion, string2);
    }

    public static final List<ContentType> fromFileExtension(ContentType.Companion companion, String string) {
        Intrinsics.checkNotNullParameter((Object)companion, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        String string2 = TextKt.toLowerCasePreservingASCIIRules((String)StringsKt.removePrefix((String)string, (CharSequence)"."));
        while (((CharSequence)string2).length() > 0) {
            List<ContentType> list = FileContentTypeKt.getContentTypesByExtensions().get(string2);
            if (list != null) {
                return list;
            }
            string2 = StringsKt.substringAfter((String)string2, (String)".", (String)"");
        }
        return kotlin.collections.CollectionsKt.emptyList();
    }

    public static final List<String> fileExtensions(ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"");
        List list = FileContentTypeKt.getExtensionsByContentType().get(contentType);
        if (list == null && (list = FileContentTypeKt.getExtensionsByContentType().get(contentType.withoutParameters())) == null) {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Map<String, List<ContentType>> getContentTypesByExtensions() {
        Lazy lazy = contentTypesByExtensions$delegate;
        return (Map)lazy.getValue();
    }

    private static final Map<ContentType, List<String>> getExtensionsByContentType() {
        Lazy lazy = extensionsByContentType$delegate;
        return (Map)lazy.getValue();
    }

    public static final ContentType selectDefault(List<ContentType> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        ContentType contentType = (ContentType)kotlin.collections.CollectionsKt.firstOrNull(list);
        if (contentType == null) {
            contentType = ContentType.Application.INSTANCE.getOctetStream();
        }
        ContentType contentType2 = contentType;
        return contentType2.match(ContentType.Text.INSTANCE.getAny()) ? FileContentTypeKt.withCharsetUTF8IfNeeded(contentType2) : (contentType2.match(ContentType.Image.INSTANCE.getSVG()) ? FileContentTypeKt.withCharsetUTF8IfNeeded(contentType2) : (FileContentTypeKt.matchApplicationTypeWithCharset(contentType2) ? FileContentTypeKt.withCharsetUTF8IfNeeded(contentType2) : contentType2));
    }

    private static final boolean matchApplicationTypeWithCharset(ContentType contentType) {
        if (!contentType.match(ContentType.Application.INSTANCE.getAny())) {
            return false;
        }
        return contentType.match(ContentType.Application.INSTANCE.getAtom()) || contentType.match(ContentType.Application.INSTANCE.getJavaScript()) || contentType.match(ContentType.Application.INSTANCE.getRss()) || contentType.match(ContentType.Application.INSTANCE.getXml()) || contentType.match(ContentType.Application.INSTANCE.getXml_Dtd());
    }

    private static final ContentType withCharsetUTF8IfNeeded(ContentType contentType) {
        if (ContentTypesKt.charset(contentType) != null) {
            return contentType;
        }
        return ContentTypesKt.withCharset(contentType, Charsets.UTF_8);
    }

    public static final <A, B> Map<A, List<B>> groupByPairs(Sequence<? extends Pair<? extends A, ? extends B>> sequence) {
        Object object;
        boolean bl;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        Intrinsics.checkNotNullParameter(sequence, (String)"");
        Object object6 = sequence;
        boolean bl2 = false;
        Sequence<? extends Pair<? extends A, ? extends B>> sequence2 = object6;
        Map map = new LinkedHashMap();
        boolean bl3 = false;
        for (Object object52 : sequence2) {
            Object object7;
            Object object8 = (Pair)object52;
            boolean bl4 = false;
            object4 = object8.getFirst();
            object3 = map;
            object2 = object4;
            bl = false;
            object = object3.get(object2);
            if (object == null) {
                boolean bl5 = false;
                List list = new ArrayList();
                object3.put(object2, list);
                object7 = list;
            } else {
                object7 = object;
            }
            object8 = (List)object7;
            object8.add(object52);
        }
        object6 = map;
        bl2 = false;
        sequence2 = object6;
        map = new LinkedHashMap(MapsKt.mapCapacity((int)object6.size()));
        bl3 = false;
        Iterable iterable = sequence2.entrySet();
        object52 = map;
        boolean bl6 = false;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            object3 = (Map.Entry)object4;
            object2 = object52;
            bl = false;
            object = (Map.Entry)object4;
            Object k = object3.getKey();
            Object object9 = object2;
            boolean bl7 = false;
            Iterable iterable2 = (Iterable)object.getValue();
            boolean bl8 = false;
            Iterable iterable3 = iterable2;
            Collection collection = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            boolean bl9 = false;
            for (Object t : iterable3) {
                Pair pair = (Pair)t;
                Collection collection2 = collection;
                boolean bl10 = false;
                collection2.add(pair.getSecond());
            }
            List list = (List)collection;
            object9.put(k, list);
        }
        return object52;
    }

    public static final ContentType toContentType(String string) {
        ContentType contentType;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            contentType = ContentType.Companion.parse(string);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Failed to parse " + string, throwable);
        }
        return contentType;
    }

    private static final Map contentTypesByExtensions_delegate$lambda$0() {
        Map map;
        Map map2 = map = CollectionsKt.caseInsensitiveMap();
        boolean bl = false;
        map2.putAll(FileContentTypeKt.groupByPairs(kotlin.collections.CollectionsKt.asSequence((Iterable)MimesKt.getMimes())));
        return map;
    }

    private static final Map extensionsByContentType_delegate$lambda$0() {
        return FileContentTypeKt.groupByPairs(SequencesKt.map((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)MimesKt.getMimes()), FileContentTypeKt::extensionsByContentType_delegate$lambda$0$0));
    }

    private static final Pair extensionsByContentType_delegate$lambda$0$0(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"");
        String string = (String)pair.component1();
        ContentType contentType = (ContentType)pair.component2();
        return TuplesKt.to((Object)contentType, (Object)string);
    }
}

