/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.auth;

import io.ktor.http.CookieUtilsKt;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.http.parsing.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a-\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0002\u00a2\u0006\u0004\b\u0003\u0010\f\u001a7\u0010\u000f\u001a\u0004\u0018\u00010\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a3\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a3\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014\u001a\u001f\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0013\u0010\u0018\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a#\u0010\u001c\u001a\u00020\b*\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a\u001b\u0010\u001e\u001a\u00020\b*\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0017\u001a\u0013\u0010 \u001a\u00020\u001f*\u00020\u001aH\u0002\u00a2\u0006\u0004\b \u0010!\u001a\u0013\u0010\"\u001a\u00020\u001f*\u00020\u001aH\u0002\u00a2\u0006\u0004\b\"\u0010!\"\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\"\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010%\"\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\"\u0014\u0010*\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010)\u00a8\u0006+"}, d2={"", "headerValue", "Lio/ktor/http/auth/HttpAuthHeader;", "parseAuthorizationHeader", "(Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader;", "", "parseAuthorizationHeaders", "(Ljava/lang/String;)Ljava/util/List;", "", "startIndex", "", "headers", "(Ljava/lang/String;ILjava/util/List;)I", "header", "index", "nextChallengeIndex", "(Ljava/util/List;Lio/ktor/http/auth/HttpAuthHeader;ILjava/lang/String;)Ljava/lang/Integer;", "", "parameters", "matchParameters", "(Ljava/lang/String;ILjava/util/Map;)I", "matchParameter", "matchToken68", "(Ljava/lang/String;I)I", "unescaped", "(Ljava/lang/String;)Ljava/lang/String;", "", "delimiter", "skipDelimiter", "(Ljava/lang/String;IC)I", "skipSpaces", "", "isToken68", "(C)Z", "isToken", "", "TOKEN_EXTRA", "Ljava/util/Set;", "TOKEN68_EXTRA", "Lkotlin/text/Regex;", "token68Pattern", "Lkotlin/text/Regex;", "escapeRegex", "ktor-http"})
public final class HttpAuthHeaderKt {
    private static final Set<Character> TOKEN_EXTRA;
    private static final Set<Character> TOKEN68_EXTRA;
    private static final Regex token68Pattern;
    private static final Regex escapeRegex;

    public static final HttpAuthHeader parseAuthorizationHeader(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = 0;
        int n2 = n = HttpAuthHeaderKt.skipSpaces(string, n);
        while (n < string.length() && HttpAuthHeaderKt.isToken(string.charAt(n))) {
            ++n;
        }
        String string2 = StringsKt.substring((String)string, (IntRange)RangesKt.until((int)n2, (int)n));
        n = HttpAuthHeaderKt.skipSpaces(string, n);
        if (StringsKt.isBlank((CharSequence)string2)) {
            return null;
        }
        if (string.length() == n) {
            return new HttpAuthHeader.Parameterized(string2, CollectionsKt.emptyList(), null, 4, null);
        }
        int n3 = HttpAuthHeaderKt.matchToken68(string, n);
        String string3 = ((Object)StringsKt.trim((CharSequence)StringsKt.substring((String)string, (IntRange)RangesKt.until((int)n, (int)n3)))).toString();
        if (((CharSequence)string3).length() > 0 && n3 == string.length()) {
            return new HttpAuthHeader.Single(string2, string3);
        }
        Map map = new LinkedHashMap();
        int n4 = HttpAuthHeaderKt.matchParameters(string, n, map);
        if (n4 != -1) {
            throw new ParseException("Function parseAuthorizationHeader can parse only one header", null, 2, null);
        }
        return new HttpAuthHeader.Parameterized(string2, map, null, 4, null);
    }

    public static final List<HttpAuthHeader> parseAuthorizationHeaders(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = 0;
        List list = new ArrayList();
        while (n != -1) {
            n = HttpAuthHeaderKt.parseAuthorizationHeader(string, n, list);
        }
        return list;
    }

    private static final int parseAuthorizationHeader(String string, int n, List<HttpAuthHeader> list) {
        Object object;
        int n2;
        int n3 = n2 = HttpAuthHeaderKt.skipSpaces(string, n);
        while (n2 < string.length() && HttpAuthHeaderKt.isToken(string.charAt(n2))) {
            ++n2;
        }
        String string2 = StringsKt.substring((String)string, (IntRange)RangesKt.until((int)n3, (int)n2));
        if (StringsKt.isBlank((CharSequence)string2)) {
            throw new ParseException("Invalid authScheme value: it should be token, can't be blank", null, 2, null);
        }
        n2 = HttpAuthHeaderKt.skipSpaces(string, n2);
        Integer n4 = HttpAuthHeaderKt.nextChallengeIndex(list, new HttpAuthHeader.Parameterized(string2, CollectionsKt.emptyList(), null, 4, null), n2, string);
        if (n4 != null) {
            int n5 = ((Number)n4).intValue();
            boolean bl = false;
            return n5;
        }
        int n6 = HttpAuthHeaderKt.matchToken68(string, n2);
        String string3 = ((Object)StringsKt.trim((CharSequence)StringsKt.substring((String)string, (IntRange)RangesKt.until((int)n2, (int)n6)))).toString();
        if (((CharSequence)string3).length() > 0 && (object = HttpAuthHeaderKt.nextChallengeIndex(list, new HttpAuthHeader.Single(string2, string3), n6, string)) != null) {
            int n7 = ((Number)object).intValue();
            boolean bl = false;
            return n7;
        }
        object = new LinkedHashMap();
        int n8 = HttpAuthHeaderKt.matchParameters(string, n2, (Map<String, String>)object);
        list.add(new HttpAuthHeader.Parameterized(string2, (Map)object, null, 4, null));
        return n8;
    }

    private static final Integer nextChallengeIndex(List<HttpAuthHeader> list, HttpAuthHeader httpAuthHeader, int n, String string) {
        if (n == string.length() || string.charAt(n) == ',') {
            Integer n2;
            list.add(httpAuthHeader);
            if (n == string.length()) {
                n2 = -1;
            } else if (string.charAt(n) == ',') {
                n2 = n + 1;
            } else {
                throw new IllegalStateException("".toString());
            }
            return n2;
        }
        return null;
    }

    private static final int matchParameters(String string, int n, Map<String, String> map) {
        int n2 = n;
        while (n2 > 0 && n2 < string.length()) {
            int n3 = HttpAuthHeaderKt.matchParameter(string, n2, map);
            if (n3 == n2) {
                return n2;
            }
            n2 = HttpAuthHeaderKt.skipDelimiter(string, n3, ',');
        }
        return n2;
    }

    private static final int matchParameter(String string, int n, Map<String, String> map) {
        int n2;
        int n3;
        for (n3 = n2 = HttpAuthHeaderKt.skipSpaces(string, n); n3 < string.length() && HttpAuthHeaderKt.isToken(string.charAt(n3)); ++n3) {
        }
        String string2 = StringsKt.substring((String)string, (IntRange)RangesKt.until((int)n2, (int)n3));
        if ((n3 = HttpAuthHeaderKt.skipSpaces(string, n3)) == string.length() || string.charAt(n3) != '=') {
            return n;
        }
        ++n3;
        boolean bl = false;
        int n4 = n3;
        if (string.charAt(n3) == '\"') {
            bl = true;
            n4 = ++n3;
            boolean bl2 = false;
            while (n3 < string.length() && (string.charAt(n3) != '\"' || bl2)) {
                bl2 = !bl2 && string.charAt(n3) == '\\';
                ++n3;
            }
            if (n3 == string.length()) {
                throw new ParseException("Expected closing quote'\"' in parameter", null, 2, null);
            }
        } else {
            for (n3 = HttpAuthHeaderKt.skipSpaces(string, n3); n3 < string.length() && string.charAt(n3) != ' ' && string.charAt(n3) != ','; ++n3) {
            }
        }
        String string3 = StringsKt.substring((String)string, (IntRange)RangesKt.until((int)n4, (int)n3));
        map.put(string2, bl ? HttpAuthHeaderKt.unescaped(string3) : string3);
        if (bl) {
            ++n3;
        }
        return n3;
    }

    private static final int matchToken68(String string, int n) {
        int n2;
        for (n2 = HttpAuthHeaderKt.skipSpaces(string, n); n2 < string.length() && HttpAuthHeaderKt.isToken68(string.charAt(n2)); ++n2) {
        }
        while (n2 < string.length() && string.charAt(n2) == '=') {
            ++n2;
        }
        return HttpAuthHeaderKt.skipSpaces(string, n2);
    }

    private static final String unescaped(String string) {
        CharSequence charSequence = string;
        Regex regex = escapeRegex;
        Function1 function1 = HttpAuthHeaderKt::unescaped$lambda$0;
        return regex.replace(charSequence, function1);
    }

    private static final int skipDelimiter(String string, int n, char c) {
        int n2 = HttpAuthHeaderKt.skipSpaces(string, n);
        if (n2 == string.length()) {
            return -1;
        }
        if (string.charAt(n2) != c) {
            throw new ParseException("Expected delimiter " + c + " at position " + n2, null, 2, null);
        }
        return HttpAuthHeaderKt.skipSpaces(string, ++n2);
    }

    private static final int skipSpaces(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length() && string.charAt(n2) == ' '; ++n2) {
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isToken68(char c) {
        boolean bl;
        boolean bl2;
        if ('a' <= c) {
            if (c < '{') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= c) {
            if (c < '[') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (CookieUtilsKt.isDigit(c)) return true;
        if (!TOKEN68_EXTRA.contains(Character.valueOf(c))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isToken(char c) {
        boolean bl;
        boolean bl2;
        if ('a' <= c) {
            if (c < '{') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= c) {
            if (c < '[') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (CookieUtilsKt.isDigit(c)) return true;
        if (!TOKEN_EXTRA.contains(Character.valueOf(c))) return false;
        return true;
    }

    private static final CharSequence unescaped$lambda$0(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"");
        return StringsKt.takeLast((String)matchResult.getValue(), (int)1);
    }

    public static final /* synthetic */ Regex access$getToken68Pattern$p() {
        return token68Pattern;
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('|'), Character.valueOf('~')};
        TOKEN_EXTRA = SetsKt.setOf((Object[])objectArray);
        objectArray = new Character[]{Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~'), Character.valueOf('+'), Character.valueOf('/')};
        TOKEN68_EXTRA = SetsKt.setOf((Object[])objectArray);
        token68Pattern = new Regex("[a-zA-Z0-9\\-._~+/]+=*");
        escapeRegex = new Regex("\\\\.");
    }
}

