/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.encoder.JsonEscapeUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;

public class JsonEncoder
extends EncoderBase<ILoggingEvent> {
    static final boolean DO_NOT_ADD_QUOTE_KEY = false;
    static final boolean ADD_QUOTE_KEY = true;
    static int DEFAULT_SIZE = 1024;
    static int DEFAULT_SIZE_WITH_THROWABLE = DEFAULT_SIZE * 8;
    static byte[] EMPTY_BYTES = new byte[0];
    public static final String CONTEXT_ATTR_NAME = "context";
    public static final String NAME_ATTR_NAME = "name";
    public static final String BIRTHDATE_ATTR_NAME = "birthdate";
    public static final String CONTEXT_PROPERTIES_ATTR_NAME = "properties";
    public static final String TIMESTAMP_ATTR_NAME = "timestamp";
    public static final String NANOSECONDS_ATTR_NAME = "nanoseconds";
    public static final String SEQUENCE_NUMBER_ATTR_NAME = "sequenceNumber";
    public static final String LEVEL_ATTR_NAME = "level";
    public static final String MARKERS_ATTR_NAME = "markers";
    public static final String THREAD_NAME_ATTR_NAME = "threadName";
    public static final String MDC_ATTR_NAME = "mdc";
    public static final String LOGGER_ATTR_NAME = "loggerName";
    public static final String MESSAGE_ATTR_NAME = "message";
    public static final String FORMATTED_MESSAGE_ATTR_NAME = "formattedMessage";
    public static final String ARGUMENT_ARRAY_ATTR_NAME = "arguments";
    public static final String KEY_VALUE_PAIRS_ATTR_NAME = "kvpList";
    public static final String THROWABLE_ATTR_NAME = "throwable";
    private static final String CYCLIC_THROWABLE_ATTR_NAME = "cyclic";
    public static final String CAUSE_ATTR_NAME = "cause";
    public static final String SUPPRESSED_ATTR_NAME = "suppressed";
    public static final String COMMON_FRAMES_COUNT_ATTR_NAME = "commonFramesCount";
    public static final String CLASS_NAME_ATTR_NAME = "className";
    public static final String METHOD_NAME_ATTR_NAME = "methodName";
    private static final String FILE_NAME_ATTR_NAME = "fileName";
    private static final String LINE_NUMBER_ATTR_NAME = "lineNumber";
    public static final String STEP_ARRAY_NAME_ATTRIBUTE = "stepArray";
    private static final char OPEN_OBJ = '{';
    private static final char CLOSE_OBJ = '}';
    private static final char OPEN_ARRAY = '[';
    private static final char CLOSE_ARRAY = ']';
    private static final char QUOTE = '\"';
    private static final char SP = ' ';
    private static final char ENTRY_SEPARATOR = ':';
    private static final String COL_SP = ": ";
    private static final String QUOTE_COL = "\":";
    private static final char VALUE_SEPARATOR = ',';
    private boolean withSequenceNumber = true;
    private boolean withTimestamp = true;
    private boolean withNanoseconds = true;
    private boolean withLevel = true;
    private boolean withThreadName = true;
    private boolean withLoggerName = true;
    private boolean withContext = true;
    private boolean withMarkers = true;
    private boolean withMDC = true;
    private boolean withKVPList = true;
    private boolean withMessage = true;
    private boolean withArguments = true;
    private boolean withThrowable = true;
    private boolean withFormattedMessage = false;

    public byte[] headerBytes() {
        return EMPTY_BYTES;
    }

    public byte[] encode(ILoggingEvent iLoggingEvent) {
        int n = iLoggingEvent.getThrowableProxy() == null ? DEFAULT_SIZE : DEFAULT_SIZE_WITH_THROWABLE;
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append('{');
        if (this.withSequenceNumber) {
            this.appenderMemberWithLongValue(stringBuilder, SEQUENCE_NUMBER_ATTR_NAME, iLoggingEvent.getSequenceNumber());
            stringBuilder.append(',');
        }
        if (this.withTimestamp) {
            this.appenderMemberWithLongValue(stringBuilder, TIMESTAMP_ATTR_NAME, iLoggingEvent.getTimeStamp());
            stringBuilder.append(',');
        }
        if (this.withNanoseconds) {
            this.appenderMemberWithLongValue(stringBuilder, NANOSECONDS_ATTR_NAME, iLoggingEvent.getNanoseconds());
            stringBuilder.append(',');
        }
        if (this.withLevel) {
            String string = iLoggingEvent.getLevel() != null ? iLoggingEvent.getLevel().levelStr : "null";
            this.appenderMember(stringBuilder, LEVEL_ATTR_NAME, string);
            stringBuilder.append(',');
        }
        if (this.withThreadName) {
            this.appenderMember(stringBuilder, THREAD_NAME_ATTR_NAME, this.jsonEscape(iLoggingEvent.getThreadName()));
            stringBuilder.append(',');
        }
        if (this.withLoggerName) {
            this.appenderMember(stringBuilder, LOGGER_ATTR_NAME, iLoggingEvent.getLoggerName());
            stringBuilder.append(',');
        }
        if (this.withContext) {
            this.appendLoggerContext(stringBuilder, iLoggingEvent.getLoggerContextVO());
            stringBuilder.append(',');
        }
        if (this.withMarkers) {
            this.appendMarkers(stringBuilder, iLoggingEvent);
        }
        if (this.withMDC) {
            this.appendMDC(stringBuilder, iLoggingEvent);
        }
        if (this.withKVPList) {
            this.appendKeyValuePairs(stringBuilder, iLoggingEvent);
        }
        if (this.withMessage) {
            this.appenderMember(stringBuilder, MESSAGE_ATTR_NAME, this.jsonEscape(iLoggingEvent.getMessage()));
            stringBuilder.append(',');
        }
        if (this.withFormattedMessage) {
            this.appenderMember(stringBuilder, FORMATTED_MESSAGE_ATTR_NAME, this.jsonEscape(iLoggingEvent.getFormattedMessage()));
            stringBuilder.append(',');
        }
        if (this.withArguments) {
            this.appendArgumentArray(stringBuilder, iLoggingEvent);
        }
        if (this.withThrowable) {
            this.appendThrowableProxy(stringBuilder, THROWABLE_ATTR_NAME, iLoggingEvent.getThrowableProxy());
        }
        stringBuilder.append('}');
        stringBuilder.append('\n');
        return stringBuilder.toString().getBytes(CoreConstants.UTF_8_CHARSET);
    }

    private void appendLoggerContext(StringBuilder stringBuilder, LoggerContextVO loggerContextVO) {
        stringBuilder.append('\"').append(CONTEXT_ATTR_NAME).append(QUOTE_COL);
        if (loggerContextVO == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append('{');
        this.appenderMember(stringBuilder, NAME_ATTR_NAME, this.nullSafeStr(loggerContextVO.getName()));
        stringBuilder.append(',');
        this.appenderMemberWithLongValue(stringBuilder, BIRTHDATE_ATTR_NAME, loggerContextVO.getBirthTime());
        stringBuilder.append(',');
        this.appendMap(stringBuilder, CONTEXT_PROPERTIES_ATTR_NAME, loggerContextVO.getPropertyMap());
        stringBuilder.append('}');
    }

    private void appendMap(StringBuilder stringBuilder, String string, Map<String, String> map) {
        stringBuilder.append('\"').append(string).append(QUOTE_COL);
        if (map == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append('{');
        boolean bl = false;
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (bl) {
                stringBuilder.append(',');
            }
            bl = true;
            this.appenderMember(stringBuilder, this.jsonEscapedToString(entry.getKey()), this.jsonEscapedToString(entry.getValue()));
        }
        stringBuilder.append('}');
    }

    private void appendThrowableProxy(StringBuilder stringBuilder, String string, IThrowableProxy iThrowableProxy) {
        IThrowableProxy[] iThrowableProxyArray;
        IThrowableProxy iThrowableProxy2;
        if (string != null) {
            stringBuilder.append('\"').append(string).append(QUOTE_COL);
            if (iThrowableProxy == null) {
                stringBuilder.append("null");
                return;
            }
        }
        stringBuilder.append('{');
        this.appenderMember(stringBuilder, CLASS_NAME_ATTR_NAME, this.nullSafeStr(iThrowableProxy.getClassName()));
        stringBuilder.append(',');
        this.appenderMember(stringBuilder, MESSAGE_ATTR_NAME, this.jsonEscape(iThrowableProxy.getMessage()));
        if (iThrowableProxy.isCyclic()) {
            stringBuilder.append(',');
            this.appenderMember(stringBuilder, CYCLIC_THROWABLE_ATTR_NAME, this.jsonEscape("true"));
        }
        stringBuilder.append(',');
        this.appendSTEPArray(stringBuilder, iThrowableProxy.getStackTraceElementProxyArray(), iThrowableProxy.getCommonFrames());
        if (iThrowableProxy.getCommonFrames() != 0) {
            stringBuilder.append(',');
            this.appenderMemberWithIntValue(stringBuilder, COMMON_FRAMES_COUNT_ATTR_NAME, iThrowableProxy.getCommonFrames());
        }
        if ((iThrowableProxy2 = iThrowableProxy.getCause()) != null) {
            stringBuilder.append(',');
            this.appendThrowableProxy(stringBuilder, CAUSE_ATTR_NAME, iThrowableProxy2);
        }
        if ((iThrowableProxyArray = iThrowableProxy.getSuppressed()) != null && iThrowableProxyArray.length != 0) {
            stringBuilder.append(',');
            stringBuilder.append('\"').append(SUPPRESSED_ATTR_NAME).append(QUOTE_COL);
            stringBuilder.append('[');
            boolean bl = true;
            for (IThrowableProxy iThrowableProxy3 : iThrowableProxyArray) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                this.appendThrowableProxy(stringBuilder, null, iThrowableProxy3);
            }
            stringBuilder.append(']');
        }
        stringBuilder.append('}');
    }

    private void appendSTEPArray(StringBuilder stringBuilder, StackTraceElementProxy[] stackTraceElementProxyArray, int n) {
        int n2;
        stringBuilder.append('\"').append(STEP_ARRAY_NAME_ATTRIBUTE).append(QUOTE_COL).append('[');
        int n3 = n2 = stackTraceElementProxyArray != null ? stackTraceElementProxyArray.length : 0;
        if (n >= n2) {
            n = 0;
        }
        for (int i = 0; i < n2 - n; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[i];
            stringBuilder.append('{');
            StackTraceElement stackTraceElement = stackTraceElementProxy.getStackTraceElement();
            this.appenderMember(stringBuilder, CLASS_NAME_ATTR_NAME, this.nullSafeStr(stackTraceElement.getClassName()));
            stringBuilder.append(',');
            this.appenderMember(stringBuilder, METHOD_NAME_ATTR_NAME, this.nullSafeStr(stackTraceElement.getMethodName()));
            stringBuilder.append(',');
            this.appenderMember(stringBuilder, FILE_NAME_ATTR_NAME, this.nullSafeStr(stackTraceElement.getFileName()));
            stringBuilder.append(',');
            this.appenderMemberWithIntValue(stringBuilder, LINE_NUMBER_ATTR_NAME, stackTraceElement.getLineNumber());
            stringBuilder.append('}');
        }
        stringBuilder.append(']');
    }

    private void appenderMember(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append('\"').append(string).append(QUOTE_COL).append('\"').append(string2).append('\"');
    }

    private void appenderMemberWithIntValue(StringBuilder stringBuilder, String string, int n) {
        stringBuilder.append('\"').append(string).append(QUOTE_COL).append(n);
    }

    private void appenderMemberWithLongValue(StringBuilder stringBuilder, String string, long l) {
        stringBuilder.append('\"').append(string).append(QUOTE_COL).append(l);
    }

    private void appendKeyValuePairs(StringBuilder stringBuilder, ILoggingEvent iLoggingEvent) {
        List<KeyValuePair> list = iLoggingEvent.getKeyValuePairs();
        if (list == null || list.isEmpty()) {
            return;
        }
        stringBuilder.append('\"').append(KEY_VALUE_PAIRS_ATTR_NAME).append(QUOTE_COL).append(' ').append('[');
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            KeyValuePair keyValuePair = list.get(i);
            stringBuilder.append('{');
            this.appenderMember(stringBuilder, this.jsonEscapedToString(keyValuePair.key), this.jsonEscapedToString(keyValuePair.value));
            stringBuilder.append('}');
        }
        stringBuilder.append(']');
        stringBuilder.append(',');
    }

    private void appendArgumentArray(StringBuilder stringBuilder, ILoggingEvent iLoggingEvent) {
        Object[] objectArray = iLoggingEvent.getArgumentArray();
        if (objectArray == null) {
            return;
        }
        stringBuilder.append('\"').append(ARGUMENT_ARRAY_ATTR_NAME).append(QUOTE_COL).append(' ').append('[');
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"').append(this.jsonEscapedToString(objectArray[i])).append('\"');
        }
        stringBuilder.append(']');
        stringBuilder.append(',');
    }

    private void appendMarkers(StringBuilder stringBuilder, ILoggingEvent iLoggingEvent) {
        List<Marker> list = iLoggingEvent.getMarkerList();
        if (list == null) {
            return;
        }
        stringBuilder.append('\"').append(MARKERS_ATTR_NAME).append(QUOTE_COL).append(' ').append('[');
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"').append(this.jsonEscapedToString(list.get(i))).append('\"');
        }
        stringBuilder.append(']');
        stringBuilder.append(',');
    }

    private String jsonEscapedToString(Object object) {
        if (object == null) {
            return "null";
        }
        return JsonEscapeUtil.jsonEscapeString((String)object.toString());
    }

    private String nullSafeStr(String string) {
        if (string == null) {
            return "null";
        }
        return string;
    }

    private String jsonEscape(String string) {
        if (string == null) {
            return "null";
        }
        return JsonEscapeUtil.jsonEscapeString((String)string);
    }

    private void appendMDC(StringBuilder stringBuilder, ILoggingEvent iLoggingEvent) {
        Map<String, String> map = iLoggingEvent.getMDCPropertyMap();
        stringBuilder.append('\"').append(MDC_ATTR_NAME).append(QUOTE_COL).append(' ').append('{');
        if (this.isNotEmptyMap(map)) {
            Set<Map.Entry<String, String>> set = map.entrySet();
            int n = 0;
            for (Map.Entry<String, String> entry : set) {
                if (n != 0) {
                    stringBuilder.append(',');
                }
                this.appenderMember(stringBuilder, this.jsonEscapedToString(entry.getKey()), this.jsonEscapedToString(entry.getValue()));
                ++n;
            }
        }
        stringBuilder.append('}');
        stringBuilder.append(',');
    }

    boolean isNotEmptyMap(Map map) {
        if (map == null) {
            return false;
        }
        return !map.isEmpty();
    }

    public byte[] footerBytes() {
        return EMPTY_BYTES;
    }

    public void setWithSequenceNumber(boolean bl) {
        this.withSequenceNumber = bl;
    }

    public void setWithTimestamp(boolean bl) {
        this.withTimestamp = bl;
    }

    public void setWithNanoseconds(boolean bl) {
        this.withNanoseconds = bl;
    }

    public void setWithLevel(boolean bl) {
        this.withLevel = bl;
    }

    public void setWithThreadName(boolean bl) {
        this.withThreadName = bl;
    }

    public void setWithLoggerName(boolean bl) {
        this.withLoggerName = bl;
    }

    public void setWithContext(boolean bl) {
        this.withContext = bl;
    }

    public void setWithMarkers(boolean bl) {
        this.withMarkers = bl;
    }

    public void setWithMDC(boolean bl) {
        this.withMDC = bl;
    }

    public void setWithKVPList(boolean bl) {
        this.withKVPList = bl;
    }

    public void setWithMessage(boolean bl) {
        this.withMessage = bl;
    }

    public void setWithArguments(boolean bl) {
        this.withArguments = bl;
    }

    public void setWithThrowable(boolean bl) {
        this.withThrowable = bl;
    }

    public void setWithFormattedMessage(boolean bl) {
        this.withFormattedMessage = bl;
    }
}

