/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.sanity;

import ch.qos.logback.classic.model.LoggerModel;
import ch.qos.logback.classic.model.RootLoggerModel;
import ch.qos.logback.core.joran.sanity.Pair;
import ch.qos.logback.core.joran.sanity.SanityChecker;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.conditional.IfModel;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.util.ArrayList;
import java.util.List;

public class IfNestedWithinSecondPhaseElementSC
extends ContextAwareBase
implements SanityChecker {
    public static final String NESTED_IF_WARNING_URL = "http://logback.qos.ch/codes.html#nested_if_element";

    public void check(Model model) {
        if (model == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.deepFindAllModelsOfType(AppenderModel.class, arrayList, model);
        this.deepFindAllModelsOfType(LoggerModel.class, arrayList, model);
        this.deepFindAllModelsOfType(RootLoggerModel.class, arrayList, model);
        List list = this.deepFindNestedSubModelsOfType(IfModel.class, arrayList);
        if (list.isEmpty()) {
            return;
        }
        this.addWarn("<if> elements cannot be nested within an <appender>, <logger> or <root> element");
        this.addWarn("See also http://logback.qos.ch/codes.html#nested_if_element");
        for (Pair pair : list) {
            Model model2 = (Model)pair.first;
            int n = model2.getLineNumber();
            Model model3 = (Model)pair.second;
            int n2 = model3.getLineNumber();
            this.addWarn("Element <" + model2.getTag() + "> at line " + n + " contains a nested <" + model3.getTag() + "> element at line " + n2);
        }
    }

    public String toString() {
        return "IfNestedWithinSecondPhaseElementSC";
    }
}

