/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.layout;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.util.List;
import org.slf4j.event.KeyValuePair;

public class TTLLLayout
extends LayoutBase<ILoggingEvent> {
    CachingDateFormatter cachingDateFormatter = new CachingDateFormatter("HH:mm:ss.SSS");
    ThrowableProxyConverter tpc = new ThrowableProxyConverter();
    static final char DOUBLE_QUOTE_CHAR = '\"';

    public void start() {
        this.tpc.start();
        super.start();
    }

    public String doLayout(ILoggingEvent iLoggingEvent) {
        if (!this.isStarted()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        long l = iLoggingEvent.getTimeStamp();
        stringBuilder.append(this.cachingDateFormatter.format(l));
        stringBuilder.append(" [");
        stringBuilder.append(iLoggingEvent.getThreadName());
        stringBuilder.append("] ");
        stringBuilder.append(iLoggingEvent.getLevel().toString());
        stringBuilder.append(" ");
        stringBuilder.append(iLoggingEvent.getLoggerName());
        stringBuilder.append(" -");
        this.kvp(iLoggingEvent, stringBuilder);
        stringBuilder.append("- ");
        stringBuilder.append(iLoggingEvent.getFormattedMessage());
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        IThrowableProxy iThrowableProxy = iLoggingEvent.getThrowableProxy();
        if (iThrowableProxy != null) {
            String string = this.tpc.convert(iLoggingEvent);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void kvp(ILoggingEvent iLoggingEvent, StringBuilder stringBuilder) {
        List<KeyValuePair> list = iLoggingEvent.getKeyValuePairs();
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            KeyValuePair keyValuePair = list.get(i);
            if (i != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(String.valueOf(keyValuePair.key));
            stringBuilder.append('=');
            stringBuilder.append('\"');
            stringBuilder.append(String.valueOf(keyValuePair.value));
            stringBuilder.append('\"');
        }
    }
}

