/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.MDCValueLevelPair;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class DynamicThresholdFilter
extends TurboFilter {
    private Map<String, Level> valueLevelMap = new HashMap<String, Level>();
    private Level defaultThreshold = Level.ERROR;
    private String key;
    private FilterReply onHigherOrEqual = FilterReply.NEUTRAL;
    private FilterReply onLower = FilterReply.DENY;

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public Level getDefaultThreshold() {
        return this.defaultThreshold;
    }

    public void setDefaultThreshold(Level level) {
        this.defaultThreshold = level;
    }

    public FilterReply getOnHigherOrEqual() {
        return this.onHigherOrEqual;
    }

    public void setOnHigherOrEqual(FilterReply filterReply) {
        this.onHigherOrEqual = filterReply;
    }

    public FilterReply getOnLower() {
        return this.onLower;
    }

    public void setOnLower(FilterReply filterReply) {
        this.onLower = filterReply;
    }

    public void addMDCValueLevelPair(MDCValueLevelPair mDCValueLevelPair) {
        if (this.valueLevelMap.containsKey(mDCValueLevelPair.getValue())) {
            this.addError(mDCValueLevelPair.getValue() + " has been already set");
        } else {
            this.valueLevelMap.put(mDCValueLevelPair.getValue(), mDCValueLevelPair.getLevel());
        }
    }

    @Override
    public void start() {
        if (this.key == null) {
            this.addError("No key name was specified");
        }
        super.start();
    }

    @Override
    public FilterReply decide(Marker marker, Logger logger, Level level, String string, Object[] objectArray, Throwable throwable) {
        String string2 = MDC.get((String)this.key);
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        Level level2 = null;
        if (string2 != null) {
            level2 = this.valueLevelMap.get(string2);
        }
        if (level2 == null) {
            level2 = this.defaultThreshold;
        }
        if (level.isGreaterOrEqual(level2)) {
            return this.onHigherOrEqual;
        }
        return this.onLower;
    }
}

