/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ConfiguratorRank;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

@ConfiguratorRank(value=0)
public class DefaultJoranConfigurator
extends ContextAwareBase
implements Configurator {
    @Override
    public Configurator.ExecutionStatus configure(LoggerContext loggerContext) {
        URL uRL = this.performMultiStepConfigurationFileSearch(true);
        if (uRL != null) {
            try {
                this.configureByResource(uRL);
            }
            catch (JoranException joranException) {
                joranException.printStackTrace();
            }
            return Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
        }
        return Configurator.ExecutionStatus.INVOKE_NEXT_IF_ANY;
    }

    private URL performMultiStepConfigurationFileSearch(boolean bl) {
        ClassLoader classLoader = Loader.getClassLoaderOfObject((Object)this);
        URL uRL = this.findConfigFileURLFromSystemProperties(classLoader, bl);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.getResource("logback-test.xml", classLoader, bl);
        if (uRL != null) {
            return uRL;
        }
        return this.getResource("logback.xml", classLoader, bl);
    }

    public void configureByResource(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        String string = uRL.toString();
        if (!string.endsWith("xml")) {
            throw new LogbackException("Unexpected filename extension of file [" + uRL.toString() + "]. Should be .xml");
        }
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.context);
        joranConfigurator.doConfigure(uRL);
    }

    public URL findURLOfDefaultConfigurationFile(boolean bl) {
        return this.performMultiStepConfigurationFileSearch(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL findConfigFileURLFromSystemProperties(ClassLoader classLoader, boolean bl) {
        String string = OptionHelper.getSystemProperty((String)"logback.configurationFile");
        if (string != null) {
            URL uRL = null;
            try {
                URL uRL2 = uRL = new URL(string);
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                uRL = Loader.getResource((String)string, (ClassLoader)classLoader);
                if (uRL != null) {
                    URL uRL3 = uRL;
                    return uRL3;
                }
                File file = new File(string);
                if (file.exists() && file.isFile()) {
                    try {
                        URL uRL4 = uRL = file.toURI().toURL();
                        return uRL4;
                    }
                    catch (MalformedURLException malformedURLException2) {}
                }
            }
            finally {
                if (bl) {
                    this.statusOnResourceSearch(string, classLoader, uRL);
                }
            }
        }
        return null;
    }

    private URL getResource(String string, ClassLoader classLoader, boolean bl) {
        URL uRL = Loader.getResource((String)string, (ClassLoader)classLoader);
        if (bl) {
            this.statusOnResourceSearch(string, classLoader, uRL);
        }
        return uRL;
    }

    private void statusOnResourceSearch(String string, ClassLoader classLoader, URL uRL) {
        StatusManager statusManager = this.context.getStatusManager();
        if (uRL == null) {
            statusManager.add((Status)new InfoStatus("Could NOT find resource [" + string + "]", (Object)this.context));
        } else {
            statusManager.add((Status)new InfoStatus("Found resource [" + string + "] at [" + uRL.toString() + "]", (Object)this.context));
            this.multiplicityWarning(string, classLoader);
        }
    }

    private void multiplicityWarning(String string, ClassLoader classLoader) {
        Set set = null;
        try {
            set = Loader.getResources((String)string, (ClassLoader)classLoader);
        }
        catch (IOException iOException) {
            this.addError("Failed to get url list for resource [" + string + "]", iOException);
        }
        if (set != null && set.size() > 1) {
            this.addWarn("Resource [" + string + "] occurs multiple times on the classpath.");
            for (URL uRL : set) {
                this.addWarn("Resource [" + string + "] occurs at [" + uRL.toString() + "]");
            }
        }
    }
}

