/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.blocking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.e.a.i;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.blocking.AllJidsUnblockedListener;
import org.jivesoftware.smackx.blocking.JidsBlockedListener;
import org.jivesoftware.smackx.blocking.JidsUnblockedListener;
import org.jivesoftware.smackx.blocking.element.BlockContactsIQ;
import org.jivesoftware.smackx.blocking.element.BlockListIQ;
import org.jivesoftware.smackx.blocking.element.UnblockContactsIQ;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public final class BlockingCommandManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:blocking";
    private volatile List<i> blockListCached;
    private static final Map<XMPPConnection, BlockingCommandManager> INSTANCES;
    private final Set<AllJidsUnblockedListener> allJidsUnblockedListeners = new CopyOnWriteArraySet<AllJidsUnblockedListener>();
    private final Set<JidsBlockedListener> jidsBlockedListeners = new CopyOnWriteArraySet<JidsBlockedListener>();
    private final Set<JidsUnblockedListener> jidsUnblockedListeners = new CopyOnWriteArraySet<JidsUnblockedListener>();

    public static synchronized BlockingCommandManager getInstanceFor(XMPPConnection xMPPConnection) {
        BlockingCommandManager blockingCommandManager = INSTANCES.get(xMPPConnection);
        if (blockingCommandManager == null) {
            blockingCommandManager = new BlockingCommandManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, blockingCommandManager);
        }
        return blockingCommandManager;
    }

    private BlockingCommandManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("block", NAMESPACE, IQ.Type.set, IQRequestHandler.Mode.sync){

            public IQ handleIQRequest(IQ iQ) {
                BlockContactsIQ blockContactsIQ = (BlockContactsIQ)iQ;
                if (BlockingCommandManager.this.blockListCached == null) {
                    BlockingCommandManager.this.blockListCached = new ArrayList();
                }
                List<i> list = blockContactsIQ.getJids();
                BlockingCommandManager.this.blockListCached.addAll(list);
                for (JidsBlockedListener jidsBlockedListener : BlockingCommandManager.this.jidsBlockedListeners) {
                    jidsBlockedListener.onJidsBlocked(list);
                }
                return IQ.createResultIQ((IQ)blockContactsIQ);
            }
        });
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("unblock", NAMESPACE, IQ.Type.set, IQRequestHandler.Mode.sync){

            public IQ handleIQRequest(IQ iQ) {
                List<i> list;
                UnblockContactsIQ unblockContactsIQ = (UnblockContactsIQ)iQ;
                if (BlockingCommandManager.this.blockListCached == null) {
                    BlockingCommandManager.this.blockListCached = new ArrayList();
                }
                if ((list = unblockContactsIQ.getJids()) == null) {
                    BlockingCommandManager.this.blockListCached.clear();
                    for (AllJidsUnblockedListener allJidsUnblockedListener : BlockingCommandManager.this.allJidsUnblockedListeners) {
                        allJidsUnblockedListener.onAllJidsUnblocked();
                    }
                } else {
                    BlockingCommandManager.this.blockListCached.removeAll(list);
                    for (JidsUnblockedListener jidsUnblockedListener : BlockingCommandManager.this.jidsUnblockedListeners) {
                        jidsUnblockedListener.onJidsUnblocked(list);
                    }
                }
                return IQ.createResultIQ((IQ)unblockContactsIQ);
            }
        });
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                if (bl) {
                    return;
                }
                BlockingCommandManager.this.blockListCached = null;
            }
        });
    }

    public boolean isSupportedByServer() {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).serverSupportsFeature(NAMESPACE);
    }

    public List<i> getBlockList() {
        if (this.blockListCached == null) {
            BlockListIQ blockListIQ = new BlockListIQ();
            BlockListIQ blockListIQ2 = (BlockListIQ)this.connection().createStanzaCollectorAndSend((IQ)blockListIQ).nextResultOrThrow();
            this.blockListCached = blockListIQ2.getBlockedJidsCopy();
        }
        return Collections.unmodifiableList(this.blockListCached);
    }

    public void blockContacts(List<i> list) {
        BlockContactsIQ blockContactsIQ = new BlockContactsIQ(list);
        this.connection().createStanzaCollectorAndSend((IQ)blockContactsIQ).nextResultOrThrow();
    }

    public void unblockContacts(List<i> list) {
        UnblockContactsIQ unblockContactsIQ = new UnblockContactsIQ(list);
        this.connection().createStanzaCollectorAndSend((IQ)unblockContactsIQ).nextResultOrThrow();
    }

    public void unblockAll() {
        UnblockContactsIQ unblockContactsIQ = new UnblockContactsIQ();
        this.connection().createStanzaCollectorAndSend((IQ)unblockContactsIQ).nextResultOrThrow();
    }

    public void addJidsBlockedListener(JidsBlockedListener jidsBlockedListener) {
        this.jidsBlockedListeners.add(jidsBlockedListener);
    }

    public void removeJidsBlockedListener(JidsBlockedListener jidsBlockedListener) {
        this.jidsBlockedListeners.remove(jidsBlockedListener);
    }

    public void addJidsUnblockedListener(JidsUnblockedListener jidsUnblockedListener) {
        this.jidsUnblockedListeners.add(jidsUnblockedListener);
    }

    public void removeJidsUnblockedListener(JidsUnblockedListener jidsUnblockedListener) {
        this.jidsUnblockedListeners.remove(jidsUnblockedListener);
    }

    public void addAllJidsUnblockedListener(AllJidsUnblockedListener allJidsUnblockedListener) {
        this.allJidsUnblockedListeners.add(allJidsUnblockedListener);
    }

    public void removeAllJidsUnblockedListener(AllJidsUnblockedListener allJidsUnblockedListener) {
        this.allJidsUnblockedListeners.remove(allJidsUnblockedListener);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                BlockingCommandManager.getInstanceFor(xMPPConnection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, BlockingCommandManager>();
    }
}

