/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bob;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.e.a.i;
import org.e.c.a.c;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.SHA1;
import org.jivesoftware.smackx.bob.BoBData;
import org.jivesoftware.smackx.bob.BoBInfo;
import org.jivesoftware.smackx.bob.ContentId;
import org.jivesoftware.smackx.bob.element.BoBIQ;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public final class BoBManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:bob";
    private static final Map<XMPPConnection, BoBManager> INSTANCES;
    private static final c<ContentId, BoBData> BOB_CACHE;
    private final Map<ContentId, BoBInfo> bobs = new ConcurrentHashMap<ContentId, BoBInfo>();

    public static synchronized BoBManager getInstanceFor(XMPPConnection xMPPConnection) {
        BoBManager boBManager = INSTANCES.get(xMPPConnection);
        if (boBManager == null) {
            boBManager = new BoBManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, boBManager);
        }
        return boBManager;
    }

    private BoBManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        serviceDiscoveryManager.addFeature(NAMESPACE);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("data", NAMESPACE, IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iQ) {
                BoBIQ boBIQ = (BoBIQ)iQ;
                ContentId contentId = boBIQ.getContentId();
                BoBInfo boBInfo = (BoBInfo)BoBManager.this.bobs.get(contentId);
                if (boBInfo == null) {
                    return null;
                }
                BoBData boBData = boBInfo.getData();
                BoBIQ boBIQ2 = new BoBIQ(contentId, boBData);
                boBIQ2.setType(IQ.Type.result);
                boBIQ2.setTo(boBIQ.getFrom());
                return boBIQ2;
            }
        });
    }

    public boolean isSupportedByServer() {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).serverSupportsFeature(NAMESPACE);
    }

    public BoBData requestBoB(i i2, ContentId contentId) {
        BoBData boBData = (BoBData)BOB_CACHE.a((Object)contentId);
        if (boBData != null) {
            return boBData;
        }
        BoBIQ boBIQ = new BoBIQ(contentId);
        boBIQ.setType(IQ.Type.get);
        boBIQ.setTo(i2);
        XMPPConnection xMPPConnection = this.getAuthenticatedConnectionOrThrow();
        BoBIQ boBIQ2 = (BoBIQ)xMPPConnection.createStanzaCollectorAndSend((IQ)boBIQ).nextResultOrThrow();
        boBData = boBIQ2.getBoBData();
        BOB_CACHE.put((Object)contentId, (Object)boBData);
        return boBData;
    }

    public BoBInfo addBoB(BoBData boBData) {
        ContentId contentId = new ContentId(SHA1.hex((byte[])boBData.getContent()), "sha1");
        Set<ContentId> set = Collections.singleton(contentId);
        set = Collections.unmodifiableSet(set);
        BoBInfo boBInfo = new BoBInfo(set, boBData);
        this.bobs.put(contentId, boBInfo);
        return boBInfo;
    }

    public BoBInfo removeBoB(ContentId contentId) {
        BoBInfo boBInfo = this.bobs.remove(contentId);
        if (boBInfo == null) {
            return null;
        }
        for (ContentId contentId2 : boBInfo.getHashes()) {
            this.bobs.remove(contentId2);
        }
        return boBInfo;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                BoBManager.getInstanceFor(xMPPConnection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, BoBManager>();
        BOB_CACHE = new c(128);
    }
}

